/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.CRAMReferenceRegion;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class SliceFactory {
    private final CRAMEncodingStrategy encodingStrategy;
    private final List<SliceStagingEntry> cramRecordSliceEntries;
    private final CRAMReferenceRegion cramReferenceRegion;
    private long sliceRecordCounter;
    private final int maxRecordsPerSlice;
    private final int minimumSingleReferenceSliceThreshold;
    private final boolean coordinateSorted;
    private final Map<String, Integer> readGroupNameToID = new HashMap<String, Integer>();

    public SliceFactory(CRAMEncodingStrategy cramEncodingStrategy, CRAMReferenceSource cramReferenceSource, SAMFileHeader samFileHeader, long globalRecordCounter) {
        this.encodingStrategy = cramEncodingStrategy;
        this.cramReferenceRegion = new CRAMReferenceRegion(cramReferenceSource, samFileHeader.getSequenceDictionary());
        this.minimumSingleReferenceSliceThreshold = this.encodingStrategy.getMinimumSingleReferenceSliceSize();
        this.maxRecordsPerSlice = this.encodingStrategy.getReadsPerSlice();
        this.coordinateSorted = samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate;
        this.sliceRecordCounter = globalRecordCounter;
        this.cramRecordSliceEntries = new ArrayList<SliceStagingEntry>(this.encodingStrategy.getSlicesPerContainer());
        List<SAMReadGroupRecord> readGroups = samFileHeader.getReadGroups();
        for (int i = 0; i < readGroups.size(); ++i) {
            SAMReadGroupRecord readGroupRecord = readGroups.get(i);
            this.readGroupNameToID.put(readGroupRecord.getId(), i);
        }
    }

    public long createNewSliceEntry(int currentReferenceContextID, List<SAMRecord> sliceSAMRecords) {
        this.cramRecordSliceEntries.add(new SliceStagingEntry(currentReferenceContextID, this.convertToCRAMRecords(sliceSAMRecords, this.sliceRecordCounter), this.sliceRecordCounter));
        return this.sliceRecordCounter + (long)sliceSAMRecords.size();
    }

    public List<CRAMCompressionRecord> getCRAMRecordsForAllSlices() {
        return this.cramRecordSliceEntries.size() > 1 ? this.cramRecordSliceEntries.stream().flatMap(e -> e.records.stream()).collect(Collectors.toList()) : this.cramRecordSliceEntries.get(0).getRecords();
    }

    public int getNumberOfSliceEntries() {
        return this.cramRecordSliceEntries.size();
    }

    public List<Slice> createSlices(CompressionHeader compressionHeader, long containerByteOffset) {
        ArrayList<Slice> slices = new ArrayList<Slice>(this.cramRecordSliceEntries.size());
        for (SliceStagingEntry sliceStagingEntry : this.cramRecordSliceEntries) {
            Slice slice = new Slice(sliceStagingEntry.getRecords(), compressionHeader, containerByteOffset, sliceStagingEntry.getGlobalRecordCounter());
            AlignmentContext sliceAlignmentContext = slice.getAlignmentContext();
            if (sliceAlignmentContext.getReferenceContext().isMappedSingleRef()) {
                this.cramReferenceRegion.fetchReferenceBasesByRegion(sliceAlignmentContext);
                slice.setReferenceMD5(this.cramReferenceRegion);
            }
            slices.add(slice);
        }
        this.cramRecordSliceEntries.clear();
        return slices;
    }

    private final List<CRAMCompressionRecord> convertToCRAMRecords(List<SAMRecord> samRecords, long sliceRecordCounter) {
        long recordIndex = sliceRecordCounter;
        ArrayList<CRAMCompressionRecord> cramCompressionRecords = new ArrayList<CRAMCompressionRecord>();
        for (SAMRecord samRecord : samRecords) {
            int referenceIndex = samRecord.getReferenceIndex();
            byte[] referenceBases = null;
            if (referenceIndex != -1) {
                this.cramReferenceRegion.fetchReferenceBases(referenceIndex);
                referenceBases = this.cramReferenceRegion.getCurrentReferenceBases();
            }
            CRAMCompressionRecord cramCompressionRecord = new CRAMCompressionRecord(CramVersions.DEFAULT_CRAM_VERSION, this.encodingStrategy, samRecord, referenceBases, recordIndex++, this.readGroupNameToID);
            cramCompressionRecords.add(cramCompressionRecord);
        }
        return cramCompressionRecords;
    }

    public int getUpdatedReferenceContext(int currentReferenceContext, int nextReferenceIndex, int numberOfSAMRecords) {
        switch (currentReferenceContext) {
            case -3: {
                if (numberOfSAMRecords != 0) {
                    throw new CRAMException("Reference context should have been initialized if records have previously been processed");
                }
                return nextReferenceIndex;
            }
            case -1: {
                if (nextReferenceIndex == currentReferenceContext) {
                    return numberOfSAMRecords < this.maxRecordsPerSlice ? -1 : -3;
                }
                if (this.coordinateSorted) {
                    throw new CRAMException("Invalid coord-sorted input - unmapped records must be last");
                }
                return numberOfSAMRecords >= this.maxRecordsPerSlice ? -3 : -2;
            }
            case -2: {
                if (this.coordinateSorted) {
                    return numberOfSAMRecords < this.minimumSingleReferenceSliceThreshold ? -2 : -3;
                }
                return numberOfSAMRecords >= this.maxRecordsPerSlice ? -3 : -2;
            }
        }
        if (nextReferenceIndex == currentReferenceContext) {
            return numberOfSAMRecords >= this.maxRecordsPerSlice ? -3 : nextReferenceIndex;
        }
        return numberOfSAMRecords < this.minimumSingleReferenceSliceThreshold ? (this.getNumberOfSliceEntries() > 0 ? -3 : -2) : -3;
    }

    private static class SliceStagingEntry {
        private final List<CRAMCompressionRecord> records;
        private final ReferenceContext referenceContext;
        private final long sliceRecordCounter;

        public SliceStagingEntry(int referenceContextID, List<CRAMCompressionRecord> sourceRecords, long sliceRecordCounter) {
            this.records = new ArrayList<CRAMCompressionRecord>(sourceRecords);
            this.referenceContext = new ReferenceContext(referenceContextID);
            this.sliceRecordCounter = sliceRecordCounter;
        }

        public ReferenceContext getReferenceContext() {
            return this.referenceContext;
        }

        public List<CRAMCompressionRecord> getRecords() {
            return this.records;
        }

        public long getGlobalRecordCounter() {
            return this.sliceRecordCounter;
        }
    }
}

