/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;

public class CRAMReferenceRegion {
    private static final Log log = Log.getInstance(CRAMReferenceRegion.class);
    public static final int UNINITIALIZED_START = -1;
    public static final int UNINITIALIZED_LENGTH = -1;
    private final CRAMReferenceSource referenceSource;
    private final SAMSequenceDictionary sequenceDictionary;
    private int referenceIndex = -3;
    private byte[] referenceBases = null;
    private SAMSequenceRecord sequenceRecord = null;
    private int regionStart = -1;
    private int regionLength = -1;

    public CRAMReferenceRegion(CRAMReferenceSource cramReferenceSource, SAMSequenceDictionary sequenceDictionary) {
        ValidationUtils.nonNull(cramReferenceSource, "cramReferenceSource");
        ValidationUtils.nonNull(sequenceDictionary, "sequenceDictionary");
        this.referenceSource = cramReferenceSource;
        this.sequenceDictionary = sequenceDictionary;
    }

    public byte[] getCurrentReferenceBases() {
        return this.referenceBases;
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    public int getRegionStart() {
        return this.regionStart;
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public void fetchReferenceBases(int referenceIndex) {
        ValidationUtils.validateArg(referenceIndex >= 0, "reference index must be >= 0");
        SAMSequenceRecord newSequenceRecord = this.getSAMSequenceRecord(referenceIndex);
        if (referenceIndex != this.referenceIndex || this.regionStart != 0 || this.regionLength != newSequenceRecord.getSequenceLength()) {
            this.setCurrentSequence(referenceIndex);
            this.referenceBases = this.referenceSource.getReferenceBases(newSequenceRecord, true);
            if (this.referenceBases == null) {
                throw new IllegalArgumentException(String.format("A reference must be supplied (reference sequence %s not found).", newSequenceRecord));
            }
            this.regionStart = 0;
            this.regionLength = newSequenceRecord.getSequenceLength();
        }
    }

    public void fetchReferenceBasesByRegion(int referenceIndex, int zeroBasedStart, int requestedFragmentLength) {
        ValidationUtils.validateArg(referenceIndex >= 0, "reference index must be non-negative");
        ValidationUtils.validateArg(zeroBasedStart >= 0, "start must be >= 0");
        if (referenceIndex == this.referenceIndex && zeroBasedStart == this.regionStart && requestedFragmentLength == this.regionLength) {
            return;
        }
        if (referenceIndex != this.referenceIndex) {
            this.setCurrentSequence(referenceIndex);
        }
        if (zeroBasedStart >= this.sequenceRecord.getSequenceLength()) {
            throw new IllegalArgumentException(String.format("Requested start %d is beyond the sequence length %s", zeroBasedStart, this.sequenceRecord.getSequenceName()));
        }
        this.referenceBases = this.referenceSource.getReferenceBasesByRegion(this.sequenceRecord, zeroBasedStart, requestedFragmentLength);
        if (this.referenceBases == null) {
            throw new IllegalArgumentException(String.format("Failure getting reference bases for sequence %s", this.sequenceRecord.getSequenceName()));
        }
        if (this.referenceBases.length < requestedFragmentLength) {
            log.warn("The bases of length " + this.referenceBases.length + " returned by the reference source do not satisfy the requested fragment length " + (zeroBasedStart + requestedFragmentLength));
        }
        this.regionStart = zeroBasedStart;
        this.regionLength = this.referenceBases.length;
    }

    public void fetchReferenceBasesByRegion(AlignmentContext alignmentContext) {
        ValidationUtils.validateArg(alignmentContext.getReferenceContext().isMappedSingleRef(), "a mapped single reference alignment context is required");
        this.fetchReferenceBasesByRegion(alignmentContext.getReferenceContext().getReferenceSequenceID(), alignmentContext.getAlignmentStart() - 1, alignmentContext.getAlignmentSpan());
    }

    public void setEmbeddedReferenceBases(byte[] embeddedReferenceBases, int embeddedReferenceIndex, int zeroBasedStart) {
        ValidationUtils.nonNull(embeddedReferenceBases, "embeddedReferenceBases");
        this.setCurrentSequence(embeddedReferenceIndex);
        this.referenceBases = embeddedReferenceBases;
        this.regionStart = zeroBasedStart;
        this.regionLength = embeddedReferenceBases.length;
    }

    public int getFullContigLength() {
        return this.sequenceRecord == null ? -1 : this.sequenceRecord.getSequenceLength();
    }

    private void setCurrentSequence(int referenceIndex) {
        this.referenceIndex = referenceIndex;
        this.sequenceRecord = this.getSAMSequenceRecord(referenceIndex);
    }

    private SAMSequenceRecord getSAMSequenceRecord(int referenceIndex) {
        SAMSequenceRecord samSequenceRecord = this.sequenceDictionary.getSequence(referenceIndex);
        if (samSequenceRecord == null) {
            throw new IllegalArgumentException(String.format("Reference sequence index %d not found", referenceIndex));
        }
        return samSequenceRecord;
    }
}

