/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.CustomReaderFactory;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.HtsgetBAMFileReader;
import htsjdk.samtools.HtsgetInputResource;
import htsjdk.samtools.InputResource;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMTextReader;
import htsjdk.samtools.SRAFileReader;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamStreams;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockGunzipper;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.zip.InflaterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public abstract class SamReaderFactory {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private static SamReaderFactoryImpl DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, defaultValidationStringency, DefaultSAMRecordFactory.getInstance(), BlockGunzipper.getDefaultInflaterFactory());

    public abstract SamReader open(File var1);

    public SamReader open(Path path) {
        return this.open(path, null, null);
    }

    public SamReader open(Path path, Function<SeekableByteChannel, SeekableByteChannel> dataWrapper, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) {
        SamInputResource r = SamInputResource.of(path, dataWrapper);
        Path indexMaybe = SamFiles.findIndex(path);
        if (indexMaybe != null) {
            r.index(indexMaybe, indexWrapper);
        }
        return this.open(r);
    }

    public abstract SamReader open(SamInputResource var1);

    public abstract ValidationStringency validationStringency();

    public abstract CRAMReferenceSource referenceSource();

    public abstract SamReaderFactory samRecordFactory(SAMRecordFactory var1);

    public abstract SamReaderFactory inflaterFactory(InflaterFactory var1);

    public abstract SamReaderFactory enable(Option ... var1);

    public abstract SamReaderFactory disable(Option ... var1);

    public abstract SamReaderFactory setOption(Option var1, boolean var2);

    public abstract SamReaderFactory referenceSequence(File var1);

    public abstract SamReaderFactory referenceSequence(Path var1);

    public abstract SamReaderFactory referenceSource(CRAMReferenceSource var1);

    public abstract SAMFileHeader getFileHeader(File var1);

    public abstract SAMFileHeader getFileHeader(Path var1);

    public abstract void reapplyOptions(SamReader var1);

    public abstract SamReaderFactory validationStringency(ValidationStringency var1);

    public abstract SamReaderFactory setUseAsyncIo(boolean var1);

    public static void setDefaultValidationStringency(ValidationStringency defaultValidationStringency) {
        SamReaderFactory.defaultValidationStringency = defaultValidationStringency;
        DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, defaultValidationStringency, DefaultSAMRecordFactory.getInstance(), BlockGunzipper.getDefaultInflaterFactory());
    }

    public static SamReaderFactory makeDefault() {
        return SamReaderFactoryImpl.copyOf(DEFAULT);
    }

    public static SamReaderFactory make() {
        return new SamReaderFactoryImpl(EnumSet.noneOf(Option.class), ValidationStringency.DEFAULT_STRINGENCY, DefaultSAMRecordFactory.getInstance(), BlockGunzipper.getDefaultInflaterFactory());
    }

    private static class SamReaderFactoryImpl
    extends SamReaderFactory {
        private static final Log LOG = Log.getInstance(SamReaderFactory.class);
        private final EnumSet<Option> enabledOptions;
        private ValidationStringency validationStringency;
        private boolean asynchronousIO = Defaults.USE_ASYNC_IO_READ_FOR_SAMTOOLS;
        private SAMRecordFactory samRecordFactory;
        private CustomReaderFactory customReaderFactory;
        private CRAMReferenceSource referenceSource;
        private InflaterFactory inflaterFactory;

        private SamReaderFactoryImpl(EnumSet<Option> enabledOptions, ValidationStringency validationStringency, SAMRecordFactory samRecordFactory, InflaterFactory inflaterFactory) {
            this.enabledOptions = EnumSet.copyOf(enabledOptions);
            this.samRecordFactory = samRecordFactory;
            this.validationStringency = validationStringency;
            this.customReaderFactory = CustomReaderFactory.getInstance();
            this.inflaterFactory = inflaterFactory;
        }

        @Override
        public SamReader open(File file) {
            SamInputResource r = SamInputResource.of(file);
            File indexMaybe = SamFiles.findIndex(file);
            if (indexMaybe != null) {
                r.index(indexMaybe);
            }
            return this.open(r);
        }

        @Override
        public ValidationStringency validationStringency() {
            return this.validationStringency;
        }

        @Override
        public CRAMReferenceSource referenceSource() {
            return this.referenceSource;
        }

        @Override
        public SamReaderFactory samRecordFactory(SAMRecordFactory samRecordFactory) {
            this.samRecordFactory = samRecordFactory;
            return this;
        }

        @Override
        public SamReaderFactory inflaterFactory(InflaterFactory inflaterFactory) {
            this.inflaterFactory = inflaterFactory;
            return this;
        }

        @Override
        public SamReaderFactory enable(Option ... options) {
            Collections.addAll(this.enabledOptions, options);
            return this;
        }

        @Override
        public SamReaderFactory disable(Option ... options) {
            for (Option option : options) {
                this.enabledOptions.remove((Object)option);
            }
            return this;
        }

        @Override
        public SamReaderFactory setOption(Option option, boolean value) {
            if (value) {
                return this.enable(option);
            }
            return this.disable(option);
        }

        @Override
        public SamReaderFactory referenceSequence(File referenceSequence) {
            this.referenceSource = new ReferenceSource(referenceSequence);
            return this;
        }

        @Override
        public SamReaderFactory referenceSequence(Path referenceSequence) {
            this.referenceSource = new ReferenceSource(referenceSequence);
            return this;
        }

        @Override
        public SamReaderFactory referenceSource(CRAMReferenceSource referenceSource) {
            this.referenceSource = referenceSource;
            return this;
        }

        @Override
        public SAMFileHeader getFileHeader(File samFile) {
            SamReader reader = this.open(samFile);
            SAMFileHeader header = reader.getFileHeader();
            CloserUtil.close(reader);
            return header;
        }

        @Override
        public SAMFileHeader getFileHeader(Path samFile) {
            SamReader reader = this.open(samFile);
            SAMFileHeader header = reader.getFileHeader();
            CloserUtil.close(reader);
            return header;
        }

        @Override
        public void reapplyOptions(SamReader reader) {
            for (Option option : this.enabledOptions) {
                option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader);
            }
        }

        @Override
        public SamReaderFactory validationStringency(ValidationStringency validationStringency) {
            this.validationStringency = validationStringency;
            return this;
        }

        @Override
        public SamReaderFactory setUseAsyncIo(boolean asynchronousIO) {
            this.asynchronousIO = asynchronousIO;
            return this;
        }

        @Override
        public SamReader open(SamInputResource resource) {
            try {
                SamReader.ReaderImplementation primitiveSamReader;
                SamReader reader;
                InputResource data = resource.data();
                InputResource indexMaybe = resource.indexMaybe();
                boolean indexDefined = indexMaybe != null;
                InputResource.Type type = data.type();
                if (type == InputResource.Type.URL && (reader = this.customReaderFactory.maybeOpen(data.asUrl())) != null) {
                    return reader;
                }
                if (type == InputResource.Type.HTSGET) {
                    primitiveSamReader = HtsgetBAMFileReader.fromHtsgetURI((HtsgetInputResource)data, false, this.validationStringency, this.samRecordFactory, this.asynchronousIO, this.inflaterFactory);
                } else if (type == InputResource.Type.SEEKABLE_STREAM || type == InputResource.Type.URL) {
                    if (SamStreams.sourceLikeBam(data.asUnbufferedSeekableStream())) {
                        bufferedIndexStream = indexDefined && indexMaybe.asUnbufferedSeekableStream() != null ? IOUtil.maybeBufferedSeekableStream(indexMaybe.asUnbufferedSeekableStream()) : null;
                        primitiveSamReader = new BAMFileReader(IOUtil.maybeBufferedSeekableStream(data.asUnbufferedSeekableStream()), bufferedIndexStream, false, this.asynchronousIO, this.validationStringency, this.samRecordFactory, this.inflaterFactory);
                    } else if (SamStreams.sourceLikeCram(data.asUnbufferedSeekableStream())) {
                        if (this.referenceSource == null) {
                            this.referenceSource = ReferenceSource.getDefaultCRAMReferenceSource();
                        }
                        bufferedIndexStream = indexDefined ? IOUtil.maybeBufferedSeekableStream(indexMaybe.asUnbufferedSeekableStream()) : null;
                        primitiveSamReader = new CRAMFileReader((InputStream)IOUtil.maybeBufferedSeekableStream(data.asUnbufferedSeekableStream()), bufferedIndexStream, this.referenceSource, this.validationStringency);
                    } else {
                        LOG.warn("Unable to detect file format from input URL or stream, assuming SAM format.");
                        primitiveSamReader = new SAMTextReader(IOUtil.toBufferedStream(data.asUnbufferedInputStream()), this.validationStringency, this.samRecordFactory);
                    }
                } else if (type == InputResource.Type.SRA_ACCESSION) {
                    primitiveSamReader = new SRAFileReader(data.asSRAAccession());
                } else {
                    File indexFile;
                    InputStream bufferedStream = IOUtil.maybeBufferInputStream(data.asUnbufferedInputStream(), Math.max(Defaults.BUFFER_SIZE, 65536));
                    File sourceFile = data.asFile();
                    File file = indexFile = indexMaybe == null ? null : indexMaybe.asFile();
                    if (SamStreams.isBAMFile(bufferedStream)) {
                        if (sourceFile == null || !sourceFile.isFile()) {
                            SeekableStream indexSeekable = indexMaybe == null ? null : indexMaybe.asUnbufferedSeekableStream();
                            SeekableStream sourceSeekable = data.asUnbufferedSeekableStream();
                            if (null == sourceSeekable || null == indexSeekable) {
                                primitiveSamReader = new BAMFileReader(bufferedStream, indexFile, false, this.asynchronousIO, this.validationStringency, this.samRecordFactory, this.inflaterFactory);
                            } else {
                                sourceSeekable.seek(0L);
                                primitiveSamReader = new BAMFileReader(sourceSeekable, indexSeekable, false, this.asynchronousIO, this.validationStringency, this.samRecordFactory, this.inflaterFactory);
                            }
                        } else {
                            bufferedStream.close();
                            primitiveSamReader = new BAMFileReader(sourceFile, indexFile, false, this.asynchronousIO, this.validationStringency, this.samRecordFactory, this.inflaterFactory);
                        }
                    } else if (BlockCompressedInputStream.isValidFile(bufferedStream)) {
                        primitiveSamReader = new SAMTextReader(new BlockCompressedInputStream(bufferedStream), this.validationStringency, this.samRecordFactory);
                    } else if (IOUtil.isGZIPInputStream(bufferedStream)) {
                        primitiveSamReader = new SAMTextReader(new GZIPInputStream(bufferedStream), this.validationStringency, this.samRecordFactory);
                    } else if (SamStreams.isCRAMFile(bufferedStream)) {
                        if (this.referenceSource == null) {
                            this.referenceSource = ReferenceSource.getDefaultCRAMReferenceSource();
                        }
                        if (sourceFile == null || !sourceFile.isFile()) {
                            SeekableStream indexSeekableStream = indexMaybe == null ? null : indexMaybe.asUnbufferedSeekableStream();
                            SeekableStream sourceSeekableStream = data.asUnbufferedSeekableStream();
                            if (null == sourceSeekableStream || null == indexSeekableStream) {
                                primitiveSamReader = new CRAMFileReader(bufferedStream, indexFile, this.referenceSource, this.validationStringency);
                            } else {
                                sourceSeekableStream.seek(0L);
                                primitiveSamReader = new CRAMFileReader((InputStream)sourceSeekableStream, indexSeekableStream, this.referenceSource, this.validationStringency);
                            }
                        } else {
                            bufferedStream.close();
                            primitiveSamReader = new CRAMFileReader(sourceFile, indexFile, this.referenceSource, this.validationStringency);
                        }
                    } else if (sourceFile != null && this.isSra(sourceFile)) {
                        if (bufferedStream != null) {
                            bufferedStream.close();
                        }
                        primitiveSamReader = new SRAFileReader(new SRAAccession(sourceFile.getPath()));
                    } else {
                        if (indexDefined) {
                            bufferedStream.close();
                            throw new RuntimeException("Cannot use index file with textual SAM file");
                        }
                        primitiveSamReader = new SAMTextReader(bufferedStream, sourceFile, this.validationStringency, this.samRecordFactory);
                    }
                }
                reader = new SamReader.PrimitiveSamReaderToSamReaderAdapter(primitiveSamReader, resource);
                for (Option option : this.enabledOptions) {
                    option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader);
                }
                return reader;
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeIOException(e);
            }
        }

        private boolean isSra(File sourceFile) {
            try {
                return SRAAccession.isValid(sourceFile.getPath());
            }
            catch (Exception e) {
                return false;
            }
        }

        public static SamReaderFactory copyOf(SamReaderFactoryImpl target) {
            return new SamReaderFactoryImpl(target.enabledOptions, target.validationStringency, target.samRecordFactory, target.inflaterFactory);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Option {
        INCLUDE_SOURCE_IN_RECORDS{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(SRAFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(HtsgetBAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }
        }
        ,
        CACHE_FILE_BASED_INDEXES{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexCaching(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexCaching(true);
            }

            @Override
            void applyTo(SRAFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexCaching(true);
            }

            @Override
            void applyTo(HtsgetBAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }
        }
        ,
        DONT_MEMORY_MAP_INDEX{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexMemoryMapping(false);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexMemoryMapping(false);
            }

            @Override
            void applyTo(SRAFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexMemoryMapping(false);
            }

            @Override
            void applyTo(HtsgetBAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }
        }
        ,
        EAGERLY_DECODE{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.setEagerDecode(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(SRAFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(HtsgetBAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.setEagerDecode(true);
            }
        }
        ,
        VALIDATE_CRC_CHECKSUMS{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableCrcChecking(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(SRAFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, this);
            }

            @Override
            void applyTo(HtsgetBAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableCrcChecking(true);
            }
        };

        public static final EnumSet<Option> DEFAULTS;
        private static final Log LOG;

        void applyTo(SamReader.PrimitiveSamReaderToSamReaderAdapter reader) {
            SamReader.PrimitiveSamReader underlyingReader = reader.underlyingReader();
            if (underlyingReader instanceof BAMFileReader) {
                this.applyTo((BAMFileReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof SAMTextReader) {
                this.applyTo((SAMTextReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof CRAMFileReader) {
                this.applyTo((CRAMFileReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof SRAFileReader) {
                this.applyTo((SRAFileReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof HtsgetBAMFileReader) {
                this.applyTo((HtsgetBAMFileReader)underlyingReader, (SamReader)reader);
            } else {
                throw new IllegalArgumentException(String.format("Unrecognized reader type: %s.", underlyingReader.getClass()));
            }
        }

        private static void logDebugIgnoringOption(SamReader r, Option option) {
            LOG.debug(String.format("Ignoring %s option; does not apply to %s readers.", new Object[]{option, r.getClass().getSimpleName()}));
        }

        abstract void applyTo(BAMFileReader var1, SamReader var2);

        abstract void applyTo(SAMTextReader var1, SamReader var2);

        abstract void applyTo(CRAMFileReader var1, SamReader var2);

        abstract void applyTo(SRAFileReader var1, SamReader var2);

        abstract void applyTo(HtsgetBAMFileReader var1, SamReader var2);

        static {
            DEFAULTS = EnumSet.noneOf(Option.class);
            LOG = Log.getInstance(Option.class);
        }
    }
}

