/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.Locatable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SAMSequenceRecord
extends AbstractSAMHeaderRecord
implements Cloneable,
Locatable {
    public static final long serialVersionUID = 1L;
    public static final int UNAVAILABLE_SEQUENCE_INDEX = -1;
    private final String mSequenceName;
    private Set<String> mAlternativeSequenceName = new LinkedHashSet<String>();
    private int mSequenceIndex = -1;
    private int mSequenceLength = 0;
    public static final String SEQUENCE_NAME_TAG = "SN";
    public static final String ALTERNATIVE_SEQUENCE_NAME_TAG = "AN";
    public static final String SEQUENCE_LENGTH_TAG = "LN";
    public static final String MD5_TAG = "M5";
    public static final String ASSEMBLY_TAG = "AS";
    public static final String URI_TAG = "UR";
    public static final String SPECIES_TAG = "SP";
    public static final String DESCRIPTION_TAG = "DS";
    public static final int UNKNOWN_SEQUENCE_LENGTH = 0;
    public static final String RESERVED_RNEXT_SEQUENCE_NAME = "=";
    @Deprecated
    public static final String RESERVED_MRNM_SEQUENCE_NAME = "=";
    public static final Set<String> STANDARD_TAGS = new HashSet<String>(Arrays.asList("SN", "LN", "AS", "AN", "M5", "UR", "SP"));
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t', '\n', '\u000b', '\f', '\r'};
    private static final String ALTERNATIVE_SEQUENCE_NAME_SEPARATOR = ",";
    private static final Pattern LEGAL_RNAME_PATTERN = Pattern.compile("[0-9A-Za-z!#$%&+./:;?@^_|~-][0-9A-Za-z!#$%&*+./:;=?@^_|~-]*");

    @Deprecated
    public SAMSequenceRecord(String name) {
        this(name, 0);
    }

    public SAMSequenceRecord(String name, int sequenceLength) {
        if (name != null) {
            SAMSequenceRecord.validateSequenceName(name);
            this.mSequenceName = name.intern();
        } else {
            this.mSequenceName = null;
        }
        this.mSequenceLength = sequenceLength;
    }

    public String getSequenceName() {
        return this.mSequenceName;
    }

    public int getSequenceLength() {
        return this.mSequenceLength;
    }

    public SAMSequenceRecord setSequenceLength(int value) {
        this.mSequenceLength = value;
        return this;
    }

    public String getAssembly() {
        return this.getAttribute(ASSEMBLY_TAG);
    }

    public SAMSequenceRecord setAssembly(String value) {
        this.setAttribute(ASSEMBLY_TAG, value);
        return this;
    }

    public String getSpecies() {
        return this.getAttribute(SPECIES_TAG);
    }

    public SAMSequenceRecord setSpecies(String value) {
        this.setAttribute(SPECIES_TAG, value);
        return this;
    }

    public String getMd5() {
        return this.getAttribute(MD5_TAG);
    }

    public SAMSequenceRecord setMd5(String value) {
        this.setAttribute(MD5_TAG, value);
        return this;
    }

    public String getDescription() {
        return this.getAttribute(DESCRIPTION_TAG);
    }

    public SAMSequenceRecord setDescription(String value) {
        this.setAttribute(DESCRIPTION_TAG, value);
        return this;
    }

    public int getSequenceIndex() {
        return this.mSequenceIndex;
    }

    public SAMSequenceRecord setSequenceIndex(int value) {
        this.mSequenceIndex = value;
        return this;
    }

    public Set<String> getAlternativeSequenceNames() {
        String anTag = this.getAttribute(ALTERNATIVE_SEQUENCE_NAME_TAG);
        return anTag == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(anTag.split(ALTERNATIVE_SEQUENCE_NAME_SEPARATOR))));
    }

    public void addAlternativeSequenceName(String name) {
        HashSet<String> altSequences = new HashSet<String>(this.getAlternativeSequenceNames());
        if (!this.mSequenceName.equals(name)) {
            altSequences.add(name);
        }
        this.encodeAltSequences(altSequences);
    }

    public SAMSequenceRecord setAlternativeSequenceName(Collection<String> alternativeSequences) {
        if (alternativeSequences == null) {
            this.setAttribute(ALTERNATIVE_SEQUENCE_NAME_TAG, null);
        } else {
            this.encodeAltSequences(alternativeSequences);
        }
        return this;
    }

    private static void validateAltRegExp(String name) {
        if (!LEGAL_RNAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Invalid alternative sequence name '%s': do not match the pattern %s", name, LEGAL_RNAME_PATTERN));
        }
    }

    private void encodeAltSequences(Collection<String> alternativeSequences) {
        this.setAttribute(ALTERNATIVE_SEQUENCE_NAME_TAG, alternativeSequences.isEmpty() ? null : alternativeSequences.stream().sorted().distinct().peek(SAMSequenceRecord::validateAltRegExp).collect(Collectors.joining(ALTERNATIVE_SEQUENCE_NAME_SEPARATOR)));
    }

    public boolean hasAlternativeSequenceNames() {
        return this.getAttribute(ALTERNATIVE_SEQUENCE_NAME_TAG) != null;
    }

    public boolean isSameSequence(SAMSequenceRecord that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != 0 && that.mSequenceLength != 0 && this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (this.getAttribute(MD5_TAG) != null && that.getAttribute(MD5_TAG) != null) {
            BigInteger thatMd5;
            BigInteger thisMd5 = new BigInteger(this.getAttribute(MD5_TAG), 16);
            if (!thisMd5.equals(thatMd5 = new BigInteger(that.getAttribute(MD5_TAG), 16))) {
                return false;
            }
        } else if (this.mSequenceName != that.mSequenceName) {
            return this.getAlternativeSequenceNames().contains(that.mSequenceName) || that.getAlternativeSequenceNames().contains(this.mSequenceName);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMSequenceRecord)) {
            return false;
        }
        SAMSequenceRecord that = (SAMSequenceRecord)o;
        if (this.mSequenceIndex != that.mSequenceIndex) {
            return false;
        }
        if (this.mSequenceLength != that.mSequenceLength) {
            return false;
        }
        if (!this.attributesEqual(that)) {
            return false;
        }
        if (this.mSequenceName != that.mSequenceName) {
            return false;
        }
        return this.getAlternativeSequenceNames().equals(that.getAlternativeSequenceNames());
    }

    public int hashCode() {
        return this.mSequenceName != null ? this.mSequenceName.hashCode() : 0;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }

    public final SAMSequenceRecord clone() {
        SAMSequenceRecord ret = new SAMSequenceRecord(this.mSequenceName, this.mSequenceLength);
        ret.mSequenceIndex = this.mSequenceIndex;
        for (Map.Entry<String, String> entry : this.getAttributes()) {
            ret.setAttribute(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static String truncateSequenceName(String sequenceName) {
        int truncateAt = sequenceName.length();
        for (char c : WHITESPACE_CHARS) {
            int index = sequenceName.indexOf(c);
            if (index == -1 || index >= truncateAt) continue;
            truncateAt = index;
        }
        return sequenceName.substring(0, truncateAt);
    }

    public static void validateSequenceName(String name) {
        if (!LEGAL_RNAME_PATTERN.matcher(name).useAnchoringBounds(true).matches()) {
            throw new SAMException(String.format("Sequence name '%s' doesn't match regex: '%s' ", name, LEGAL_RNAME_PATTERN));
        }
    }

    @Override
    public String toString() {
        return String.format("SAMSequenceRecord(name=%s,length=%s,dict_index=%s,assembly=%s,alternate_names=%s)", this.getSequenceName(), this.getSequenceLength(), this.getSequenceIndex(), this.getAssembly(), this.getAlternativeSequenceNames());
    }

    @Override
    public String getSAMString() {
        return new SAMTextHeaderCodec().getSQLine(this);
    }

    @Override
    public final String getContig() {
        return this.getSequenceName();
    }

    @Override
    public final int getStart() {
        return 1;
    }

    @Override
    public final int getEnd() {
        return this.getSequenceLength();
    }
}

