/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BAMIteratorFilter;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.BAMStartingAtIteratorFilter;
import htsjdk.samtools.HtsgetInputResource;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.AsyncBlockCompressedInputStream;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockGunzipper;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SAMRecordPrefetchingIterator;
import htsjdk.samtools.util.htsget.HtsgetClass;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetPOSTRequest;
import htsjdk.samtools.util.htsget.HtsgetRequest;
import htsjdk.samtools.util.htsget.HtsgetResponse;
import htsjdk.samtools.util.zip.InflaterFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class HtsgetBAMFileReader
extends SamReader.ReaderImplementation {
    public static final String HTSGET_SCHEME = "htsget";
    private static final int READAHEAD_LIMIT = 500000;
    private final URI mSource;
    private final SAMFileHeader mFileHeader;
    private final InflaterFactory mInflaterFactory;
    private boolean mEagerDecode;
    private boolean mCheckCRC;
    private final boolean mUseAsynchronousIO;
    private ValidationStringency mValidationStringency;
    private SAMRecordFactory mSamRecordFactory;
    private SamReader mReader;
    private final List<CloseableIterator<SAMRecord>> iterators;
    private boolean usePOSTRequest;

    public static HtsgetBAMFileReader fromHtsgetURI(HtsgetInputResource source, boolean eagerDecode, ValidationStringency validationStringency, SAMRecordFactory samRecordFactory, boolean useAsynchronousIO, InflaterFactory inflaterFactory) throws IOException, URISyntaxException {
        HtsgetBAMFileReader reader;
        try {
            URI htsgetUri = HtsgetBAMFileReader.convertHtsgetUriToHttps(source.uri);
            reader = new HtsgetBAMFileReader(htsgetUri, eagerDecode, validationStringency, samRecordFactory, useAsynchronousIO, inflaterFactory);
        }
        catch (RuntimeIOException e) {
            URI htsgetUri = HtsgetBAMFileReader.convertHtsgetUriToHttp(source.uri);
            reader = new HtsgetBAMFileReader(htsgetUri, eagerDecode, validationStringency, samRecordFactory, useAsynchronousIO, inflaterFactory);
        }
        return reader;
    }

    public HtsgetBAMFileReader(URI source, boolean eagerDecode, ValidationStringency validationStringency, SAMRecordFactory samRecordFactory, boolean useAsynchronousIO) throws IOException {
        this(source, eagerDecode, validationStringency, samRecordFactory, useAsynchronousIO, BlockGunzipper.getDefaultInflaterFactory());
    }

    public HtsgetBAMFileReader(URI source, boolean eagerDecode, ValidationStringency validationStringency, SAMRecordFactory samRecordFactory, boolean useAsynchronousIO, InflaterFactory inflaterFactory) throws IOException {
        this.mSource = source;
        this.mEagerDecode = eagerDecode;
        this.mValidationStringency = validationStringency;
        this.mSamRecordFactory = samRecordFactory;
        this.mUseAsynchronousIO = useAsynchronousIO;
        this.mInflaterFactory = inflaterFactory;
        HtsgetRequest req = new HtsgetRequest(this.mSource).withDataClass(HtsgetClass.header);
        try (InputStream headerStream = req.getResponse().getDataStream();){
            BinaryCodec headerCodec = new BinaryCodec(new DataInputStream(this.mUseAsynchronousIO ? new AsyncBlockCompressedInputStream(headerStream, this.mInflaterFactory) : new BlockCompressedInputStream(headerStream, this.mInflaterFactory)));
            this.mFileHeader = BAMFileReader.readHeader(headerCodec, this.mValidationStringency, null);
        }
        this.iterators = new ArrayList<CloseableIterator<SAMRecord>>();
        try {
            HtsgetPOSTRequest post = new HtsgetPOSTRequest(this.mSource).withDataClass(HtsgetClass.header);
            post.getResponse();
            this.usePOSTRequest = true;
        }
        catch (RuntimeIOException ignored) {
            this.usePOSTRequest = false;
        }
    }

    @Override
    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mValidationStringency = validationStringency;
    }

    @Override
    public void setSAMRecordFactory(SAMRecordFactory samRecordFactory) {
        this.mSamRecordFactory = samRecordFactory;
    }

    public void setEagerDecode(boolean eagerDecode) {
        this.mEagerDecode = eagerDecode;
    }

    @Override
    public void enableCrcChecking(boolean check) {
        this.mCheckCRC = check;
    }

    @Override
    public void enableFileSource(SamReader reader, boolean enabled) {
        this.mReader = enabled ? reader : null;
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable index caching in HtsgetBAMFileReader");
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable index memory mapping in HtsgetBAMFileReader");
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.BAM_HTSGET_TYPE;
    }

    @Override
    public boolean isQueryable() {
        return true;
    }

    @Override
    public boolean hasIndex() {
        return false;
    }

    @Override
    public BAMIndex getIndex() {
        return null;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    public boolean isUsingPOST() {
        return this.usePOSTRequest;
    }

    public void setUsingPOST(boolean use) {
        this.usePOSTRequest = use;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator() {
        HtsgetRequest req = new HtsgetRequest(this.mSource).withFormat(HtsgetFormat.BAM);
        HtsgetBAMFileIterator queryIterator = new HtsgetBAMFileIterator(req);
        this.iterators.add(queryIterator);
        return queryIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        throw new UnsupportedOperationException("Cannot query htsget data source by file span");
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        throw new UnsupportedOperationException("Cannot retrieve file pointers from htsget data source");
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        QueryInterval.assertIntervalsOptimized(intervals);
        List<Locatable> namedIntervals = Arrays.stream(intervals).map(i -> new Interval(this.mFileHeader.getSequence(i.referenceIndex).getSequenceName(), i.start, i.end)).collect(Collectors.toList());
        return this.query(namedIntervals, contained);
    }

    public CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        return this.query(Collections.singletonList(new Interval(sequence, start, end == -1 ? Integer.MAX_VALUE : end)), contained);
    }

    public CloseableIterator<SAMRecord> query(List<Locatable> intervals, boolean contained) {
        CloseableIterator<SAMRecord> chainingIterator = this.usePOSTRequest && intervals.size() > 1 ? new FilteringSamIterator(new HtsgetBAMFileIterator(new HtsgetPOSTRequest(this.mSource).withIntervals(intervals).withFormat(HtsgetFormat.BAM)), new BAMQueryMultipleIntervalsIteratorFilter(intervals, contained)) : new BAMQueryChainingIterator(intervals, contained);
        CloseableIterator<SAMRecord> queryIterator = this.mUseAsynchronousIO ? new SAMRecordPrefetchingIterator(chainingIterator, 500000) : chainingIterator;
        this.iterators.add(queryIterator);
        return queryIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        int referenceIndex = this.mFileHeader.getSequenceIndex(sequence);
        if (referenceIndex == -1) {
            return new EmptyBamIterator();
        }
        HtsgetRequest req = new HtsgetRequest(this.mSource).withFormat(HtsgetFormat.BAM).withInterval(new Interval(sequence, start, start + 1));
        HtsgetBAMFileIterator iterator = new HtsgetBAMFileIterator(req);
        BAMStartingAtIteratorFilter filter = new BAMStartingAtIteratorFilter(referenceIndex, start);
        BAMQueryFilteringIterator filteringIterator = new BAMQueryFilteringIterator(iterator, filter);
        CloseableIterator<SAMRecord> queryIterator = this.mUseAsynchronousIO ? new SAMRecordPrefetchingIterator(filteringIterator, 500000) : filteringIterator;
        this.iterators.add(queryIterator);
        return queryIterator;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        HtsgetRequest req = new HtsgetRequest(this.mSource).withFormat(HtsgetFormat.BAM).withInterval(HtsgetRequest.UNMAPPED_UNPLACED_INTERVAL);
        HtsgetBAMFileIterator unmappedIterator = new HtsgetBAMFileIterator(req);
        CloseableIterator<SAMRecord> queryIterator = this.mUseAsynchronousIO ? new SAMRecordPrefetchingIterator(unmappedIterator, 500000) : unmappedIterator;
        this.iterators.add(queryIterator);
        return queryIterator;
    }

    @Override
    public void close() {
        this.iterators.forEach(CloseableIterator::close);
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.mValidationStringency;
    }

    private BlockCompressedInputStream getRequestStream(HtsgetRequest req) {
        BlockCompressedInputStream compressedInputStream;
        HtsgetResponse resp = req.getResponse();
        if (resp.getFormat() != HtsgetFormat.BAM) {
            throw new IllegalStateException("Expected format of response to be BAM but received + " + resp.getFormat());
        }
        InputStream stream = resp.getDataStream();
        BlockCompressedInputStream blockCompressedInputStream = compressedInputStream = this.mUseAsynchronousIO ? new AsyncBlockCompressedInputStream(stream, this.mInflaterFactory) : new BlockCompressedInputStream(stream, this.mInflaterFactory);
        if (this.mCheckCRC) {
            compressedInputStream.setCheckCrcs(true);
        }
        try {
            BAMFileReader.readHeader(new BinaryCodec(compressedInputStream), ValidationStringency.SILENT, null);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return compressedInputStream;
    }

    public static URI convertHtsgetUriToHttps(URI uri) throws URISyntaxException {
        return new URI("https", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public static URI convertHtsgetUriToHttp(URI uri) throws URISyntaxException {
        return new URI("http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    private class HtsgetBAMFileIterator
    implements CloseableIterator<SAMRecord> {
        private final BlockCompressedInputStream stream;
        private final BAMRecordCodec bamRecordCodec;
        private SAMRecord currentRecord;
        private int samRecordIndex = 0;

        public HtsgetBAMFileIterator(HtsgetRequest req) {
            this.stream = HtsgetBAMFileReader.this.getRequestStream(req);
            this.bamRecordCodec = new BAMRecordCodec(HtsgetBAMFileReader.this.mFileHeader, HtsgetBAMFileReader.this.mSamRecordFactory);
            this.bamRecordCodec.setInputStream(new DataInputStream(this.stream));
            this.advance();
        }

        @Override
        public void close() {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException("Exception while closing HtsgetBAMFileIterator", e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = this.currentRecord;
            this.advance();
            return result;
        }

        private SAMRecord getNextRecord() {
            SAMRecord next = this.bamRecordCodec.decode();
            if (HtsgetBAMFileReader.this.mReader != null && next != null) {
                next.setFileSource(new SAMFileSource(HtsgetBAMFileReader.this.mReader, null));
            }
            return next;
        }

        private void advance() {
            this.currentRecord = this.getNextRecord();
            if (this.currentRecord != null) {
                ++this.samRecordIndex;
                this.currentRecord.setValidationStringency(HtsgetBAMFileReader.this.mValidationStringency);
                if (HtsgetBAMFileReader.this.mValidationStringency != ValidationStringency.SILENT) {
                    boolean firstErrorOnly = HtsgetBAMFileReader.this.mValidationStringency == ValidationStringency.STRICT;
                    SAMUtils.processValidationErrors(this.currentRecord.isValid(firstErrorOnly), this.samRecordIndex, HtsgetBAMFileReader.this.mValidationStringency);
                }
            }
            if (HtsgetBAMFileReader.this.mEagerDecode && this.currentRecord != null) {
                this.currentRecord.eagerDecode();
            }
        }
    }

    public static class BAMQueryMultipleIntervalsIteratorFilter
    implements SamRecordFilter {
        final Iterator<Locatable> intervals;
        ConsecutiveDuplicateRecordFilter filter;
        final boolean contained;

        public BAMQueryMultipleIntervalsIteratorFilter(List<Locatable> intervals, boolean contained) {
            this.contained = contained;
            this.intervals = intervals.iterator();
            this.filter = null;
        }

        @Override
        public boolean filterOut(SAMRecord record) {
            while (this.intervals.hasNext()) {
                if (this.filter == null) {
                    this.filter = new ConsecutiveDuplicateRecordFilter(this.intervals.next(), null, this.contained);
                }
                if (!this.filter.filterOut(record)) {
                    return false;
                }
                this.filter = null;
            }
            return true;
        }

        @Override
        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException();
        }
    }

    private class BAMQueryChainingIterator
    implements CloseableIterator<SAMRecord> {
        private final List<Locatable> intervals;
        private final boolean contained;
        private final Iterator<Lazy<HtsgetBAMFileIterator>> iterators;
        private CloseableIterator<SAMRecord> currentIterator;
        private SAMRecord currentRecord;
        private int currentIntervalIndex = 0;

        public BAMQueryChainingIterator(List<Locatable> intervals, boolean contained) {
            this.intervals = intervals;
            this.contained = contained;
            this.iterators = intervals.stream().map(i -> new Lazy<HtsgetBAMFileIterator>(() -> {
                HtsgetRequest req = new HtsgetRequest(HtsgetBAMFileReader.this.mSource).withFormat(HtsgetFormat.BAM).withInterval((Locatable)i);
                return new HtsgetBAMFileIterator(req);
            })).iterator();
            this.advanceIterator();
            this.advance();
        }

        @Override
        public void close() {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = this.currentRecord;
            this.advance();
            return result;
        }

        private void advance() {
            while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                this.advanceIterator();
            }
            this.currentRecord = this.currentIterator == null ? null : (SAMRecord)this.currentIterator.next();
        }

        private void advanceIterator() {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
            if (!this.iterators.hasNext()) {
                this.currentIterator = null;
                return;
            }
            Locatable currInterval = this.intervals.get(this.currentIntervalIndex);
            Locatable prevInterval = this.currentIntervalIndex == 0 ? null : this.intervals.get(this.currentIntervalIndex - 1);
            this.currentIterator = new FilteringSamIterator(this.iterators.next().get(), new ConsecutiveDuplicateRecordFilter(currInterval, prevInterval, this.contained));
            ++this.currentIntervalIndex;
        }
    }

    private static class EmptyBamIterator
    implements CloseableIterator<SAMRecord> {
        private EmptyBamIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new NoSuchElementException("next called on empty iterator");
        }

        @Override
        public void close() {
        }
    }

    private static class BAMQueryFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord nextRecord;
        private final BAMIteratorFilter iteratorFilter;

        public BAMQueryFilteringIterator(CloseableIterator<SAMRecord> iterator, BAMIteratorFilter iteratorFilter) {
            this.wrappedIterator = iterator;
            this.iteratorFilter = iteratorFilter;
            this.nextRecord = this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("BAMQueryFilteringIterator: no next element available");
            }
            SAMRecord currentRead = this.nextRecord;
            this.nextRecord = this.advance();
            return currentRead;
        }

        SAMRecord advance() {
            block5: while (true) {
                if (!this.wrappedIterator.hasNext()) {
                    return null;
                }
                SAMRecord record = (SAMRecord)this.wrappedIterator.next();
                switch (this.iteratorFilter.compareToFilter(record)) {
                    case MATCHES_FILTER: {
                        return record;
                    }
                    case STOP_ITERATION: {
                        return null;
                    }
                    case CONTINUE_ITERATION: {
                        continue block5;
                    }
                }
                break;
            }
            throw new SAMException("Unexpected return from compareToFilter");
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }
    }

    private static class ConsecutiveDuplicateRecordFilter
    implements SamRecordFilter {
        private final Locatable prevInterval;
        private final Locatable currInterval;
        private final boolean contained;

        public ConsecutiveDuplicateRecordFilter(Locatable currInterval, Locatable prevInterval, boolean contained) {
            this.currInterval = currInterval;
            this.prevInterval = prevInterval;
            this.contained = contained;
        }

        @Override
        public boolean filterOut(SAMRecord record) {
            return record.getReadUnmappedFlag() && record.getAlignmentStart() != 0 ? !this.acceptUnmappedRecord(record) : !this.acceptRecord(record);
        }

        @Override
        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException();
        }

        private boolean acceptRecord(SAMRecord rec) {
            return this.contained ? this.currInterval.contains(rec) && (this.prevInterval == null || !this.prevInterval.contains(rec)) : this.currInterval.overlaps(rec) && (this.prevInterval == null || !this.prevInterval.overlaps(rec));
        }

        private boolean acceptUnmappedRecord(SAMRecord rec) {
            int start = rec.getStart();
            boolean matchesCurrInterval = rec.contigsMatch(this.currInterval) && CoordMath.encloses(this.currInterval.getStart(), this.currInterval.getEnd(), start, start);
            boolean matchesPrevInterval = this.prevInterval != null && rec.contigsMatch(this.prevInterval) && CoordMath.encloses(this.prevInterval.getStart(), this.prevInterval.getEnd(), start, start);
            return matchesCurrInterval && !matchesPrevInterval;
        }
    }
}

