/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam;

import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.zip.DeflaterFactory;
import htsjdk.utils.ValidationUtils;

public class BAMEncoderOptions {
    public static final int DEAFULT_MAX_RECORDS_IN_RAM = 500000;
    private int outputBufferSize = Defaults.BUFFER_SIZE;
    private boolean asyncIO = Defaults.USE_ASYNC_IO_WRITE_FOR_SAMTOOLS;
    private int asyncOutputBufferSize = 2000;
    private IOPath tempDirPath = new HtsPath(IOUtil.getDefaultTmpDirPath().toString());
    private int compressionLevel = BlockCompressedOutputStream.getDefaultCompressionLevel();
    private Integer maxRecordsInRAM = 500000;
    private DeflaterFactory deflaterFactory = BlockCompressedOutputStream.getDefaultDeflaterFactory();

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public BAMEncoderOptions setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
        return this;
    }

    public boolean isAsyncIO() {
        return this.asyncIO;
    }

    public BAMEncoderOptions setAsyncIO(boolean asyncIO) {
        this.asyncIO = asyncIO;
        return this;
    }

    public int getAsyncOutputBufferSize() {
        return this.asyncOutputBufferSize;
    }

    public BAMEncoderOptions setAsyncOutputBufferSize(int asyncOutputBufferSize) {
        this.asyncOutputBufferSize = asyncOutputBufferSize;
        return this;
    }

    public IOPath getTemporaryDirectory() {
        return this.tempDirPath;
    }

    public BAMEncoderOptions setTemporaryDirectory(IOPath tempDirPath) {
        ValidationUtils.nonNull(tempDirPath, "tempDirPath");
        this.tempDirPath = tempDirPath;
        return this;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public BAMEncoderOptions setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public int getMaxRecordsInRAM() {
        return this.maxRecordsInRAM;
    }

    public BAMEncoderOptions setMaxRecordsInRAM(int maxRecordsInRAM) {
        this.maxRecordsInRAM = maxRecordsInRAM;
        return this;
    }

    public DeflaterFactory getDeflaterFactory() {
        return this.deflaterFactory;
    }

    public BAMEncoderOptions setDeflaterFactory(DeflaterFactory deflaterFactory) {
        this.deflaterFactory = deflaterFactory;
        return this;
    }
}

