/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.twobit;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.ucsc.BPIndex;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class TwoBitIndex
implements BPIndex {
    String path;
    ByteOrder byteOrder;
    Map<String, Long> sequenceDataOffsets;

    public TwoBitIndex(String path, ByteOrder byteOrder, int seqCount) throws IOException {
        this.path = path;
        this.byteOrder = byteOrder;
        this.sequenceDataOffsets = new HashMap<String, Long>();
        this.readIndex(seqCount);
    }

    private void readIndex(int seqCount) throws IOException {
        long filePosition = 16L;
        int estNameLength = 20;
        int estSize = seqCount * estNameLength + 100;
        ByteBuffer buffer = this.loadBinaryBuffer(filePosition, estSize);
        this.sequenceDataOffsets = new LinkedHashMap<String, Long>();
        for (int i = 0; i < seqCount; ++i) {
            if (buffer.remaining() < 1) {
                estSize = (seqCount - i) * estNameLength + 100;
                buffer = this.loadBinaryBuffer(filePosition += (long)buffer.position(), estSize);
            }
            byte nameSize = buffer.get();
            if (buffer.remaining() < nameSize * 5) {
                estSize = (seqCount - i) * estNameLength + 100;
                buffer = this.loadBinaryBuffer(filePosition += (long)buffer.position(), estSize);
            }
            byte[] seqNameBytes = new byte[nameSize];
            buffer.get(seqNameBytes);
            String seqName = new String(seqNameBytes);
            long offset = buffer.getInt();
            this.sequenceDataOffsets.put(seqName, offset);
        }
    }

    @Override
    public long[] search(String term) {
        if (this.sequenceDataOffsets.containsKey(term)) {
            return new long[]{this.sequenceDataOffsets.get(term)};
        }
        return null;
    }

    public List<String> getSequenceNames() {
        return new ArrayList<String>(this.sequenceDataOffsets.keySet());
    }

    ByteBuffer loadBinaryBuffer(long start, int size) throws IOException {
        try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);){
            ByteBuffer bb = ByteBuffer.allocate(size);
            bb.order(this.byteOrder);
            byte[] bytes = bb.array();
            is.seek(start);
            is.readFully(bytes);
            ByteBuffer byteBuffer = bb;
            return byteBuffer;
        }
    }
}

