/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.aws;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.tuple.Triple;
import org.broad.igv.aws.IGVS3Object;
import org.broad.igv.aws.S3TreeNode;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3LoadDialog
extends IGVDialog {
    private static Logger log = LogManager.getLogger(S3LoadDialog.class);
    private final DefaultTreeModel treeModel;
    String selectedId;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTree selectionTree;
    private JPanel buttonBar;
    private JButton loadButton;
    private JButton cancelButton;
    private JLabel label1;

    public S3LoadDialog(Frame owner) {
        super(owner);
        this.initComponents();
        S3TreeNode root = new S3TreeNode(new IGVS3Object("S3", true, "STANDARD"), true);
        this.treeModel = new DefaultTreeModel(root);
        this.selectionTree.setModel(this.treeModel);
        List<String> buckets = AmazonUtils.ListBucketsForUser();
        for (String bucket : buckets) {
            IGVS3Object bucket_obj = new IGVS3Object(bucket, true, "STANDARD");
            root.add(new S3TreeNode(bucket_obj, true));
        }
        log.debug("Populated S3 load dialog with S3 buckets: " + buckets.toString());
        this.treeModel.reload();
    }

    private void loadButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        TreePath[] paths = this.selectionTree.getSelectionPaths();
        this.loadSelections(paths);
    }

    private void loadSelections(TreePath[] paths) {
        LongRunningTask.submit(() -> {
            ArrayList<Triple<String, String, String>> preLocatorPaths = new ArrayList<Triple<String, String, String>>();
            ArrayList<ResourceLocator> finalLocators = new ArrayList<ResourceLocator>();
            for (TreePath path : paths) {
                if (!this.isFilePath(path)) continue;
                Triple<String, String, String> bucketKeyTier = this.getBucketKeyTierFromTreePath(path);
                AmazonUtils.s3ObjectAccessResult res = AmazonUtils.isObjectAccessible((String)bucketKeyTier.getLeft(), (String)bucketKeyTier.getMiddle());
                if (!res.isObjectAvailable()) {
                    MessageUtils.showErrorMessage(res.getErrorReason(), null);
                    return;
                }
                preLocatorPaths.add(bucketKeyTier);
            }
            for (Triple triple : preLocatorPaths) {
                ResourceLocator locator = this.getResourceLocatorFromBucketKey((Triple<String, String, String>)triple);
                finalLocators.add(locator);
            }
            if (finalLocators.size() == 1 && "xml".equals(ResourceLocator.deriveFormat(finalLocators.get(0).getPath()))) {
                IGV.getInstance().loadSession(finalLocators.get(0).getPath(), null);
            } else {
                IGV.getInstance().loadTracks(finalLocators);
            }
        });
    }

    private boolean isFilePath(TreePath path) {
        return ((S3TreeNode)path.getLastPathComponent()).isLeaf();
    }

    private ResourceLocator getResourceLocatorFromBucketKey(Triple<String, String, String> preLocator) {
        String bucketName = (String)preLocator.getLeft();
        String s3objPath = (String)preLocator.getMiddle();
        String s3Path = "s3://" + bucketName + "/" + s3objPath;
        return new ResourceLocator(s3Path);
    }

    private Triple<String, String, String> getBucketKeyTierFromTreePath(TreePath path) {
        Object[] selectedObjects = path.getPath();
        String bucketName = ((S3TreeNode)selectedObjects[1]).getUserObject().getName();
        Object s3Key = "";
        String storageClass = "STANDARD";
        for (int i = 2; i < selectedObjects.length; ++i) {
            S3TreeNode selectedObject = (S3TreeNode)selectedObjects[i];
            IGVS3Object selectedIGVS3Object = selectedObject.getUserObject();
            storageClass = selectedIGVS3Object.getStorageClass();
            s3Key = (String)s3Key + selectedIGVS3Object.getName() + "/";
        }
        s3Key = ((String)s3Key).substring(0, ((String)s3Key).length() - 1);
        log.debug("Loading S3 object key: " + (String)s3Key + " from bucket " + bucketName);
        return Triple.of((Object)bucketName, (Object)s3Key, (Object)storageClass);
    }

    private void treeWillExpandActionPerformed(TreeExpansionEvent event) {
        log.debug("TreeWillExpand on S3LoadDialog panel");
        Object parent = event.getPath().getLastPathComponent();
        S3TreeNode parentNode = (S3TreeNode)parent;
        IGVS3Object IGVS3Object2 = parentNode.getUserObject();
        if (parentNode.getChildCount() == 0 && IGVS3Object2.isDir()) {
            Object[] path = parentNode.getUserObjectPath();
            String currentBucket = path[1].toString();
            Object prefix = "";
            for (int i = 2; i < path.length; ++i) {
                prefix = (String)prefix + String.valueOf(path[i]) + "/";
            }
            log.debug("S3 bucket prefix is: " + (String)prefix);
            try {
                ArrayList<IGVS3Object> IGVS3Objects = AmazonUtils.ListBucketObjects(currentBucket, (String)prefix);
                parentNode.addS3Children(IGVS3Objects);
            }
            catch (S3Exception e) {
                MessageUtils.showErrorMessage("Amazon S3: Access denied to bucket: " + currentBucket, (Exception)((Object)e));
                log.error("Permission denied on S3 bucket ListObjects: ");
            }
            this.updateModel(parentNode);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.selectedId = null;
        this.setVisible(false);
    }

    private void updateModel(DefaultMutableTreeNode parent) {
        DefaultTreeModel model = this.treeModel;
        if (parent != null) {
            model.reload(parent);
        } else {
            model.reload();
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.selectionTree = new JTree();
        this.buttonBar = new JPanel();
        this.loadButton = new JButton();
        this.cancelButton = new JButton();
        this.label1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Amazon S3 datasets");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.selectionTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                S3LoadDialog.this.treeWillExpandActionPerformed(event);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                log.debug("Tree collapsing");
            }
        });
        this.selectionTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = S3LoadDialog.this.selectionTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = S3LoadDialog.this.selectionTree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2) {
                    S3LoadDialog.this.setVisible(false);
                    S3LoadDialog.this.loadSelections(new TreePath[]{selPath});
                }
            }
        });
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.scrollPane1.setViewportView(this.selectionTree);
        this.contentPanel.add(this.scrollPane1);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(e -> this.loadButtonActionPerformed(e));
        this.buttonBar.add((Component)this.loadButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.label1.setText("Select objects to load");
        this.dialogPane.add((Component)this.label1, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(795, 690);
        this.setLocationRelativeTo(this.getOwner());
    }
}

