/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.aa.AminoAcidManager;
import org.broad.igv.feature.aa.AminoAcidSequence;
import org.broad.igv.feature.aa.CodonTable;
import org.broad.igv.feature.aa.CodonTableManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SequenceTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(SequenceTrack.class);
    private static final int SEQUENCE_HEIGHT = 14;
    private static String NAME = "Sequence";
    private Map<String, LoadedDataInterval<SeqCache>> loadedIntervalCache = new HashMap<String, LoadedDataInterval<SeqCache>>(200);
    private SequenceRenderer sequenceRenderer = new SequenceRenderer();
    private boolean showTranslation = true;
    Strand strand = Strand.POSITIVE;
    private Rectangle arrowRect;

    public SequenceTrack(String name) {
        super(null, name, name);
        this.setSortable(false);
        this.showTranslation = PreferencesManager.getPreferences().getAsBoolean("SHOW_SEQUENCE_TRANSLATION");
        this.loadedIntervalCache = Collections.synchronizedMap(new HashMap());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
    }

    public static String getReverseComplement(String sequence) {
        char[] complement = new char[sequence.length()];
        int jj = complement.length;
        block10: for (int ii = 0; ii < sequence.length(); ++ii) {
            char c = sequence.charAt(ii);
            --jj;
            switch (c) {
                case 'T': {
                    complement[jj] = 65;
                    continue block10;
                }
                case 'A': {
                    complement[jj] = 84;
                    continue block10;
                }
                case 'C': {
                    complement[jj] = 71;
                    continue block10;
                }
                case 'G': {
                    complement[jj] = 67;
                    continue block10;
                }
                case 't': {
                    complement[jj] = 97;
                    continue block10;
                }
                case 'a': {
                    complement[jj] = 116;
                    continue block10;
                }
                case 'c': {
                    complement[jj] = 103;
                    continue block10;
                }
                case 'g': {
                    complement[jj] = 99;
                    continue block10;
                }
                default: {
                    complement[jj] = c;
                }
            }
        }
        return new String(complement);
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof FrameManager.ChangeEvent) {
            List<ReferenceFrame> frames = ((FrameManager.ChangeEvent)event).frames();
            Map<String, LoadedDataInterval<SeqCache>> newCache = Collections.synchronizedMap(new HashMap());
            for (ReferenceFrame f : frames) {
                newCache.put(f.getName(), this.loadedIntervalCache.get(f.getName()));
            }
            this.loadedIntervalCache = newCache;
        } else {
            log.warn("Unknown event type: " + String.valueOf(event.getClass()));
        }
    }

    private void refreshAminoAcids(CodonTable codonTable) {
        for (LoadedDataInterval<SeqCache> i : this.loadedIntervalCache.values()) {
            CodonTable intervalCodonTable = codonTable != null ? codonTable : CodonTableManager.getInstance().getCodonTableForChromosome(i.range.chr);
            if (intervalCodonTable == null) continue;
            i.getFeatures().refreshAminoAcids(intervalCodonTable);
        }
    }

    @Override
    public void renderName(Graphics2D g, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Graphics2D graphics = (Graphics2D)g.create();
        Font font = FontManager.getFont(this.getFontSize());
        boolean visible = this.isVisible();
        if (visible) {
            graphics.setFont(font);
            int textBaseline = trackRectangle.y + 12;
            graphics.drawString(NAME, trackRectangle.x + 5, textBaseline);
            int rx = trackRectangle.x + trackRectangle.width - 20;
            this.arrowRect = new Rectangle(rx, trackRectangle.y + 2, 15, 10);
            this.drawArrow(graphics);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        }
        graphics.dispose();
    }

    private void drawArrow(Graphics2D graphics) {
        GraphicUtils.drawHorizontalArrow(graphics, this.arrowRect, this.strand == Strand.POSITIVE);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        boolean visible;
        int resolutionThreshold = PreferencesManager.getPreferences().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean bl = visible = frame.getScale() < (double)resolutionThreshold && !frame.getChrName().equals("All");
        if (!visible) {
            return true;
        }
        LoadedDataInterval<SeqCache> interval = this.loadedIntervalCache.get(frame.getName());
        boolean ready = interval != null && interval.contains(frame);
        return ready;
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        String chr = referenceFrame.getChrName();
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        int start = (int)referenceFrame.getOrigin();
        Chromosome chromosome = currentGenome.getChromosome(chr);
        if (chromosome == null) {
            return;
        }
        int chromosomeLength = chromosome.getLength();
        int end = (int)referenceFrame.getEnd();
        Genome genome = currentGenome;
        int w = end - start;
        byte[] seqBytes = genome.getSequence(chr, start = Math.max(0, start - w / 2 + 2), end = Math.min(end + w / 2 + 2, chromosomeLength));
        if (seqBytes == null) {
            return;
        }
        String sequence = new String(seqBytes);
        int mod = start % 3;
        int n1 = SequenceTrack.normalize3(3 - mod);
        int n2 = SequenceTrack.normalize3(n1 + 1);
        int n3 = SequenceTrack.normalize3(n2 + 1);
        int deltaStart = start == 0 ? 0 : 2;
        int deltaEnd = end == chromosomeLength ? 0 : 2;
        end -= deltaEnd;
        int len = sequence.length();
        byte[] seq = sequence.substring(deltaStart, len - deltaEnd).getBytes();
        SeqCache cache = new SeqCache(start += deltaStart, seq);
        CodonTable codonTable = CodonTableManager.getInstance().getCodonTableForChromosome(chr);
        cache.refreshAminoAcids(codonTable);
        this.loadedIntervalCache.put(referenceFrame.getName(), new LoadedDataInterval<SeqCache>(chr, start, end, cache));
    }

    private static int normalize3(int n) {
        return n == 3 ? 0 : n;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        LoadedDataInterval<SeqCache> sequenceInterval;
        int resolutionThreshold = PreferencesManager.getPreferences().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean visible = context.getReferenceFrame().getScale() < (double)resolutionThreshold && !context.getChr().equals("All");
        String frameName = context.getReferenceFrame().getName();
        if (visible && (sequenceInterval = this.loadedIntervalCache.get(frameName)) != null) {
            this.sequenceRenderer.setStrand(this.strand);
            this.sequenceRenderer.draw(sequenceInterval, context, rect, this.showTranslation, resolutionThreshold);
        }
    }

    @Override
    public boolean isVisible() {
        int resolutionThreshold = PreferencesManager.getPreferences().getAsInt("MAX_SEQUENCE_RESOLUTION");
        return FrameManager.getFrames().stream().anyMatch(frame -> frame.getScale() < (double)resolutionThreshold && !frame.getChrName().equals("All"));
    }

    @Override
    public boolean isFilterable() {
        return false;
    }

    @Override
    public int getHeight() {
        return this.isVisible() ? 14 + (this.showTranslation ? 42 : 0) : 0;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent e) {
        this.setShowTranslation(!this.showTranslation);
        Object source = e.getMouseEvent().getSource();
        if (source instanceof JComponent) {
            UIUtilities.invokeOnEventThread(() -> this.repaint());
        }
        return true;
    }

    @Override
    public void handleNameClick(MouseEvent e) {
        if (this.arrowRect != null && this.arrowRect.contains(e.getPoint())) {
            this.flipStrand();
        }
    }

    private void flipStrand() {
        this.strand = this.strand == Strand.POSITIVE ? Strand.NEGATIVE : Strand.POSITIVE;
        IGV.getInstance().clearSelections();
        this.repaint();
    }

    public void setStrand(Strand strandValue) {
        this.strand = strandValue;
        PreferencesManager.getPreferences().put("SEQUENCE_TRANSLATION_STRAND", this.strand.toString());
        IGV.getInstance().clearSelections();
        this.repaint();
    }

    public void setShowTranslation(boolean showTranslation) {
        this.showTranslation = showTranslation;
        PreferencesManager.getPreferences().put("SHOW_SEQUENCE_TRANSLATION", showTranslation);
        this.repaint();
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JMenuItem m1 = new JMenuItem("Flip strand");
        m1.addActionListener(e -> this.flipStrand());
        JCheckBoxMenuItem m2 = new JCheckBoxMenuItem("Show translation");
        m2.setSelected(this.showTranslation);
        m2.addActionListener(e -> {
            this.setShowTranslation(m2.isSelected());
            IGV.getInstance().clearSelections();
        });
        menu.add(m1);
        menu.add(m2);
        JMenu transTableMenu = new JMenu("Translation Table");
        transTableMenu.add(this.getCodonTableMenuItem(null));
        for (CodonTable codonTable : CodonTableManager.getInstance().getAllCodonTables()) {
            JCheckBoxMenuItem item = this.getCodonTableMenuItem(codonTable);
            transTableMenu.add(item);
        }
        menu.add(transTableMenu);
        return menu;
    }

    private JCheckBoxMenuItem getCodonTableMenuItem(CodonTable codonTable) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        if (codonTable == null) {
            item.setText("Default");
        } else {
            String fullName = codonTable.getDisplayName();
            Object shortName = fullName;
            if (fullName.length() > 40) {
                shortName = fullName.substring(0, 37) + "...";
                item.setToolTipText(fullName);
            }
            item.setText((String)shortName);
        }
        Integer selectedID = codonTable == null ? null : Integer.valueOf(codonTable.getId());
        CodonTable currentCodonTable = CodonTableManager.getInstance().getCurrentCodonTable();
        boolean selected = selectedID == null && currentCodonTable == null || selectedID != null && currentCodonTable != null && selectedID.equals(currentCodonTable.getId());
        item.setSelected(selected);
        item.addActionListener(e -> {
            CodonTableManager.getInstance().setCurrentCodonTable(codonTable);
            this.refreshAminoAcids(codonTable);
            this.repaint();
        });
        return item;
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public String getTooltipText(int y) {
        CodonTable explicitlySelectedTable = CodonTableManager.getInstance().getCurrentCodonTable();
        if (explicitlySelectedTable != null) {
            String nvs = "<html>" + super.getTooltipText(y);
            nvs = nvs + "<br>Translation Table: ";
            nvs = nvs + explicitlySelectedTable.getDisplayName();
            return nvs;
        }
        return "";
    }

    public Strand getStrand() {
        return this.strand;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("shouldShowTranslation", String.valueOf(this.showTranslation));
        element.setAttribute("sequenceTranslationStrandValue", String.valueOf((Object)this.strand));
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("shouldShowTranslation")) {
            this.showTranslation = Boolean.valueOf(element.getAttribute("shouldShowTranslation"));
        }
        if (element.hasAttribute("sequenceTranslationStrandValue")) {
            this.strand = Strand.fromString(element.getAttribute("sequenceTranslationStrandValue"));
        }
    }

    public static class SeqCache {
        public int start;
        public byte[] seq;
        public AminoAcidSequence[] posAA;
        public AminoAcidSequence[] negAA;

        public SeqCache(int start, byte[] seq) {
            this.start = start;
            this.seq = seq;
        }

        public void refreshAminoAcids(CodonTable codonTable) {
            int n1 = this.start % 3;
            int n2 = (this.start + 1) % 3;
            int n3 = (this.start + 2) % 3;
            String sequence = new String(this.seq);
            AminoAcidSequence[] posAA = new AminoAcidSequence[]{AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, this.start + n1, sequence.substring(n1), codonTable), AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, this.start + n2, sequence.substring(n2), codonTable), AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, this.start + n3, sequence.substring(n3), codonTable)};
            this.posAA = posAA;
            int len = sequence.length();
            AminoAcidSequence[] negAA = new AminoAcidSequence[]{AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, this.start, sequence.substring(0, len - n1), codonTable), AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, this.start, sequence.substring(0, len - n2), codonTable), AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, this.start, sequence.substring(0, len - n3), codonTable)};
            this.negAA = negAA;
        }
    }
}

