/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCF3Codec;
import htsjdk.variant.vcf.VCFCodec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.broad.igv.data.cufflinks.FPKMTrackingCodec;
import org.broad.igv.feature.FeatureType;
import org.broad.igv.feature.dsi.DSICodec;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.BCF2WrapperCodec;
import org.broad.igv.feature.tribble.DGVCodec;
import org.broad.igv.feature.tribble.EncodePeakCodec;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.feature.tribble.IntervalListCodec;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.PAFCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.UCSCGeneTableCodec;
import org.broad.igv.feature.tribble.UCSCSnpCodec;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.gwas.EQTLCodec;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class CodecFactory {
    private static Logger log = LogManager.getLogger(CodecFactory.class);
    public static final List<String> validExtensions = new ArrayList<String>(15);
    public static String ucscSNP = "snp[0-9][0-9][0-9]";

    public static FeatureCodec getCodec(String path, Genome genome) {
        return CodecFactory.getCodec(new ResourceLocator(path), genome);
    }

    public static FeatureCodec getCodec(ResourceLocator locator, Genome genome) {
        String format;
        String path = locator.getPath();
        switch (format = locator.getFormat()) {
            case "vcf3": {
                return new VCFWrapperCodec((AsciiFeatureCodec)new VCF3Codec(), genome);
            }
            case "vcf4": {
                return new VCFWrapperCodec((AsciiFeatureCodec)new VCFCodec(), genome);
            }
            case "vcf": 
            case "gvcf": {
                return new VCFWrapperCodec(CodecFactory.getVCFCodec(locator), genome);
            }
            case "bcf": {
                return new BCF2WrapperCodec((FeatureCodec<VariantContext, PositionalBufferedStream>)new BCF2Codec(), genome);
            }
            case "bed": {
                return new IGVBEDCodec(genome);
            }
            case "junctions": {
                IGVBEDCodec codec = new IGVBEDCodec(genome);
                codec.setFeatureType(FeatureType.SPLICE_JUNCTION);
                return codec;
            }
            case "gappedpeak": {
                return new IGVBEDCodec(genome, FeatureType.GAPPED_PEAK);
            }
            case "dgv": {
                return new DGVCodec(genome);
            }
            case "rmask": 
            case "repmask": {
                return new REPMaskCodec(genome);
            }
            case "gff3": 
            case "gvf": {
                return new GFFCodec(GFFCodec.Version.GFF3, genome);
            }
            case "gff": {
                return new GFFCodec(genome);
            }
            case "gtf": {
                return new GFFCodec(GFFCodec.Version.GTF, genome);
            }
            case "psl": 
            case "pslx": {
                return new PSLCodec(genome);
            }
            case "narrowpeak": 
            case "broadpeak": 
            case "regionpeak": {
                return new EncodePeakCodec(genome);
            }
            case "snp": 
            case "ucscsnp": {
                return new UCSCSnpCodec(genome);
            }
            case "eqtl": {
                return new EQTLCodec(genome);
            }
            case "fpkm_tracking": {
                return new FPKMTrackingCodec(path);
            }
            case "dsi": {
                return new DSICodec(genome);
            }
            case "paf": {
                return new PAFCodec(path, genome);
            }
            case "interval_list": {
                return new IntervalListCodec(genome);
            }
            case "refflat": {
                return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.REFFLAT, genome);
            }
            case "refgene": {
                return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.GENEPRED, genome);
            }
            case "ucscgene": {
                return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.UCSCGENE, genome);
            }
            case "genepredext": {
                return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.GENEPRED_EXT, genome);
            }
            case "bedmethyl": {
                return new IGVBEDCodec(genome, FeatureType.BED_METHYL);
            }
        }
        if (MUTCodec.isMutationAnnotationFile(locator)) {
            return new MUTCodec(path, genome);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AsciiFeatureCodec getVCFCodec(ResourceLocator locator) {
        String path = locator.getPath();
        if (FileUtils.isRemote(path)) {
            try {
                path = HttpUtils.createURL(path).toString();
            }
            catch (MalformedURLException e) {
                log.error("Eror translating url", e);
            }
        }
        BufferedReader reader = null;
        try {
            String formatLine;
            reader = locator.getURLPath().toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(htsjdk.tribble.util.ParsingUtils.openInputStream((String)path)))) : ParsingUtils.openBufferedReader(path);
            int lineCount = 0;
            while ((formatLine = reader.readLine()) != null) {
                String[] tmp;
                if (lineCount >= 20) return new VCFCodec();
                if ((formatLine.toLowerCase().startsWith("##fileformat") || formatLine.toLowerCase().startsWith("##format")) && (tmp = formatLine.split("=")).length > 1) {
                    String version = tmp[1].toLowerCase();
                    if (version.startsWith("vcfv3")) {
                        VCF3Codec vCF3Codec = new VCF3Codec();
                        return vCF3Codec;
                    }
                    VCFCodec vCFCodec = new VCFCodec();
                    return vCFCodec;
                }
                ++lineCount;
            }
            return new VCFCodec();
        }
        catch (IOException e) {
            log.error("Error checking VCF Version");
            return new VCFCodec();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasCodec(ResourceLocator locator, Genome genome) {
        String format = locator.getFormat();
        return format.equals("vcf") || format.equals("bcf") || CodecFactory.getCodec(locator, genome) != null;
    }
}

