/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.prefs;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.AlignmentTrackEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.Constants;
import org.broad.igv.prefs.PreferencesChangeEvent;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.sam.mods.BaseModificationColors;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.RecentFileSet;
import org.broad.igv.ui.RecentUrlsSet;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class IGVPreferences {
    private static Logger log = LogManager.getLogger(IGVPreferences.class);
    IGVPreferences parent;
    Map<String, String> userPreferences;
    Map<String, String> defaults;
    Set<String> overrideKeys = new HashSet<String>();
    private Map<String, Boolean> booleanCache = new Hashtable<String, Boolean>();
    private Map<String, Object> objectCache = new Hashtable<String, Object>();
    private Map<TrackType, ContinuousColorScale> colorScaleCache = new Hashtable<TrackType, ContinuousColorScale>();
    private PaletteColorTable mutationColorScheme = null;
    static Set<String> scaledTypes = new HashSet<TrackType>(Arrays.asList(TrackType.LOH, TrackType.RNAI, TrackType.POOLED_RNAI, TrackType.DNA_METHYLATION, TrackType.GENE_EXPRESSION, TrackType.COPY_NUMBER, TrackType.ALLELE_SPECIFIC_COPY_NUMBER, TrackType.CNV));

    public IGVPreferences() {
        this.userPreferences = new HashMap<String, String>();
    }

    public IGVPreferences(Map<String, String> userPreferences, Map<String, String> defaults, IGVPreferences parent) {
        this.parent = parent;
        this.defaults = defaults;
        this.userPreferences = userPreferences == null ? new HashMap() : userPreferences;
    }

    public String get(String key) {
        if (this.userPreferences.containsKey(key = key.trim())) {
            return this.userPreferences.get(key);
        }
        if (this.parent != null && this.parent.userPreferences.containsKey(key)) {
            return this.parent.userPreferences.get(key);
        }
        if (this.defaults != null && this.defaults.containsKey(key)) {
            return this.defaults.get(key);
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        String val = this.userPreferences.get(key = key.trim());
        return val == null ? defaultValue : val;
    }

    public boolean getAsBoolean(String key) {
        Boolean boolValue = this.booleanCache.get(key = key.trim());
        if (boolValue == null) {
            String value = this.get(key);
            if (value == null) {
                log.warn("No default value for: " + key);
                return false;
            }
            boolValue = Boolean.valueOf(this.get(key, value));
            this.booleanCache.put(key, boolValue);
        }
        return boolValue;
    }

    public int getAsInt(String key) {
        Number value = (Number)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.warn("No default value for: " + key);
                return 0;
            }
            value = Integer.valueOf(this.get(key, defValue));
            this.objectCache.put(key, value);
        }
        return value.intValue();
    }

    public Color getAsColor(String key) {
        Color value = (Color)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.warn("No default value for: " + key);
                return Color.white;
            }
            value = ColorUtilities.stringToColor(defValue);
            this.objectCache.put(key, value);
        }
        return value;
    }

    public float getAsFloat(String key) {
        Number value = (Number)this.objectCache.get(key = key.trim());
        if (value == null) {
            String defValue = this.get(key);
            if (defValue == null) {
                log.warn("No default value for: " + key);
                return 0.0f;
            }
            value = Float.valueOf(this.get(key, defValue));
            this.objectCache.put(key, value);
        }
        return value.floatValue();
    }

    private String[] getAsArray(String key) {
        String stringProp = this.get(key);
        if (stringProp == null) {
            return new String[0];
        }
        return stringProp.split(";");
    }

    public boolean hasExplicitValue(String key) {
        key = key.trim();
        return this.userPreferences.containsKey(key);
    }

    public void addOverrides(Map<String, String> newPrefs) {
        this.overrideKeys.addAll(newPrefs.keySet());
        this.userPreferences.putAll(newPrefs);
    }

    public boolean getAntiAliasing() {
        if (this.userPreferences.containsKey("ENABLE_ANTIALIASING") || !Globals.IS_LINUX) {
            return this.getAsBoolean("ENABLE_ANTIALIASING");
        }
        return false;
    }

    private void updateCaches(String key, String value) {
        if (this.booleanCache.containsKey(key = key.trim())) {
            this.booleanCache.put(key, Boolean.valueOf(value));
        }
        this.objectCache.remove(key);
        this.mutationColorScheme = null;
    }

    private void clearCaches() {
        this.colorScaleCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
        this.mutationColorScheme = null;
    }

    public void put(String key, String value) {
        if (!Globals.isBatch()) {
            key = key.trim();
            this.overrideKeys.remove(key);
            if (value == null || value.isBlank()) {
                this.userPreferences.remove(key);
            } else {
                this.userPreferences.put(key, value);
            }
            this.updateCaches(key, value);
            IGVEventBus.getInstance().post(new PreferencesChangeEvent());
        }
    }

    public void put(String key, boolean b) {
        this.put(key, String.valueOf(b));
    }

    public void putAll(Map<String, String> updatedPrefs) {
        for (Map.Entry<String, String> entry : updatedPrefs.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isBlank()) {
                this.remove(entry.getKey());
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
        this.clearCaches();
        this.checkForProxyChanges(updatedPrefs);
        this.checkForAlignmentChanges(updatedPrefs);
        this.checkForCommandListenerChanges(updatedPrefs);
        this.checkForAttributePanelChanges(updatedPrefs);
        this.checkForCircViewChanges(updatedPrefs);
        this.checkForGoogleMenuChange(updatedPrefs);
        this.checkForRestartChanges(updatedPrefs);
        IGVEventBus.getInstance().post(new PreferencesChangeEvent());
    }

    private void checkForRestartChanges(Map<String, String> updatedPreferenceMap) {
        for (String key : Constants.RESTART_KEYS) {
            if (!updatedPreferenceMap.containsKey(key)) continue;
            MessageUtils.showMessage("Preference changes will take effect after restart.");
            return;
        }
    }

    private void checkForGoogleMenuChange(Map<String, String> updatedPreferenceMap) {
        if (updatedPreferenceMap.containsKey("ENABLE_GOOGLE_MENU") && IGV.hasInstance()) {
            try {
                IGVMenuBar.getInstance().enableGoogleMenu(this.getAsBoolean("ENABLE_GOOGLE_MENU"));
            }
            catch (IOException e) {
                log.error("Error enabling/disabling Google menu", e);
            }
        }
    }

    private void checkForAlignmentChanges(Map<String, String> updatedPreferenceMap) {
        if (IGV.hasInstance()) {
            boolean reloadSAM = false;
            for (String key : Constants.SAM_RELOAD_KEYS) {
                if (!updatedPreferenceMap.containsKey(key)) continue;
                reloadSAM = true;
                break;
            }
            boolean refreshSAM = false;
            for (String key : Constants.SAM_REFRESH_KEYS) {
                if (!updatedPreferenceMap.containsKey(key)) continue;
                refreshSAM = true;
                break;
            }
            for (String key : Constants.BASEMOD_COLOR_KEYS) {
                if (!updatedPreferenceMap.containsKey(key)) continue;
                refreshSAM = true;
                BaseModificationColors.updateColors();
                break;
            }
            for (String key : Constants.NUCLEOTIDE_COLOR_KEYS) {
                if (!updatedPreferenceMap.containsKey(key)) continue;
                SequenceRenderer.setNucleotideColors();
                break;
            }
            if (reloadSAM) {
                IGVEventBus.getInstance().post(new AlignmentTrackEvent(AlignmentTrackEvent.Type.RELOAD));
            }
            if (!reloadSAM && refreshSAM) {
                IGVEventBus.getInstance().post(new AlignmentTrackEvent(AlignmentTrackEvent.Type.REFRESH));
            }
            if (updatedPreferenceMap.containsKey("SAM.ALLELE_THRESHOLD")) {
                IGVEventBus.getInstance().post(new AlignmentTrackEvent(AlignmentTrackEvent.Type.ALLELE_THRESHOLD));
            }
        }
    }

    private void checkForProxyChanges(Map<String, String> updatedPreferenceMap) {
        if (HttpUtils.getInstance() != null) {
            for (String key : Constants.PROXY_KEYS) {
                if (!updatedPreferenceMap.containsKey(key)) continue;
                HttpUtils.getInstance().updateProxySettings();
                break;
            }
        }
    }

    private void checkForCommandListenerChanges(Map<String, String> updatedPreferenceMap) {
        if (updatedPreferenceMap.containsKey("PORT_ENABLED") || updatedPreferenceMap.containsKey("PORT_NUMBER")) {
            CommandListener.halt();
            if (this.getAsBoolean("PORT_ENABLED")) {
                CommandListener.start(this.getAsInt("PORT_NUMBER"));
            }
        }
    }

    private void checkForAttributePanelChanges(Map<String, String> updatedPreferenceMap) {
        if ((updatedPreferenceMap.containsKey("IGV.track.show.attribute.views") || updatedPreferenceMap.containsKey("SHOW_DEFAULT_TRACK_ATTRIBUTES")) && IGV.hasInstance()) {
            IGV.getInstance().revalidateTrackPanels();
        }
    }

    private void checkForCircViewChanges(Map<String, String> updatedPreferenceMap) {
        if (updatedPreferenceMap.containsKey("CIRC_VIEW_ENABLED") && this.getAsBoolean("CIRC_VIEW_ENABLED") && !this.getAsBoolean("PORT_ENABLED")) {
            this.put("PORT_ENABLED", true);
            CommandListener.start(this.getAsInt("PORT_NUMBER"));
        }
    }

    public void remove(String key) {
        this.overrideKeys.remove(key);
        this.userPreferences.remove(key);
        this.booleanCache.remove(key);
        this.objectCache.remove(key);
        this.colorScaleCache.remove(key);
        IGVEventBus.getInstance().post(new PreferencesChangeEvent());
    }

    public void clear() {
        this.userPreferences.clear();
        this.colorScaleCache.clear();
        this.booleanCache.clear();
        this.objectCache.clear();
        IGVEventBus.getInstance().post(new PreferencesChangeEvent());
    }

    public String getGenomeListURL() {
        return this.get("IGV.genome.sequence.dir");
    }

    public String getProvisioningURL() {
        return this.get("PROVISIONING.URL");
    }

    public String getPortNumber() {
        return this.get("PORT_NUMBER");
    }

    public void overrideGenomeServerURL(String url) {
        this.userPreferences.put("IGV.genome.sequence.dir", url);
        this.overrideKeys.add("IGV.genome.sequence.dir");
        this.clearCaches();
    }

    public void setLastExportedRegionDirectory(File directory) {
        this.put("LAST_EXPORTED_REGION_DIRECTORY", directory.getAbsolutePath());
    }

    public File getLastExportedRegionDirectory() {
        File exportedRegionDirectory = null;
        String lastFilePath = this.get("LAST_EXPORTED_REGION_DIRECTORY", null);
        if (lastFilePath != null) {
            exportedRegionDirectory = new File(lastFilePath);
        }
        return exportedRegionDirectory;
    }

    public void setLastSnapshotDirectory(String directory) {
        this.put("LAST_SNAPSHOT_DIRECTORY", directory);
    }

    public File getLastSnapshotDirectory() {
        File snapshotDirectory = null;
        String lastFilePath = this.get("LAST_SNAPSHOT_DIRECTORY", null);
        if (lastFilePath != null) {
            snapshotDirectory = new File(lastFilePath);
        }
        return snapshotDirectory;
    }

    public void setDefineGenomeInputDirectory(File directory) {
        this.put("DEFINE_GENOME_INPUT_DIRECTORY_KEY", directory.getAbsolutePath());
    }

    public File getDefineGenomeInputDirectory() {
        File directory = null;
        String lastFilePath = this.get("DEFINE_GENOME_INPUT_DIRECTORY_KEY", DirectoryManager.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            directory = new File(lastFilePath);
        }
        return directory;
    }

    public void setLastGenomeImportDirectory(File directory) {
        this.put("LAST_GENOME_IMPORT_DIRECTORY", directory.getAbsolutePath());
    }

    public File getLastGenomeImportDirectory() {
        File genomeImportDirectory = null;
        String lastFilePath = this.get("LAST_GENOME_IMPORT_DIRECTORY", DirectoryManager.getUserDirectory().getAbsolutePath());
        if (lastFilePath != null) {
            genomeImportDirectory = new File(lastFilePath);
        }
        return genomeImportDirectory;
    }

    public void setApplicationFrameBounds(Rectangle bounds) {
        if (bounds.width > 0 && bounds.height > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(bounds.x);
            buffer.append(",");
            buffer.append(bounds.y);
            buffer.append(",");
            buffer.append(bounds.width);
            buffer.append(",");
            buffer.append(bounds.height);
            this.put("IGV.Bounds", buffer.toString());
        }
    }

    public Rectangle getApplicationFrameBounds() {
        Rectangle bounds = null;
        String applicationBounds = this.get("IGV.Bounds", null);
        if (applicationBounds != null) {
            String[] values = applicationBounds.split(",");
            int x = Integer.parseInt(values[0]);
            int y = Integer.parseInt(values[1]);
            int width = Integer.parseInt(values[2]);
            int height = Integer.parseInt(values[3]);
            if (width == 0 || height == 0) {
                return null;
            }
            bounds = new Rectangle(x, y, width, height);
        }
        return bounds;
    }

    public void setRecentSessions(String recentSessions) {
        this.remove("IGV.Session.recent.sessions");
        this.put("IGV.Session.recent.sessions", recentSessions);
    }

    public RecentFileSet getRecentSessions() {
        String sessionsString = this.get("IGV.Session.recent.sessions", null);
        return RecentFileSet.fromString(sessionsString, 10);
    }

    public void setRecentUrls(String recentUrls) {
        this.remove("IGV.Session.recent.urls");
        this.put("IGV.Session.recent.urls", recentUrls);
    }

    public RecentUrlsSet getRecentUrls() {
        String sessionsString = this.get("IGV.Session.recent.urls", null);
        return RecentUrlsSet.fromString(sessionsString, 10);
    }

    public String getDataServerURL() {
        String masterResourceFile = this.get("MASTER_RESOURCE_FILE_KEY");
        return masterResourceFile;
    }

    public void overrideDataServerURL(String url) {
        this.userPreferences.put("MASTER_RESOURCE_FILE_KEY", url);
        this.overrideKeys.add("MASTER_RESOURCE_FILE_KEY");
        this.clearCaches();
    }

    public void override(String key, String value) {
        this.userPreferences.put(key, value);
        this.overrideKeys.add(key);
        HashMap<String, String> updatedPrefs = new HashMap<String, String>();
        updatedPrefs.put(key, value);
        this.checkForAlignmentChanges(updatedPrefs);
        this.clearCaches();
    }

    public void setShowAttributeView(boolean isShowable) {
        this.put("IGV.track.show.attribute.views", Boolean.toString(isShowable));
    }

    public void setLastGenome(String genomeId) {
        if (!genomeId.equals(this.get("DEFAULT_GENOME_KEY"))) {
            this.put("DEFAULT_GENOME_KEY", genomeId);
        }
    }

    public String getDefaultGenome() {
        String genome = this.get("DEFAULT_GENOME_KEY", "hg38");
        return genome;
    }

    public void setLastTrackDirectory(File directory) {
        String lastDirectory = directory.isDirectory() ? directory.getAbsolutePath() : directory.getParent();
        this.put("LAST_TRACK_DIRECTORY", lastDirectory);
    }

    public File getLastTrackDirectory() {
        String lastDirectoryPath = this.get("LAST_TRACK_DIRECTORY", null);
        File lastDirectoryFile = null;
        if (lastDirectoryPath != null) {
            lastDirectoryFile = new File(lastDirectoryPath);
        }
        return lastDirectoryFile;
    }

    public void setColorScale(TrackType type, ContinuousColorScale colorScale) {
        String colorScaleString = colorScale.asString();
        this.put("COLOR_SCALE_" + type.toString(), colorScaleString);
        this.colorScaleCache.put(type, colorScale);
    }

    public ContinuousColorScale getColorScale(TrackType type) {
        String colorScaleString;
        if (type == null) {
            return null;
        }
        ContinuousColorScale scale = this.colorScaleCache.get((Object)type);
        if (scale == null && scaledTypes.contains((Object)type) && (scale = (colorScaleString = this.get("COLOR_SCALE_" + type.toString(), null)) != null ? (ContinuousColorScale)ColorScaleFactory.getScaleFromString(colorScaleString) : IGVPreferences.getDefaultColorScale(type)) != null) {
            scale.setDefault(true);
            this.colorScaleCache.put(type, scale);
        }
        return scale;
    }

    public static ContinuousColorScale getDefaultColorScale(TrackType type) {
        switch (type) {
            case LOH: {
                return new ContinuousColorScale(0.0, -1.0, 0.0, 1.0, Color.red, UIConstants.LIGHT_YELLOW, Color.blue);
            }
            case RNAI: 
            case POOLED_RNAI: {
                ContinuousColorScale cs = new ContinuousColorScale(0.0, -3.0, 0.0, 3.0, Color.red, Color.white, Color.blue);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case DNA_METHYLATION: {
                ContinuousColorScale cs = new ContinuousColorScale(0.0, 1.0, Color.BLUE, Color.RED);
                cs.setNoDataColor(Color.WHITE);
                return cs;
            }
            case GENE_EXPRESSION: {
                ContinuousColorScale cs = IGVPreferences.getDefaultColorScale(Color.BLUE, Color.WHITE, Color.RED);
                cs.setNoDataColor(new Color(225, 225, 225));
                return cs;
            }
            case COPY_NUMBER: 
            case ALLELE_SPECIFIC_COPY_NUMBER: 
            case CNV: {
                return IGVPreferences.getDefaultColorScale(Color.BLUE, Color.WHITE, Color.RED);
            }
        }
        return null;
    }

    public static ContinuousColorScale getDefaultColorScale(Color negColor, Color neutralColor, Color posColor) {
        return new ContinuousColorScale(-0.1, -1.5, 0.1, 1.5, negColor, neutralColor, posColor);
    }

    public void resetMutationColorScheme() {
        this.remove("MUTATION_INDEL_COLOR_KEY");
        this.remove("MUTATION_MISSENSE_COLOR_KEY");
        this.remove("MUTATION_NONSENSE_COLOR_KEY");
        this.remove("MUTATION_SPLICE_SITE_COLOR_KEY");
        this.remove("MUTATION_SYNONYMOUS_COLOR_KEY");
        this.remove("MUTATION_TARGETED_REGION_COLOR_KEY");
        this.remove("MUTATION_UNKNOWN_COLOR_KEY");
        this.remove("MUTATION_Truncating_COLOR");
        this.remove("MUTATION_Non-coding_Transcript_COLOR");
        this.remove("MUTATION_Other_AA_changing_COLOR");
        this.remove("MUTATION_Other_likely_neutral_COLOR");
        this.remove("MUTATION_COLOR_TABLE");
    }

    public synchronized PaletteColorTable getMutationColorScheme() {
        if (this.mutationColorScheme == null) {
            String colorTableString = this.get("MUTATION_COLOR_TABLE");
            if (colorTableString != null) {
                PaletteColorTable pallete = new PaletteColorTable();
                pallete.restoreMapFromString(colorTableString);
                this.mutationColorScheme = pallete;
            } else {
                this.mutationColorScheme = this.getLegacyMutationColorScheme();
            }
        }
        return this.mutationColorScheme;
    }

    private PaletteColorTable getLegacyMutationColorScheme() {
        String indelColor = this.get("MUTATION_INDEL_COLOR_KEY");
        String missenseColor = this.get("MUTATION_MISSENSE_COLOR_KEY");
        String nonsenseColor = this.get("MUTATION_NONSENSE_COLOR_KEY");
        String spliceSiteColor = this.get("MUTATION_SPLICE_SITE_COLOR_KEY");
        String synonymousColor = this.get("MUTATION_SYNONYMOUS_COLOR_KEY");
        String targetedRegionColor = this.get("MUTATION_TARGETED_REGION_COLOR_KEY");
        String unknownColor = this.get("MUTATION_UNKNOWN_COLOR_KEY");
        PaletteColorTable colorTable = new PaletteColorTable();
        if (indelColor != null && missenseColor != null && nonsenseColor != null && spliceSiteColor != null && synonymousColor != null && targetedRegionColor != null && unknownColor != null) {
            String[] nicosCats;
            Color color1 = ColorUtilities.stringToColor(indelColor);
            colorTable.put("Indel", color1);
            Color color2 = ColorUtilities.stringToColor(missenseColor);
            colorTable.put("Missense", color2);
            Color color3 = ColorUtilities.stringToColor(nonsenseColor);
            colorTable.put("Nonsense", color3);
            Color color4 = ColorUtilities.stringToColor(spliceSiteColor);
            colorTable.put("Splice_site", color4);
            Color color5 = ColorUtilities.stringToColor(synonymousColor);
            colorTable.put("Synonymous", color5);
            Color color6 = ColorUtilities.stringToColor(targetedRegionColor);
            colorTable.put("Targeted_Region", color6);
            Color color7 = ColorUtilities.stringToColor(unknownColor);
            colorTable.put("Unknown", color7);
            for (String cat : nicosCats = new String[]{"Truncating", "Non-coding_Transcript", "Other_AA_changing", "Other_likely_neutral"}) {
                String key = "MUTATION_" + cat + "_COLOR";
                colorTable.put(cat, ColorUtilities.stringToColor(this.get(key)));
            }
        }
        return colorTable;
    }

    static String getMutationColorKey(String type) {
        switch (type) {
            case "Indel": {
                return "MUTATION_INDEL_COLOR_KEY";
            }
            case "Missense": {
                return "MUTATION_MISSENSE_COLOR_KEY";
            }
            case "Nonsense": {
                return "MUTATION_NONSENSE_COLOR_KEY";
            }
            case "Splice_site": {
                return "MUTATION_SPLICE_SITE_COLOR_KEY";
            }
            case "Synonymous": {
                return "MUTATION_SYNONYMOUS_COLOR_KEY";
            }
            case "Targeted_region": {
                return "MUTATION_TARGETED_REGION_COLOR_KEY";
            }
            case "Unknown": {
                return "MUTATION_UNKNOWN_COLOR_KEY";
            }
        }
        return "MUTATION_" + type + "_COLOR";
    }

    public void clearProxySettings() {
        this.remove("PROXY.USE");
        this.remove("PROXY.HOST");
        this.remove("PROXY.PORT");
        this.remove("PROXY.AUTHENTICATE");
        this.remove("PROXY.USERNAME");
        this.remove("PROXY.PW");
        this.remove("PROXY.TYPE");
        this.remove("PROXY.WHITELIST");
        HttpUtils.getInstance().updateProxySettings();
    }

    public static String generateGenomeIdString(Collection<GenomeListItem> genomeListItems) {
        Object genomeString = "";
        for (GenomeListItem serverItem : genomeListItems) {
            genomeString = (String)genomeString + serverItem.getId() + ";";
        }
        genomeString = ((String)genomeString).substring(0, ((String)genomeString).length() - 1);
        return genomeString;
    }

    public String getToolPath(String pluginId, String toolName) {
        return this.get(this.genToolKey(pluginId, toolName, "path"));
    }

    public void putToolPath(String pluginId, String toolName, String path) {
        this.put(this.genToolKey(pluginId, toolName, "path"), path);
    }

    private String genToolKey(String pluginId, String toolName, String key) {
        return String.format("%s:%s:%s", pluginId, toolName.replace(' ', '_'), key.replace(' ', '_'));
    }

    public void putArgumentValue(String pluginId, String toolName, String command, String argName, String argValue) {
        String key = this.genArgKey(pluginId, toolName, command, argName);
        this.put(key, argValue);
    }

    public String getArgumentValue(String pluginId, String toolName, String commandName, String argId) {
        return this.get(this.genArgKey(pluginId, toolName, commandName, argId));
    }

    private String genArgKey(String pluginId, String toolName, String command, String argId) {
        return this.genToolKey(pluginId, toolName, String.format("%s:%s", command, argId));
    }

    public String[] getIGVPluginList() {
        return this.getAsArray("IGV_PLUGIN_LIST");
    }

    public String getPersistent(String key, String def) {
        String value = System.getProperty(key);
        if (value != null) {
            this.put(key, value);
            return value;
        }
        return this.get(key, def);
    }

    public void print(PrintWriter pw) {
        for (Map.Entry<String, String> entry : this.userPreferences.entrySet()) {
            if (this.overrideKeys.contains(entry.getKey())) continue;
            pw.print(entry.getKey());
            pw.print("=");
            pw.println(entry.getValue());
        }
    }
}

