/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;

public class GenomeListManager {
    private static Logger log = LogManager.getLogger(GenomeListManager.class);
    private static GenomeListManager theInstance;
    private static final String REMOTE_GENOMES_FILE = "remote-genomes.txt";
    private static final GenomeListItem DEFAULT_GENOME;
    private Map<String, GenomeListItem> genomeItemMap = new HashMap<String, GenomeListItem>();
    private Map<String, GenomeListItem> remoteGenomesMap;
    private Map<String, GenomeListItem> hostedGenomesMap;
    private Map<String, GenomeListItem> downloadedGenomesMap;
    private boolean hostedGenomeListUnreachable = false;
    private static GenomeListSorter sorter;
    public static final String TEST_REMOTE_GENOMES_FILE;

    public static synchronized GenomeListManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeListManager();
        }
        return theInstance;
    }

    private GenomeListManager() {
    }

    public Map<String, GenomeListItem> getGenomeItemMap() throws IOException {
        if (this.genomeItemMap.isEmpty()) {
            this.rebuildGenomeItemMaps();
        }
        return this.genomeItemMap;
    }

    public void resetForTests() throws IOException {
        this.remoteGenomesMap = null;
        new File(TEST_REMOTE_GENOMES_FILE).delete();
        this.rebuildGenomeItemMaps();
    }

    public List<GenomeListItem> getGenomeListItems() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.genomeItemMap.values());
        items.sort(sorter);
        return items;
    }

    public void addGenomeItem(GenomeListItem genomeListItem) {
        if (this.genomeItemMap.values().stream().anyMatch(item -> genomeListItem.equals(item))) {
            return;
        }
        this.genomeItemMap.put(genomeListItem.getId(), genomeListItem);
        if (FileUtils.isRemote(genomeListItem.getPath()) || !DirectoryManager.getGenomeCacheDirectory().getAbsoluteFile().equals(new File(genomeListItem.getPath()).getParentFile().getAbsolutePath())) {
            if (this.remoteGenomesMap == null) {
                this.remoteGenomesMap = new HashMap<String, GenomeListItem>();
            }
            this.remoteGenomesMap.put(genomeListItem.getId(), genomeListItem);
            this.exportRemoteGenomesList();
        }
        IGVEventBus.getInstance().post(new GenomeResetEvent());
    }

    public GenomeListItem getGenomeListItem(String genomeId) {
        GenomeListItem matchingItem = this.genomeItemMap.get(genomeId);
        if (matchingItem == null) {
            matchingItem = this.getHostedGenomesMap().get(genomeId);
            if (matchingItem != null) {
                return matchingItem;
            }
            try {
                this.rebuildGenomeItemMaps();
            }
            catch (IOException e) {
                log.error("Error rebuilding genome item map", e);
            }
            matchingItem = this.genomeItemMap.get(genomeId);
        }
        return matchingItem;
    }

    private void rebuildGenomeItemMaps() throws IOException {
        this.hostedGenomesMap = null;
        this.remoteGenomesMap = null;
        this.downloadedGenomesMap = null;
        this.genomeItemMap.clear();
        this.genomeItemMap.putAll(this.getRemoteGenomesMap());
        this.genomeItemMap.putAll(this.getDownloadedGenomeMap());
        if (this.genomeItemMap.isEmpty()) {
            this.genomeItemMap.put(DEFAULT_GENOME.getId(), DEFAULT_GENOME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GenomeListItem> getDownloadedGenomeMap() {
        if (this.downloadedGenomesMap == null) {
            File[] files;
            this.downloadedGenomesMap = new HashMap<String, GenomeListItem>();
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                return this.downloadedGenomesMap;
            }
            for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                ZipFile zipFile = null;
                FileInputStream fis = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipFile = new ZipFile(file);
                    fis = new FileInputStream(file);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"));
                    this.downloadedGenomesMap.put(item.getId(), item);
                }
                catch (ZipException ex) {
                    log.error("\nZip error unzipping cached genome.", ex);
                    try {
                        file.delete();
                        zipInputStream.close();
                    }
                    catch (Exception inputStream) {
                        // empty catch block
                    }
                }
                catch (IOException ex) {
                    log.warn("\nIO error unzipping cached genome.", ex);
                    try {
                        file.delete();
                    }
                    catch (Exception inputStream) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error closing genome zip stream", ex);
                    }
                }
            }
            for (File file : files) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".json")) continue;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    JsonParser parser = new JsonParser();
                    JsonElement rootElement = parser.parse((Reader)reader);
                    if (!rootElement.isJsonObject()) continue;
                    JsonObject json = rootElement.getAsJsonObject();
                    JsonElement id = json.get("id");
                    JsonElement name = json.get("name");
                    JsonElement fasta = json.get("fastaURL");
                    JsonElement twobit = json.get("twoBitURL");
                    if (id == null) {
                        log.error("Error parsing " + file.getName() + ". \"id\" is required");
                        continue;
                    }
                    if (name == null) {
                        log.error("Error parsing " + file.getName() + ". \"name\" is required");
                        continue;
                    }
                    if (fasta == null && twobit == null) {
                        log.error("Error parsing " + file.getName() + ". One of either \"fastaURL\" or \"twoBitURL\" is required");
                        continue;
                    }
                    GenomeListItem item = new GenomeListItem(name.getAsString(), file.getAbsolutePath(), id.getAsString());
                    this.downloadedGenomesMap.put(item.getId(), item);
                }
                catch (Exception e) {
                    log.error("Error parsing genome json: " + file.getAbsolutePath(), e);
                }
            }
        }
        return this.downloadedGenomesMap;
    }

    public void removeItems(List<GenomeListItem> removedValuesList) {
        boolean updateImportFile = false;
        for (GenomeListItem genomeListItem : removedValuesList) {
            String id = genomeListItem.getId();
            this.genomeItemMap.remove(id);
            if (this.remoteGenomesMap == null || !this.remoteGenomesMap.containsKey(id)) continue;
            this.remoteGenomesMap.remove(id);
            updateImportFile = true;
        }
        if (updateImportFile) {
            this.exportRemoteGenomesList();
        }
    }

    List<GenomeListItem> getHostedGenomeList() {
        ArrayList<GenomeListItem> items = new ArrayList<GenomeListItem>(this.getHostedGenomesMap().values());
        items.sort(sorter);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, GenomeListItem> getHostedGenomesMap() {
        if (this.hostedGenomeListUnreachable) {
            return Collections.emptyMap();
        }
        if (this.hostedGenomesMap == null) {
            this.hostedGenomesMap = new HashMap<String, GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferencesManager.getPreferences().getGenomeListURL();
                if (HttpUtils.isRemoteURL(genomeListURLString)) {
                    URL serverGenomeURL = HttpUtils.createURL(genomeListURLString);
                    inputStream = HttpUtils.getInstance().openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? new URL(genomeListURLString).getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        GenomeListItem item = new GenomeListItem(name, url, id);
                        this.hostedGenomesMap.put(item.getId(), item);
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e) {
                this.hostedGenomeListUnreachable = true;
                this.hostedGenomesMap = Collections.emptyMap();
                log.error("Error fetching genome list: ", e);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    try {
                        dataReader.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
            }
        }
        if (IGVMenuBar.getInstance() != null) {
            IGVMenuBar.getInstance().notifyGenomeServerReachable(!this.hostedGenomeListUnreachable);
        }
        return this.hostedGenomesMap;
    }

    public Map<String, GenomeListItem> getRemoteGenomesMap() {
        if (this.remoteGenomesMap == null) {
            boolean updateClientGenomeListFile = false;
            this.remoteGenomesMap = new HashMap<String, GenomeListItem>();
            File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getRemoteGenomesFilename());
            if (!listFile.exists()) {
                listFile = new File(DirectoryManager.getGenomeCacheDirectory(), "user-defined-genomes.txt");
            }
            if (listFile.exists()) {
                BufferedReader reader = null;
                boolean mightBeProperties = false;
                try {
                    String nextLine;
                    reader = new BufferedReader(new FileReader(listFile));
                    while ((nextLine = reader.readLine()) != null) {
                        String file;
                        if (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                            mightBeProperties = true;
                            continue;
                        }
                        String[] fields = nextLine.split("\t");
                        if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                            fields = nextLine.split("\\\\t");
                            if (fields.length < 3) continue;
                            int idx = fields[0].indexOf("=");
                            fields[0] = fields[0].substring(idx + 1);
                        }
                        if (!FileUtils.isRemote(file = fields[1]) && !FileUtils.resourceExists(file)) {
                            updateClientGenomeListFile = true;
                            continue;
                        }
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], file, fields[2]);
                            this.remoteGenomesMap.put(item.getId(), item);
                        }
                        catch (Exception e) {
                            log.error("Error updating user genome list line '" + nextLine + "'", e);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    log.error(e);
                }
                catch (IOException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (updateClientGenomeListFile) {
                    this.exportRemoteGenomesList();
                }
            }
        }
        return this.remoteGenomesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRemoteGenomesList() {
        if (this.remoteGenomesMap == null) {
            return;
        }
        File listFile = new File(DirectoryManager.getGenomeCacheDirectory(), this.getRemoteGenomesFilename());
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e) {
                log.error("Error backing up user-defined genome list file", e);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.remoteGenomesMap.values()) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getPath());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error("Error restoring genome-list file from backup");
                }
            }
            MessageUtils.showErrorMessage("Error updating user-defined genome list " + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    private String getRemoteGenomesFilename() {
        if (Globals.isTesting()) {
            return TEST_REMOTE_GENOMES_FILE;
        }
        return REMOTE_GENOMES_FILE;
    }

    static {
        DEFAULT_GENOME = new GenomeListItem("Human (hg38)", "https://igv.org/genomes/json/hg38.json", "hg38");
        sorter = new GenomeListSorter();
        TEST_REMOTE_GENOMES_FILE = "test-remote-genomes_" + System.currentTimeMillis() + "_" + Math.random() + ".txt";
    }

    private static class GenomeListSorter
    implements Comparator<GenomeListItem> {
        private GenomeListSorter() {
        }

        @Override
        public int compare(GenomeListItem o1, GenomeListItem o2) {
            return o1.getDisplayableName().toLowerCase().compareTo(o2.getDisplayableName().toLowerCase());
        }
    }
}

