/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.commandbar.HostedGenomeSelectionDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;

public class GenomeComboBox
extends JComboBox<GenomeListItem> {
    private static Logger log = LogManager.getLogger(GenomeComboBox.class);

    public GenomeComboBox() {
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new GenomeBoxActionListener());
    }

    public void refreshGenomeListComboBox() {
        this.setModel(this.buildModel());
        String curId = GenomeManager.getInstance().getGenomeId();
        if (curId == null) {
            return;
        }
        int c = this.getItemCount();
        for (int i = 0; i < c; ++i) {
            GenomeListItem item = (GenomeListItem)this.getItemAt(i);
            if (!curId.equals(item.getId())) continue;
            this.setSelectedItem(item);
            break;
        }
    }

    private DefaultComboBoxModel buildModel() {
        Collection<GenomeListItem> genomes;
        try {
            genomes = GenomeListManager.getInstance().getGenomeItemMap().values();
        }
        catch (IOException e) {
            log.error("Error reading genome list ", e);
            genomes = new ArrayList<GenomeListItem>();
            MessageUtils.showErrorMessage("Error reading genome list ", e);
        }
        Vector<GenomeListItem> vector = new Vector<GenomeListItem>(genomes);
        vector.sort(Comparator.comparing(GenomeListItem::getDisplayableName));
        vector.add(GenomeListItem.DOWNLOAD_ITEM);
        return new DefaultComboBoxModel<GenomeListItem>(vector);
    }

    public boolean hasItem(Object item) {
        int c = this.getItemCount();
        for (int i = 0; i < c; ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                label.setSize(label.getWidth() + 10, label.getHeight());
                renderer = label;
            }
            if (list != null) {
                if (isSelected) {
                    ((Component)renderer).setBackground(list.getSelectionBackground());
                    ((Component)renderer).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)renderer).setBackground(list.getBackground());
                    ((Component)renderer).setForeground(list.getForeground());
                }
                ((Component)renderer).setFont(list.getFont());
            }
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object selItem = GenomeComboBox.this.getSelectedItem();
            if (!(selItem instanceof GenomeListItem)) {
                return;
            }
            GenomeListItem genomeListItem = (GenomeListItem)selItem;
            if (genomeListItem.getId().equalsIgnoreCase(GenomeManager.getInstance().getGenomeId())) {
                return;
            }
            Runnable runnable = () -> {
                if (genomeListItem != null && genomeListItem.getPath() != null) {
                    if (genomeListItem == GenomeListItem.DOWNLOAD_ITEM) {
                        HostedGenomeSelectionDialog.selectHostedGenome();
                    } else {
                        try {
                            GenomeManager.getInstance().loadGenomeById(genomeListItem.getId());
                        }
                        catch (Exception e) {
                            log.error(e);
                            MessageUtils.showErrorMessage("The genome '" + genomeListItem.getDisplayableName() + "' could not be read.", e);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                LongRunningTask.submit(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

