/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.UIUtilities;

public class ChromosomeComboBox
extends JComboBox {
    private static int MAX_CHROMOSOME_COUNT = 10000;
    private static String MAX_EXCEEDED = "Max exceeded";

    public ChromosomeComboBox() {
        this.addActionListener(evt -> this.chromosomeComboBoxActionPerformed(evt));
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        String chrName = (String)combobox.getSelectedItem();
        if (chrName != null & !chrName.equals(FrameManager.getDefaultFrame().getChrName()) && !chrName.equals(MAX_EXCEEDED)) {
            FrameManager.getDefaultFrame().changeChromosome(chrName, true);
        }
    }

    public void updateChromosFromGenome(Genome genome) {
        if (genome == null) {
            return;
        }
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            List allChromosomeNames = genome.getChromosomeNames().stream().map(chr -> genome.getChromosomeDisplayName((String)chr)).collect(Collectors.toList());
            if (allChromosomeNames.size() > 1) {
                this.setVisible(true);
                ArrayList<Object> tmp = new ArrayList<Object>();
                tmp.addAll(allChromosomeNames.size() > MAX_CHROMOSOME_COUNT ? allChromosomeNames.subList(0, MAX_CHROMOSOME_COUNT) : allChromosomeNames);
                String homeChr = genome.getHomeChromosome();
                if (homeChr.equals("All")) {
                    tmp.add(0, "All");
                }
                if (allChromosomeNames.size() > MAX_CHROMOSOME_COUNT) {
                    tmp.add(MAX_EXCEEDED);
                }
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                Font font = this.getFont();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int w = 120;
                for (String string : tmp) {
                    int width;
                    Rectangle2D textBounds = fontMetrics.getStringBounds(string, graphics2D);
                    if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w) continue;
                    w = width;
                }
                DefaultComboBoxModel<Object> defaultModel = new DefaultComboBoxModel<Object>(tmp.toArray());
                int n = w;
                this.setModel(defaultModel);
                this.setSelectedItem(genome.getHomeChromosome());
                this.adjustChromosomeDropdownWidth(n);
            } else {
                this.setVisible(false);
            }
        });
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = width > 120 ? width : 120;
        this.setMaximumSize(new Dimension(newWidth, 35));
        this.setMinimumSize(new Dimension(newWidth, 27));
        this.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }
}

