/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.HubGenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.session.SessionReader;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.LoadFromURLDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    public static final String LOAD_FROM_URL = "Load from URL...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    public static final String LOAD_FROM_HTSGET = "Load from htsget Server...";
    public static final String LOAD_TRACKHUB = "Load Track Hub...";
    private static final Logger log = LogManager.getLogger(LoadFromURLMenuAction.class);
    private final IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        String command = e.getActionCommand();
        boolean isHtsGet = command.equalsIgnoreCase(LOAD_FROM_HTSGET);
        if (command.equalsIgnoreCase(LOAD_FROM_URL) || isHtsGet) {
            LoadFromURLDialog dlg = new LoadFromURLDialog(IGV.getInstance().getMainFrame(), isHtsGet);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                this.loadUrls(dlg.getFileURLs(), dlg.getIndexURLs(), isHtsGet);
            }
        } else if (command.equalsIgnoreCase(LOAD_GENOME_FROM_URL)) {
            String url = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to .genome or FASTA file", 3);
            LoadFromURLMenuAction.loadGenomeFromUrl(url);
        } else if (command.equalsIgnoreCase(LOAD_TRACKHUB)) {
            LoadFromURLMenuAction.loadTrackHub(ta);
        }
    }

    private void loadUrls(List<String> inputs, List<String> indexes, boolean isHtsGet) {
        LoadFromURLMenuAction.checkURLs(inputs);
        if (inputs.size() == 1 && HubGenomeLoader.isHubURL(inputs.getFirst())) {
            LongRunningTask.submit(() -> {
                try {
                    GenomeManager.getInstance().loadGenome((String)inputs.getFirst());
                }
                catch (IOException ex) {
                    log.error("Error loading tack hub", ex);
                    MessageUtils.showMessage("Error loading track hub: " + ex.getMessage());
                }
            });
        } else if (inputs.size() == 1 && SessionReader.isSessionFile(inputs.getFirst())) {
            String url = inputs.getFirst();
            if (url.startsWith("s3://")) {
                LoadFromURLMenuAction.checkAWSAccessbility(url);
            }
            try {
                LongRunningTask.submit(() -> this.igv.loadSession(url, null));
            }
            catch (Exception ex) {
                MessageUtils.showMessage("Error loading url: " + url + " (" + String.valueOf(ex) + ")");
            }
        } else {
            if (!indexes.isEmpty() && indexes.size() != inputs.size()) {
                throw new RuntimeException("The number of Index URLs must equal the number of File URLs");
            }
            LoadFromURLMenuAction.checkURLs(indexes);
            List<ResourceLocator> locators = LoadFromURLMenuAction.getResourceLocators(inputs, indexes, isHtsGet);
            this.igv.addToRecentUrls(locators);
            this.igv.loadTracks(locators);
        }
    }

    private static void loadTrackHub(JPanel ta) {
        String url;
        String urlOrAccension = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter GCA or GCF accession, or URL to hub.txt file", 3);
        if (urlOrAccension == null) {
            return;
        }
        if ((urlOrAccension = urlOrAccension.trim()).startsWith("GC")) {
            url = HubGenomeLoader.convertToHubURL(urlOrAccension);
            if (!FileUtils.resourceExists(url)) {
                MessageUtils.showMessage("Unrecognized hub identifier: " + urlOrAccension);
            }
        } else {
            url = urlOrAccension;
        }
        LoadFromURLMenuAction.loadGenomeFromUrl(url);
    }

    private static void loadGenomeFromUrl(String url) {
        if (url != null && !url.isBlank()) {
            url = url.trim();
            try {
                LoadFromURLMenuAction.checkURLs(List.of(url));
                GenomeManager.getInstance().loadGenome(url);
            }
            catch (Exception e) {
                MessageUtils.showMessage("Error loading genome: " + e.getMessage());
            }
        }
    }

    private static List<ResourceLocator> getResourceLocators(List<String> inputs, List<String> indexes, boolean isHtsGet) {
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        for (int i = 0; i < inputs.size(); ++i) {
            String url = inputs.get(i);
            ResourceLocator rl = new ResourceLocator(url.trim());
            if (!indexes.isEmpty()) {
                String indexUrl = indexes.get(i);
                rl.setIndexPath(indexUrl);
            }
            rl.setHtsget(isHtsGet);
            locators.add(rl);
        }
        return locators;
    }

    private static boolean isHubURL(String input) {
        return input.endsWith("/hub.txt");
    }

    private static void checkURLs(List<String> urls) {
        for (String url : urls) {
            if (url.startsWith("s3://")) {
                LoadFromURLMenuAction.checkAWSAccessbility(url);
                continue;
            }
            if (!url.startsWith("ftp://")) continue;
            MessageUtils.showMessage("FTP protocol is not supported");
        }
    }

    private static void checkAWSAccessbility(String url) {
        try {
            String key;
            String bucket;
            AmazonUtils.s3ObjectAccessResult res;
            if (AmazonUtils.isAwsS3Path(url).booleanValue() && !(res = AmazonUtils.isObjectAccessible(bucket = AmazonUtils.getBucketFromS3URL(url), key = AmazonUtils.getKeyFromS3URL(url))).isObjectAvailable()) {
                MessageUtils.showErrorMessage(res.getErrorReason(), null);
            }
        }
        catch (NullPointerException npe) {
            AmazonUtils.checkLogin();
        }
    }
}

