/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.ucsc.twobit.UnsignedByteBufferImpl;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class FileFormatUtils {
    static final byte[] BAM_MAGIC = "BAM\u0001".getBytes();
    static final byte[] CRAM_MAGIC = "CRAM".getBytes();
    static final long BIGWIG_MAGIC = 2291137574L;
    static final long BIGBED_MAGIC = 2273964779L;

    public static boolean isBAM(String path) throws IOException {
        SeekableStream seekableStream = IGVSeekableStreamFactory.getInstance().getStreamFor(path);
        if (FileFormatUtils.isGzip(seekableStream)) {
            seekableStream.seek(0L);
            BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream((InputStream)new BufferedInputStream((InputStream)seekableStream));
            byte[] bytes = new byte[4];
            blockCompressedInputStream.read(bytes);
            return Arrays.equals(bytes, BAM_MAGIC);
        }
        return false;
    }

    public static String determineFormat(String path) throws IOException {
        byte[] bytes = new byte[1000];
        SeekableStream seekableStream = IGVSeekableStreamFactory.getInstance().getStreamFor(path);
        if (FileFormatUtils.isGzip(seekableStream)) {
            seekableStream.seek(0L);
            GZIPInputStream inputStream = new GZIPInputStream((InputStream)seekableStream);
            inputStream.read(bytes);
        } else {
            seekableStream.seek(0L);
            try {
                seekableStream.readFully(bytes);
            }
            catch (EOFException e) {
                int idx;
                for (idx = 0; idx < bytes.length && bytes[idx] != 0; ++idx) {
                }
                bytes = Arrays.copyOf(bytes, idx);
            }
        }
        if (Arrays.equals(bytes, 0, 4, BAM_MAGIC, 0, 4)) {
            return "bam";
        }
        if (Arrays.equals(bytes, 0, 4, CRAM_MAGIC, 0, 4)) {
            return "cram";
        }
        UnsignedByteBuffer byteBuffer = UnsignedByteBufferImpl.wrap(bytes);
        long m = byteBuffer.getUInt();
        if (m == 2291137574L) {
            return "bigwig";
        }
        if (m == 2273964779L) {
            return "bigbed";
        }
        String magicString = new String(Arrays.copyOfRange(bytes, 0, 4));
        if (magicString.startsWith("TDF") || magicString.startsWith("IBF")) {
            return "tdf";
        }
        try {
            String nextLine;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
            String firstLine = reader.readLine();
            if (firstLine.startsWith("##fileformat=VCF")) {
                return "vcf";
            }
            if (firstLine.startsWith("##gff-version 3")) {
                return "gff3";
            }
            if (firstLine.startsWith("##gff-version")) {
                return "gff";
            }
            if (firstLine.startsWith("##fileformat=")) {
                return firstLine.substring(13).toLowerCase();
            }
            int n = 0;
            while ((nextLine = reader.readLine()) != null && n++ < 100) {
                if (nextLine.startsWith("#")) continue;
                if (nextLine.startsWith("track")) {
                    TrackProperties properties = new TrackProperties();
                    ParsingUtils.parseTrackLine(nextLine, properties);
                    if (properties.getFormat() != null) {
                        return properties.getFormat();
                    }
                }
                if (!nextLine.startsWith("fixedStep") && !nextLine.startsWith("variableStep")) continue;
                return "wig";
            }
            if (FileFormatUtils.maybeSampleInfo(bytes)) {
                return "sampleinfo";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static boolean maybeSampleInfo(byte[] bytes) {
        try {
            if (!FileFormatUtils.isUTF8(bytes)) {
                return false;
            }
            String converted = new String(bytes, "UTF-8");
            int firstTab = converted.indexOf(9);
            if (firstTab < 0) {
                return false;
            }
            int secondTab = converted.indexOf(9, firstTab + 1);
            if (secondTab < 0) {
                return false;
            }
            boolean nullSeen = false;
            for (int i = 0; i < converted.length(); ++i) {
                if (converted.charAt(i) == '\u0000') {
                    nullSeen = true;
                    continue;
                }
                if (!nullSeen) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return true;
    }

    private static boolean isGzip(SeekableStream seekableStream) throws IOException {
        seekableStream.seek(0L);
        byte[] bytes = new byte[2];
        seekableStream.readFully(bytes);
        return bytes[0] == 31 && bytes[1] == -117;
    }

    private static boolean isUTF8(byte[] data) {
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            byte curr = data[i];
            int type = FileFormatUtils.getType(curr);
            if (type == 0) continue;
            if (type > 1 && i + type <= len) {
                while (type-- > 1) {
                    if (FileFormatUtils.getType(data[++i]) == 1) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static int getType(int num) {
        int[] masks = new int[]{128, 64, 32, 16, 8};
        for (int i = 0; i < 5; ++i) {
            if ((masks[i] & num) != 0) continue;
            return i;
        }
        return -1;
    }
}

