/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import htsjdk.samtools.util.SequenceUtil;
import java.util.HashMap;
import java.util.Map;

public class BaseModificationSet {
    char base;
    char strand;
    String modification;
    Map<Integer, Byte> likelihoods;
    char canonicalBase;
    static Map<String, String> codeValues = new HashMap<String, String>();

    public BaseModificationSet(char base, char strand, String modification, Map<Integer, Byte> likelihoods) {
        this.base = base;
        this.modification = modification;
        this.strand = strand;
        this.likelihoods = likelihoods;
        this.canonicalBase = strand == '+' ? base : (char)SequenceUtil.complement((byte)((byte)base));
    }

    public char getBase() {
        return this.base;
    }

    public char getCanonicalBase() {
        return this.canonicalBase;
    }

    public String getModification() {
        return this.modification;
    }

    public char getStrand() {
        return this.strand;
    }

    public Map<Integer, Byte> getLikelihoods() {
        return this.likelihoods;
    }

    public boolean containsPosition(Integer pos) {
        return this.likelihoods.containsKey(pos);
    }

    public String valueString(int pos) {
        int l = (int)(100.0 * (double)Byte.toUnsignedInt(this.likelihoods.get(pos)) / 255.0);
        return "Base modification: " + (codeValues.containsKey(this.modification) ? codeValues.get(this.modification) : this.modification) + " (" + l + "%)";
    }

    static {
        codeValues.put("m", "5mC");
        codeValues.put("h", "5hmC");
        codeValues.put("f", "5fC");
        codeValues.put("c", "5caC");
        codeValues.put("g", "5hmU");
        codeValues.put("e", "5fU");
        codeValues.put("b", "5caU");
        codeValues.put("a", "6mA");
        codeValues.put("o", "8xoG");
        codeValues.put("n", "Xao");
        codeValues.put("C", "Unknown C");
        codeValues.put("T", "Unknown T");
        codeValues.put("A", "Unknown A");
        codeValues.put("G", "Unknown G");
        codeValues.put("N", "Unknown");
    }
}

