/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class GenomeConfig
implements Cloneable {
    private static Logger log = LogManager.getLogger(GenomeConfig.class);
    private String id;
    private String name;
    private String fastaURL;
    private String indexURL;
    private String gziIndexURL;
    private String compressedIndexURL;
    private String twoBitURL;
    private String twoBitBptURL;
    private String nameSet;
    private boolean wholeGenomeView = true;
    private String defaultPos;
    private String description;
    private String blat;
    private String chromAliasBbURL;
    private String infoURL;
    private String cytobandURL;
    private String cytobandBbURL;
    private Boolean ordered;
    private String blatDB;
    private String ucsdID;
    private String aliasURL;
    private String[] chromosomeOrder;
    private String chains;
    private String chromSizesURL;
    private List<TrackConfig> tracks;
    private List<TrackConfig> annotations;
    private Sequence sequence;
    private LinkedHashMap<String, List<Cytoband>> cytobands;
    private List<List<String>> chromAliases;

    public static GenomeConfig fromJson(String json) {
        if (json.contains("chromosomeOrder")) {
            json = GenomeConfig.fixChromosomeOrder(json);
        }
        return (GenomeConfig)new Gson().fromJson(json, GenomeConfig.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFastaURL() {
        return this.fastaURL;
    }

    public void setFastaURL(String fastaURL) {
        this.fastaURL = fastaURL;
    }

    public String getIndexURL() {
        return this.indexURL;
    }

    public void setIndexURL(String indexURL) {
        this.indexURL = indexURL;
    }

    public String getGziIndexURL() {
        return this.gziIndexURL != null ? this.gziIndexURL : this.compressedIndexURL;
    }

    public void setGziIndexURL(String gziIndexURL) {
        this.gziIndexURL = gziIndexURL;
    }

    public String getTwoBitURL() {
        return this.twoBitURL;
    }

    public void setTwoBitURL(String twoBitURL) {
        this.twoBitURL = twoBitURL;
    }

    public String getNameSet() {
        return this.nameSet;
    }

    public void setNameSet(String nameSet) {
        this.nameSet = nameSet;
    }

    public boolean isWholeGenomeView() {
        return this.wholeGenomeView;
    }

    public void setWholeGenomeView(boolean wholeGenomeView) {
        this.wholeGenomeView = wholeGenomeView;
    }

    public String getDefaultPos() {
        return this.defaultPos;
    }

    public void setDefaultPos(String defaultPos) {
        this.defaultPos = defaultPos;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBlat() {
        return this.blat;
    }

    public void setBlat(String blat) {
        this.blat = blat;
    }

    public String getChromAliasBbURL() {
        return this.chromAliasBbURL;
    }

    public void setChromAliasBbURL(String chromAliasBbURL) {
        this.chromAliasBbURL = chromAliasBbURL;
    }

    public String getTwoBitBptURL() {
        return this.twoBitBptURL;
    }

    public void setTwoBitBptURL(String twoBitBptURL) {
        this.twoBitBptURL = twoBitBptURL;
    }

    public String getInfoURL() {
        return this.infoURL;
    }

    public void setInfoURL(String infoURL) {
        this.infoURL = infoURL;
    }

    public String getCytobandURL() {
        return this.cytobandURL;
    }

    public void setCytobandURL(String cytobandURL) {
        this.cytobandURL = cytobandURL;
    }

    public String getCytobandBbURL() {
        return this.cytobandBbURL;
    }

    public void setCytobandBbURL(String cytobandBbURL) {
        this.cytobandBbURL = cytobandBbURL;
    }

    public Boolean getOrdered() {
        return this.ordered;
    }

    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    public String getBlatDB() {
        return this.blatDB;
    }

    public void setBlatDB(String blatDB) {
        this.blatDB = blatDB;
    }

    public String getUcsdID() {
        return this.ucsdID;
    }

    public void setUcsdID(String ucsdID) {
        this.ucsdID = ucsdID;
    }

    public String getAliasURL() {
        return this.aliasURL;
    }

    public void setAliasURL(String aliasURL) {
        this.aliasURL = aliasURL;
    }

    public String[] getChromosomeOrder() {
        return this.chromosomeOrder;
    }

    public void setChromosomeOrder(String[] chromosomeOrder) {
        this.chromosomeOrder = chromosomeOrder;
    }

    public String getChains() {
        return this.chains;
    }

    public void setChains(String chains) {
        this.chains = chains;
    }

    public String getChromSizesURL() {
        return this.chromSizesURL;
    }

    public void setChromSizesURL(String chromSizesURL) {
        this.chromSizesURL = chromSizesURL;
    }

    public List<TrackConfig> getTrackConfigs() {
        return this.tracks != null ? this.tracks : this.annotations;
    }

    public void setTracks(List<TrackConfig> tracks) {
        this.tracks = tracks;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public LinkedHashMap<String, List<Cytoband>> getCytobands() {
        return this.cytobands;
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> cytobands) {
        this.cytobands = cytobands;
    }

    public List<List<String>> getChromAliases() {
        return this.chromAliases;
    }

    public void setChromAliases(List<List<String>> chromAliases) {
        this.chromAliases = chromAliases;
    }

    public GenomeConfig copy() {
        return this.clone();
    }

    protected GenomeConfig clone() {
        try {
            GenomeConfig clone = (GenomeConfig)super.clone();
            if (this.tracks != null) {
                clone.tracks = new ArrayList<TrackConfig>();
                for (TrackConfig trackConfig : this.tracks) {
                    clone.tracks.add(trackConfig.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Cloning not supported", e);
            return this;
        }
    }

    private static String fixChromosomeOrder(String jsonString) {
        Map obj = (Map)new Gson().fromJson(jsonString, Map.class);
        Object chromosomeOrder = obj.get("chromosomeOrder");
        if (chromosomeOrder != null && chromosomeOrder instanceof String) {
            obj.put("chromosomeOrder", Arrays.stream(((String)chromosomeOrder).split(",")).map(c -> c.trim()).toArray());
        }
        return new Gson().toJson((Object)obj);
    }
}

