/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.broad.igv.DirectoryManager;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeDownloadUtils;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.IGVDialog;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;

public class HostedGenomeSelectionDialog
extends IGVDialog {
    private static Logger log = LogManager.getLogger(HostedGenomeSelectionDialog.class);
    private static final int PREF_WIDTH = 600;
    private static final int PREF_HEIGHT = 500;
    private JTextField genomeFilter;
    private JList<GenomeListItem> genomeList;
    private JCheckBox downloadSequenceCB;
    private JCheckBox downloadAnnotationsCB;
    JPanel downloadSequencePanel;
    ButtonGroup downloadSequenceGroup;
    private JRadioButton downloadSequenceRB;
    private JRadioButton remoteSequenceRB;
    JPanel downloadAnnotationsPanel;
    ButtonGroup downloadAnnotationsGroup;
    private JRadioButton downloadAnnotationsRB;
    private JRadioButton remoteAnnotationsRB;
    private boolean isCanceled;
    private List<GenomeListItem> allListItems;
    private DefaultListModel genomeListModel;

    public static void downloadHostedGenome() {
        Runnable showDialog = () -> {
            List<GenomeListItem> inputListItems = GenomeListManager.getInstance().getHostedGenomeList();
            if (inputListItems == null) {
                return;
            }
            HostedGenomeSelectionDialog dialog = new HostedGenomeSelectionDialog(IGV.getInstance().getMainFrame(), inputListItems);
            UIUtilities.invokeAndWaitOnEventThread(() -> dialog.setVisible(true));
            if (dialog.isCanceled()) {
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            } else {
                GenomeListItem selectedItem = dialog.getSelectedValue();
                if (selectedItem == null) {
                    return;
                }
                boolean downloadSequence = dialog.isDownloadSequence();
                boolean downloadAnnotations = dialog.isDownloadAnnotations();
                File downloadPath = GenomeManager.getInstance().downloadGenome(selectedItem, downloadSequence, downloadAnnotations);
                try {
                    if (downloadPath != null) {
                        GenomeManager.getInstance().loadGenome(downloadPath.getAbsolutePath());
                    } else {
                        GenomeManager.getInstance().loadGenome(selectedItem.getPath());
                    }
                    if (selectedItem.getPath().endsWith(".json")) {
                        HostedGenomeSelectionDialog.removeDotGenomeFile(selectedItem.getId());
                    }
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error loading genome " + selectedItem.getDisplayableName(), e);
                    log.error("Error loading genome " + selectedItem.getDisplayableName(), e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            LongRunningTask.submit(showDialog);
        } else {
            showDialog.run();
        }
    }

    private static void removeDotGenomeFile(String id) {
        try {
            File dotGenomeFile = new File(DirectoryManager.getGenomeCacheDirectory(), id + ".genome");
            if (dotGenomeFile.exists()) {
                dotGenomeFile.delete();
            }
        }
        catch (Exception e) {
            log.error("Error deleting .genome file", e);
        }
    }

    private HostedGenomeSelectionDialog(Frame parent, Collection<GenomeListItem> inputListItems) {
        super(parent);
        this.initComponents();
        this.initData(inputListItems);
    }

    private void initData(Collection<GenomeListItem> inputListItems) {
        this.allListItems = new ArrayList<GenomeListItem>(inputListItems);
        String filterText = this.genomeFilter.getText().trim().toLowerCase();
        this.rebuildHostedGenomeList(filterText);
    }

    private void rebuildHostedGenomeList(String filterText) {
        if (this.genomeListModel == null) {
            this.genomeListModel = new DefaultListModel();
            UIUtilities.invokeOnEventThread(() -> this.genomeList.setModel(this.genomeListModel));
        }
        this.genomeListModel.clear();
        filterText = filterText.toLowerCase().trim();
        for (GenomeListItem listItem : this.allListItems) {
            if (!listItem.getDisplayableName().toLowerCase().contains(filterText)) continue;
            this.genomeListModel.addElement(listItem);
        }
    }

    private void genomeEntryKeyReleased(KeyEvent e) {
        this.rebuildHostedGenomeList(this.genomeFilter.getText());
    }

    public GenomeListItem getSelectedValue() {
        return this.isCanceled ? null : this.genomeList.getSelectedValue();
    }

    public boolean isDownloadSequence() {
        return this.downloadSequenceRB.isSelected();
    }

    public boolean isDownloadAnnotations() {
        return this.downloadAnnotationsRB.isSelected();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private void configureDownloadButtons(GenomeListItem item) {
        if (item != null) {
            boolean sequenceDownloadable = GenomeDownloadUtils.isSequenceDownloadable(item.getPath());
            boolean annotationsDownloadable = GenomeDownloadUtils.isAnnotationsDownloadable(item.getPath());
            this.downloadSequenceRB.setVisible(sequenceDownloadable);
            this.remoteSequenceRB.setVisible(sequenceDownloadable);
            this.downloadAnnotationsRB.setVisible(annotationsDownloadable);
            this.remoteAnnotationsRB.setVisible(annotationsDownloadable);
        }
    }

    private void initComponents() {
        this.setModal(true);
        this.setTitle("Hosted Genomes");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel dialogPane = new JPanel();
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setPreferredSize(new Dimension(600, 500));
        dialogPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JTextArea textArea1 = new JTextArea();
        textArea1.setText("Selected genomes will be downloaded and added to the genome dropdown list.");
        textArea1.setLineWrap(true);
        textArea1.setWrapStyleWord(true);
        textArea1.setBackground(UIManager.getColor("Button.background"));
        textArea1.setRows(2);
        textArea1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        textArea1.setRequestFocusEnabled(false);
        textArea1.setEditable(false);
        contentPanel.add(textArea1);
        JPanel filterPanel = new JPanel();
        filterPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 28));
        filterPanel.setLayout(new BorderLayout());
        JLabel filterLabel = new JLabel("Filter:  ");
        filterLabel.setLabelFor(this.genomeFilter);
        filterLabel.setRequestFocusEnabled(false);
        filterPanel.add((Component)filterLabel, "West");
        this.genomeFilter = new JTextField();
        this.genomeFilter.setToolTipText("Filter genome list");
        this.genomeFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HostedGenomeSelectionDialog.this.genomeEntryKeyReleased(e);
            }
        });
        filterPanel.add((Component)this.genomeFilter, "Center");
        contentPanel.add(filterPanel);
        this.genomeList = new JList();
        this.genomeList.setSelectionMode(0);
        this.genomeList.addListSelectionListener(e -> {
            GenomeListItem item = this.genomeList.getSelectedValue();
            if (item != null) {
                this.configureDownloadButtons(item);
            }
        });
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this.genomeList);
        contentPanel.add(scrollPane1);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(2, 0));
        p1.setPreferredSize(new Dimension(500, 50));
        p1.setMinimumSize(new Dimension(500, 50));
        p1.setMaximumSize(new Dimension(1000, 50));
        this.downloadSequenceRB = new JRadioButton("Download sequence");
        this.remoteSequenceRB = new JRadioButton("Use remote sequence");
        this.remoteSequenceRB.setSelected(true);
        this.downloadSequenceRB.setVisible(false);
        this.remoteSequenceRB.setVisible(false);
        this.downloadSequenceGroup = new ButtonGroup();
        this.downloadSequenceGroup.add(this.downloadSequenceRB);
        this.downloadSequenceGroup.add(this.remoteSequenceRB);
        this.downloadSequencePanel = new JPanel();
        FlowLayout layout = new FlowLayout(0);
        this.downloadSequencePanel.setLayout(layout);
        this.downloadSequencePanel.add(this.downloadSequenceRB);
        this.downloadSequencePanel.add(this.remoteSequenceRB);
        p1.add(this.downloadSequencePanel);
        this.downloadAnnotationsRB = new JRadioButton("Download annotations");
        this.remoteAnnotationsRB = new JRadioButton("Use remote annotations");
        this.remoteAnnotationsRB.setSelected(true);
        this.downloadAnnotationsRB.setVisible(false);
        this.remoteAnnotationsRB.setVisible(false);
        this.downloadAnnotationsGroup = new ButtonGroup();
        this.downloadAnnotationsGroup.add(this.downloadAnnotationsRB);
        this.downloadAnnotationsGroup.add(this.remoteAnnotationsRB);
        this.downloadAnnotationsPanel = new JPanel();
        FlowLayout layout1 = new FlowLayout(0);
        this.downloadAnnotationsPanel.setLayout(layout1);
        this.downloadAnnotationsPanel.add(this.downloadAnnotationsRB);
        this.downloadAnnotationsPanel.add(this.remoteAnnotationsRB);
        p1.add(this.downloadAnnotationsPanel);
        contentPanel.add(p1);
        dialogPane.add((Component)contentPanel, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.okButtonActionPerformed(e));
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        buttonBar.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

