/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class UnsignedByteBufferDynamic
implements UnsignedByteBuffer {
    private ByteBuffer wrappedBuffer;
    private long offset;
    private long originalOffset;
    int bufferSize;
    ByteOrder byteOrder;
    String path;

    public static UnsignedByteBufferDynamic loadBinaryBuffer(String path, ByteOrder byteOrder, long start, int size) throws IOException {
        UnsignedByteBufferDynamic b = new UnsignedByteBufferDynamic(path, byteOrder, start, size);
        b.updateBuffer();
        return b;
    }

    private UnsignedByteBufferDynamic(String path, ByteOrder byteOrder, long start, int bufferSize) {
        this.path = path;
        this.byteOrder = byteOrder;
        this.offset = start;
        this.originalOffset = start;
        this.bufferSize = bufferSize;
    }

    private void advanceBuffer() {
        this.offset += (long)(this.wrappedBuffer == null ? 0 : this.wrappedBuffer.position());
        this.updateBuffer();
    }

    private void updateBuffer() {
        try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);){
            this.wrappedBuffer = ByteBuffer.allocate(this.bufferSize);
            this.wrappedBuffer.order(this.byteOrder);
            byte[] bytes = this.wrappedBuffer.array();
            is.seek(this.offset);
            try {
                is.readFully(bytes);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public byte get() {
        if (this.wrappedBuffer.remaining() < 1) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.get();
    }

    @Override
    public short getShort() {
        if (this.wrappedBuffer.remaining() < 2) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.getShort();
    }

    @Override
    public int getUShort() {
        if (this.wrappedBuffer.remaining() < 2) {
            this.advanceBuffer();
        }
        return Short.toUnsignedInt(this.wrappedBuffer.getShort());
    }

    @Override
    public int getInt() {
        if (this.wrappedBuffer.remaining() < 4) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.getInt();
    }

    @Override
    public long getUInt() {
        if (this.wrappedBuffer.remaining() < 4) {
            this.advanceBuffer();
        }
        return Integer.toUnsignedLong(this.wrappedBuffer.getInt());
    }

    @Override
    public long getLong() {
        if (this.wrappedBuffer.remaining() < 8) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.getLong();
    }

    @Override
    public float getFloat() {
        if (this.wrappedBuffer.remaining() < 4) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.getFloat();
    }

    @Override
    public double getDouble() {
        if (this.wrappedBuffer.remaining() < 8) {
            this.advanceBuffer();
        }
        return this.wrappedBuffer.getDouble();
    }

    @Override
    public String getString() {
        byte b;
        if (this.wrappedBuffer.remaining() < 1000) {
            this.advanceBuffer();
        }
        ByteArrayOutputStream bis = new ByteArrayOutputStream(1000);
        while ((b = this.wrappedBuffer.get()) != 0) {
            bis.write(b);
        }
        return new String(bis.toByteArray());
    }

    @Override
    public String getFixedLengthString(int length) {
        if (this.wrappedBuffer.remaining() < length) {
            this.advanceBuffer();
        }
        byte[] bytes = new byte[length];
        int nonPaddedLength = 0;
        this.wrappedBuffer.get(bytes);
        for (int i = 0; i < length && bytes[i] != 0; ++i) {
            ++nonPaddedLength;
        }
        return new String(bytes, 0, nonPaddedLength);
    }

    @Override
    public int position() {
        return (int)(this.offset - this.originalOffset) + this.wrappedBuffer.position();
    }

    @Override
    public void position(int i) {
        int newBufferPosition = i - (int)(this.offset - this.originalOffset);
        if (newBufferPosition < 0 || newBufferPosition > this.wrappedBuffer.position() + this.wrappedBuffer.remaining()) {
            this.offset = this.originalOffset + (long)i;
            this.updateBuffer();
        } else {
            this.wrappedBuffer.position(newBufferPosition);
        }
    }

    @Override
    public int remaining() {
        return this.wrappedBuffer.remaining();
    }
}

