/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.IGVNamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class JsonGenomeLoader
extends GenomeLoader {
    private static Logger log = LogManager.getLogger(JsonGenomeLoader.class);
    private String genomePath;

    public JsonGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        GenomeConfig genomeConfig = this.loadGenomeConfig();
        Genome genome = new Genome(genomeConfig);
        return genome;
    }

    public GenomeConfig loadGenomeConfig() throws IOException {
        try (InputStream is = ParsingUtils.openInputStream(this.genomePath);){
            String jsonString = ParsingUtils.readContentsFromStream(is);
            GenomeConfig genomeConfig = GenomeConfig.fromJson(jsonString);
            this.fixPaths(genomeConfig);
            GenomeConfig genomeConfig2 = genomeConfig;
            return genomeConfig2;
        }
    }

    private GenomeConfig fixPaths(GenomeConfig config) {
        List<TrackConfig> trackConfigs;
        if (config.getChromAliasBbURL() != null) {
            config.setChromAliasBbURL(FileUtils.getAbsolutePath(config.getChromAliasBbURL(), this.genomePath));
        }
        if (config.getTwoBitURL() != null) {
            config.setTwoBitURL(FileUtils.getAbsolutePath(config.getTwoBitURL(), this.genomePath));
        }
        if (config.getTwoBitBptURL() != null) {
            config.setTwoBitBptURL(FileUtils.getAbsolutePath(config.getTwoBitBptURL(), this.genomePath));
        }
        if (config.getCytobandBbURL() != null) {
            config.setCytobandBbURL(FileUtils.getAbsolutePath(config.getCytobandBbURL(), this.genomePath));
        }
        if (config.getChromSizesURL() != null) {
            config.setChromSizesURL(FileUtils.getAbsolutePath(config.getChromSizesURL(), this.genomePath));
        }
        if (config.getFastaURL() != null) {
            config.setFastaURL(FileUtils.getAbsolutePath(config.getFastaURL(), this.genomePath));
        }
        if (config.getIndexURL() != null) {
            config.setIndexURL(FileUtils.getAbsolutePath(config.getIndexURL(), this.genomePath));
        }
        if (config.getGziIndexURL() != null) {
            config.setGziIndexURL(FileUtils.getAbsolutePath(config.getGziIndexURL(), this.genomePath));
        }
        if (config.getCytobandURL() != null) {
            config.setCytobandURL(FileUtils.getAbsolutePath(config.getCytobandURL(), this.genomePath));
        }
        if (config.getAliasURL() != null) {
            config.setAliasURL(FileUtils.getAbsolutePath(config.getAliasURL(), this.genomePath));
        }
        if (config.getChromAliasBbURL() != null) {
            config.setChromAliasBbURL(FileUtils.getAbsolutePath(config.getChromAliasBbURL(), this.genomePath));
        }
        if ((trackConfigs = config.getTrackConfigs()) != null) {
            trackConfigs.forEach(trackConfig -> {
                if (trackConfig.getUrl() != null) {
                    trackConfig.setUrl(FileUtils.getAbsolutePath(trackConfig.getUrl(), this.genomePath));
                }
                if (trackConfig.getIndexURL() != null) {
                    trackConfig.setIndexURL(FileUtils.getAbsolutePath(trackConfig.getIndexURL(), this.genomePath));
                }
            });
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeDescriptor loadDescriptor() throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
            String id = json.get("id").getAsString();
            String name = json.get("name").getAsString();
            String fastaPath = json.get("fastaURL").getAsString();
            GenomeDescriptor genomeDescriptor = new GenomeDescriptor(id, name, fastaPath);
            return genomeDescriptor;
        }
    }

    private void addToFeatureDB(List<ResourceLocator> locators, Genome genome) {
        for (ResourceLocator locator : locators) {
            try {
                AbstractFeatureReader featureReader = TribbleFeatureSource.getBasicReader(locator, genome);
                for (Feature f : featureReader) {
                    if (!(f instanceof IGVNamedFeature)) continue;
                    FeatureDB.addFeature((IGVNamedFeature)f, genome);
                }
            }
            catch (IOException e) {
                log.error("Error loading " + locator.getPath());
            }
        }
    }

    private String stripQuotes(String str) {
        if (str.startsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static class GenomeDescriptor {
        String id;
        String name;
        String fastaURL;

        public GenomeDescriptor(String id, String name, String fastaURL) {
            this.id = id;
            this.name = name;
            this.fastaURL = fastaURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getFastaURL() {
            return this.fastaURL;
        }
    }
}

