/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.common.primitives.Primitives;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaAgent {
    private static Map<Class, Long> primitiveMemMap = new HashMap<Class, Long>(9);
    private static Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static long getObjectSize(Object o) {
        if (instrumentation == null) {
            throw new IllegalStateException("No instrumentation available. Need to launch width -javaagent:path/to/RuntimeUtils.jar");
        }
        if (o == null) {
            return 4L;
        }
        return instrumentation.getObjectSize(o);
    }

    public static long getObjectSizeRecursive(Object o, Set<Object> completedObjs) {
        try {
            if (o != null && completedObjs.contains(o)) {
                return 0L;
            }
        }
        catch (Exception e) {
            System.out.println("Error on " + String.valueOf(o.getClass()) + " skipping");
            return 0L;
        }
        long fullSize = JavaAgent.getObjectSize(o);
        if (o == null) {
            return fullSize;
        }
        completedObjs.add(o);
        if (JavaAgent.isPrimitiveOrWrapper(o)) {
            return fullSize;
        }
        if (o.getClass().isArray()) {
            for (int ii = 0; ii < Array.getLength(o); ++ii) {
                Object el = Array.get(o, ii);
                fullSize += JavaAgent.getObjectSizeRecursive(el, completedObjs);
            }
        }
        HashSet<Field> fields = new HashSet<Field>();
        JavaAgent.getAllFields(o.getClass(), fields);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(o);
                Class<?> fieldType = field.getType();
                fullSize = fieldType.isPrimitive() ? (fullSize += primitiveMemMap.get(fieldType).longValue()) : (fullSize += JavaAgent.getObjectSizeRecursive(fieldValue, completedObjs));
                completedObjs.add(fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NullPointerException e) {
                System.out.println("Error on " + String.valueOf(o.getClass()) + " skipping");
            }
        }
        return fullSize;
    }

    static boolean isPrimitiveOrWrapper(Object o) {
        return o.getClass().isPrimitive() || Primitives.isWrapperType(o.getClass());
    }

    static void getAllFields(Class clazz, Set<Field> fields) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class supClass = clazz.getSuperclass();
        if (supClass != null) {
            JavaAgent.getAllFields(supClass, fields);
        }
    }

    static {
        primitiveMemMap.put(Byte.TYPE, 8L);
        primitiveMemMap.put(Short.TYPE, 16L);
        primitiveMemMap.put(Integer.TYPE, 32L);
        primitiveMemMap.put(Long.TYPE, 64L);
        primitiveMemMap.put(Float.TYPE, 32L);
        primitiveMemMap.put(Double.TYPE, 64L);
        primitiveMemMap.put(Boolean.TYPE, 1L);
        primitiveMemMap.put(Character.TYPE, 16L);
        primitiveMemMap.put(Void.TYPE, 0L);
        assert (primitiveMemMap.size() == Primitives.allPrimitiveTypes().size());
    }
}

