/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public final class Histogram<K extends Comparable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String binLabel = "BIN";
    private String valueLabel = "VALUE";
    private final NavigableMap<K, Bin<K>> map;

    public Histogram() {
        this.map = new TreeMap<K, Bin<K>>();
    }

    public Histogram(String binLabel, String valueLabel) {
        this();
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Comparator<? super K> comparator) {
        this.map = new TreeMap<K, Bin<K>>(comparator);
    }

    public Histogram(String binLabel, String valueLabel, Comparator<? super K> comparator) {
        this(comparator);
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Histogram<K> in) {
        this.map = new TreeMap<K, Bin<K>>(in.map);
        this.binLabel = in.binLabel;
        this.valueLabel = in.valueLabel;
    }

    public void prefillBins(K ... ids) {
        for (K id : ids) {
            this.map.put(id, new Bin<K>(id));
        }
    }

    public void increment(K id) {
        this.increment(id, 1.0);
    }

    public void increment(K id, double increment) {
        Bin<K> bin = (Bin<K>)this.map.get(id);
        if (bin == null) {
            bin = new Bin<K>(id);
            this.map.put(id, bin);
        }
        bin.value += increment;
    }

    public String getBinLabel() {
        return this.binLabel;
    }

    public void setBinLabel(String binLabel) {
        this.binLabel = binLabel;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o != null && o instanceof Histogram && ((Histogram)o).binLabel.equals(this.binLabel) && ((Histogram)o).valueLabel.equals(this.valueLabel) && ((Histogram)o).map.equals(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return Objects.hash(this.binLabel, this.valueLabel, this.map);
    }

    public double getMean() {
        double product = 0.0;
        double totalCount = 0.0;
        for (Bin bin : this.map.values()) {
            double idValue = bin.getIdValue();
            double count = bin.getValue();
            product += idValue * count;
            totalCount += count;
        }
        return product / totalCount;
    }

    public double getSum() {
        double total = 0.0;
        for (Bin bin : this.map.values()) {
            total += bin.getValue() * bin.getIdValue();
        }
        return total;
    }

    public double getSumOfValues() {
        double total = 0.0;
        for (Bin bin : this.map.values()) {
            total += bin.getValue();
        }
        return total;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        double count = 0.0;
        double total = 0.0;
        for (Bin bin : this.map.values()) {
            double localCount = bin.getValue();
            double value = bin.getIdValue();
            count += localCount;
            total += localCount * Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(total / (count - 1.0));
    }

    public double getMeanBinSize() {
        return this.getSumOfValues() / (double)this.size();
    }

    public int size() {
        return this.map.size();
    }

    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    public double getMedianBinSize() {
        if (this.size() == 0) {
            return 0.0;
        }
        ArrayList<Double> binValues = new ArrayList<Double>();
        for (Bin<K> bin : this.values()) {
            binValues.add(bin.getValue());
        }
        Collections.sort(binValues);
        int midPoint = binValues.size() / 2;
        double median = (Double)binValues.get(midPoint);
        if (binValues.size() % 2 == 0) {
            median = (median + (Double)binValues.get(midPoint - 1)) / 2.0;
        }
        return median;
    }

    public Collection<Bin<K>> values() {
        return this.map.values();
    }

    public double getStandardDeviationBinSize(double mean) {
        double total = 0.0;
        for (Bin<K> bin : this.values()) {
            total += Math.pow(bin.getValue() - mean, 2.0);
        }
        return Math.sqrt(total / (double)Math.max(1, this.values().size() - 1));
    }

    public double getPercentile(double percentile) {
        if (percentile <= 0.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 0 or below");
        }
        if (percentile >= 1.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 1 or above");
        }
        this.values().stream().filter(b -> b.getValue() < 0.0).findFirst().ifPresent(b -> {
            throw new IllegalStateException("Cannot calculate Percentile when negative counts are present in histogram. Bin " + String.valueOf(b.getId()) + "=" + b.getValue());
        });
        double total = this.getCount();
        if (total == 0.0) {
            throw new IllegalStateException("Cannot calculate percentiles when total is zero.");
        }
        double soFar = 0.0;
        for (Bin<K> bin : this.values()) {
            if (!((soFar += bin.getValue()) / total >= percentile)) continue;
            return bin.getIdValue();
        }
        throw new IllegalStateException("UNPOSSIBLE! Could not find percentile: " + percentile);
    }

    public double getCumulativeProbability(double v) {
        double count = 0.0;
        double total = 0.0;
        for (Bin<K> bin : this.values()) {
            double binValue = bin.getIdValue();
            if (binValue <= v) {
                count += bin.getValue();
            }
            total += bin.getValue();
        }
        return count / total;
    }

    public double getMedian() {
        double midHigh;
        double midLow;
        double total = 0.0;
        double count = this.getCount();
        if (count == 0.0) {
            return 0.0;
        }
        if (count == 1.0) {
            return this.values().iterator().next().getIdValue();
        }
        if (count % 2.0 == 0.0) {
            midLow = count / 2.0;
            midHigh = midLow + 1.0;
        } else {
            midHigh = midLow = Math.ceil(count / 2.0);
        }
        Double midLowValue = null;
        Double midHighValue = null;
        for (Bin<K> bin : this.values()) {
            total += bin.getValue();
            if (midLowValue == null && total >= midLow) {
                midLowValue = bin.getIdValue();
            }
            if (midHighValue == null && total >= midHigh) {
                midHighValue = bin.getIdValue();
            }
            if (midLowValue == null || midHighValue == null) continue;
            break;
        }
        return (midLowValue + midHighValue) / 2.0;
    }

    public double getMedianAbsoluteDeviation() {
        double median = this.getMedian();
        Histogram<Double> deviations = new Histogram<Double>();
        for (Bin<K> bin : this.values()) {
            double dev = Math.abs(bin.getIdValue() - median);
            deviations.increment(dev, bin.getValue());
        }
        return deviations.getMedian();
    }

    public double estimateSdViaMad() {
        return 1.4826 * this.getMedianAbsoluteDeviation();
    }

    public double getMode() {
        return this.getModeBin().getIdValue();
    }

    private Bin<K> getModeBin() {
        Bin<K> modeBin = null;
        for (Bin<K> bin : this.values()) {
            if (modeBin != null && !(modeBin.value < bin.value)) continue;
            modeBin = bin;
        }
        return modeBin;
    }

    public double getMin() {
        return this.map.firstEntry().getValue().getIdValue();
    }

    public double getMax() {
        return this.map.lastEntry().getValue().getIdValue();
    }

    public double getCount() {
        double count = 0.0;
        for (Bin<K> bin : this.values()) {
            count += bin.value;
        }
        return count;
    }

    public double getGeometricMean() {
        double total = 0.0;
        double count = 0.0;
        for (Bin<K> bin : this.values()) {
            total += bin.value * Math.log(bin.getIdValue());
            count += bin.value;
        }
        return Math.exp(total / count);
    }

    public void trimByTailLimit(int tailLimit) {
        Object[] keys;
        if (this.isEmpty()) {
            return;
        }
        Bin<K> modeBin = this.getModeBin();
        double mode = modeBin.getIdValue();
        double sizeOfModeBin = modeBin.getValue();
        double minimumBinSize = sizeOfModeBin / (double)tailLimit;
        Bin<K> lastBin = null;
        ArrayList<K> binsToKeep = new ArrayList<K>();
        for (Bin<K> bin : this.values()) {
            double binId = ((Number)bin.getId()).doubleValue();
            if (binId <= mode) {
                binsToKeep.add(bin.getId());
            } else {
                if (lastBin != null && ((Number)lastBin.getId()).doubleValue() != binId - 1.0 || bin.getValue() < minimumBinSize) break;
                binsToKeep.add(bin.getId());
            }
            lastBin = bin;
        }
        for (Object binId : keys = this.keySet().toArray()) {
            if (binsToKeep.contains(binId)) continue;
            this.remove(binId);
        }
    }

    private Bin<K> remove(Object key) {
        return (Bin)this.map.remove(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void trimByWidth(int width) {
        Iterator<K> it = this.map.descendingKeySet().iterator();
        while (it.hasNext() && ((Number)it.next()).doubleValue() > (double)width) {
            it.remove();
        }
    }

    public Histogram<K> divideByHistogram(Histogram<K> divisorHistogram) {
        Histogram<Comparable> output = new Histogram<Comparable>();
        if (!this.keySet().equals(divisorHistogram.keySet())) {
            throw new IllegalArgumentException("Attempting to divide Histograms with non-identical bins");
        }
        for (Comparable key : this.keySet()) {
            Bin<Comparable> dividend = this.get(key);
            Bin<Comparable> divisor = divisorHistogram.get(key);
            output.increment(key, dividend.getValue() / divisor.getValue());
        }
        return output;
    }

    public void addHistogram(Histogram<K> addHistogram) {
        for (Comparable key : addHistogram.keySet()) {
            this.increment(key, addHistogram.get(key).getValue());
        }
    }

    public Bin<K> get(K key) {
        return (Bin)this.map.get(key);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public static class Bin<K extends Comparable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final K id;
        private double value = 0.0;

        private Bin(K id) {
            this.id = id;
        }

        public K getId() {
            return this.id;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bin bin = (Bin)o;
            if (Double.compare(bin.value, this.value) != 0) {
                return false;
            }
            return this.id.equals(bin.id);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public double getIdValue() {
            if (this.id instanceof Number) {
                return ((Number)this.id).doubleValue();
            }
            throw new UnsupportedOperationException("getIdValue only supported for Histogram<? extends Number>");
        }
    }
}

