/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.RANS4x8ExternalCompressor;
import htsjdk.samtools.cram.compression.RANSNx16ExternalCompressor;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Decode;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Encode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Decode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Encode;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.utils.ValidationUtils;
import java.util.HashMap;

public class CompressorCache {
    private final String argErrorMessage = "Invalid compression arg (%d) requested for CRAM %s compressor";
    private final HashMap<CompressorCacheRecord, ExternalCompressor> compressorCache = new HashMap();
    private RANS4x8Encode sharedRANS4x8Encode;
    private RANS4x8Decode sharedRANS4x8Decode;
    private RANSNx16Encode sharedRANSNx16Encode;
    private RANSNx16Decode sharedRANSNx16Decode;

    public ExternalCompressor getCompressorForMethod(BlockCompressionMethod compressionMethod, int compressorSpecificArg) {
        switch (compressionMethod) {
            case GZIP: 
            case ADAPTIVE_ARITHMETIC: 
            case FQZCOMP: 
            case NAME_TOKENISER: {
                return this.getCachedCompressorForMethod(compressionMethod, compressorSpecificArg);
            }
            case BZIP2: 
            case RAW: 
            case LZMA: {
                ValidationUtils.validateArg(compressorSpecificArg == -1, String.format("Invalid compression arg (%d) requested for CRAM %s compressor", new Object[]{compressorSpecificArg, compressionMethod}));
                return this.getCachedCompressorForMethod(compressionMethod, compressorSpecificArg);
            }
            case RANS: {
                int ransArg = compressorSpecificArg == -1 ? RANSParams.ORDER.ZERO.ordinal() : compressorSpecificArg;
                CompressorCacheRecord compressorRec = new CompressorCacheRecord(BlockCompressionMethod.RANS, ransArg);
                if (!this.compressorCache.containsKey(compressorRec)) {
                    if (this.sharedRANS4x8Encode == null) {
                        this.sharedRANS4x8Encode = new RANS4x8Encode();
                    }
                    if (this.sharedRANS4x8Decode == null) {
                        this.sharedRANS4x8Decode = new RANS4x8Decode();
                    }
                    this.compressorCache.put(compressorRec, new RANS4x8ExternalCompressor(ransArg, this.sharedRANS4x8Encode, this.sharedRANS4x8Decode));
                }
                return this.getCachedCompressorForMethod(compressorRec.method, compressorRec.compressorArg);
            }
            case RANSNx16: {
                int ransArg = compressorSpecificArg == -1 ? RANSParams.ORDER.ZERO.ordinal() : compressorSpecificArg;
                CompressorCacheRecord compressorRec = new CompressorCacheRecord(BlockCompressionMethod.RANSNx16, ransArg);
                if (!this.compressorCache.containsKey(compressorRec)) {
                    if (this.sharedRANSNx16Encode == null) {
                        this.sharedRANSNx16Encode = new RANSNx16Encode();
                    }
                    if (this.sharedRANSNx16Decode == null) {
                        this.sharedRANSNx16Decode = new RANSNx16Decode();
                    }
                    this.compressorCache.put(compressorRec, new RANSNx16ExternalCompressor(ransArg, this.sharedRANSNx16Encode, this.sharedRANSNx16Decode));
                }
                return this.getCachedCompressorForMethod(compressorRec.method, compressorRec.compressorArg);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown compression method %s", new Object[]{compressionMethod}));
    }

    private ExternalCompressor getCachedCompressorForMethod(BlockCompressionMethod method, int compressorSpecificArg) {
        return this.compressorCache.computeIfAbsent(new CompressorCacheRecord(method, compressorSpecificArg), k -> ExternalCompressor.getCompressorForMethod(method, compressorSpecificArg));
    }

    private record CompressorCacheRecord(BlockCompressionMethod method, int compressorArg) {
    }
}

