/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.CRAMCodecModelContext;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.utils.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class GZIPExternalCompressor
extends ExternalCompressor {
    private final int writeCompressionLevel;

    public GZIPExternalCompressor() {
        this(Defaults.COMPRESSION_LEVEL);
    }

    public GZIPExternalCompressor(int compressionLevel) {
        super(BlockCompressionMethod.GZIP);
        ValidationUtils.validateArg(compressionLevel >= 0 && compressionLevel <= 9, String.format("Invalid compression level (%d) requested for CRAM GZIP compression", compressionLevel));
        this.writeCompressionLevel = compressionLevel;
    }

    public int getWriteCompressionLevel() {
        return this.writeCompressionLevel;
    }

    @Override
    public byte[] compress(byte[] data, CRAMCodecModelContext unused_contextModel) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gos = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(GZIPExternalCompressor.this.writeCompressionLevel);
            }
        };){
            IOUtil.copyStream(new ByteArrayInputStream(data), gos);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] uncompress(byte[] data) {
        byte[] byArray;
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(data));
        try {
            byArray = InputStreamUtils.readFully(gzipInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        gzipInputStream.close();
        return byArray;
    }

    @Override
    public String toString() {
        return String.format("%s(%d)", super.toString(), this.writeCompressionLevel);
    }
}

