/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import java.io.Serializable;
import java.util.Arrays;

public class SAMBinaryTagAndValue
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final short tag;
    public final Object value;
    protected SAMBinaryTagAndValue next = null;

    public SAMBinaryTagAndValue(short tag, Object value) {
        if (null == value) {
            throw new IllegalArgumentException("SAMBinaryTagAndValue value may not be null");
        }
        if (!SAMBinaryTagAndValue.isAllowedAttributeValue(value)) {
            throw new IllegalArgumentException("Attribute type " + String.valueOf(value.getClass()) + " not supported. Tag: " + SAMTag.makeStringTag(tag));
        }
        this.tag = tag;
        this.value = value;
    }

    protected static boolean isAllowedAttributeValue(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof String || value instanceof Character || value instanceof Float || value instanceof byte[] || value instanceof short[] || value instanceof int[] || value instanceof float[]) {
            return true;
        }
        if (value instanceof Long) {
            return SAMUtils.isValidUnsignedIntegerAttribute((Long)value) || (Long)value >= Integer.MIN_VALUE && (Long)value <= Integer.MAX_VALUE;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.typeSafeEquals((SAMBinaryTagAndValue)o);
    }

    private boolean typeSafeEquals(SAMBinaryTagAndValue that) {
        if (this.tag != that.tag) {
            return false;
        }
        if (this.valueEquals(that)) {
            if (this.next == null) {
                return that.next == null;
            }
            return this.next.equals(that.next);
        }
        return false;
    }

    private boolean valueEquals(SAMBinaryTagAndValue that) {
        if (this.value instanceof byte[]) {
            return that.value instanceof byte[] ? Arrays.equals((byte[])this.value, (byte[])that.value) : false;
        }
        if (this.value instanceof short[]) {
            return that.value instanceof short[] ? Arrays.equals((short[])this.value, (short[])that.value) : false;
        }
        if (this.value instanceof int[]) {
            return that.value instanceof int[] ? Arrays.equals((int[])this.value, (int[])that.value) : false;
        }
        if (this.value instanceof float[]) {
            return that.value instanceof float[] ? Arrays.equals((float[])this.value, (float[])that.value) : false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int valueHash = this.value instanceof byte[] ? Arrays.hashCode((byte[])this.value) : (this.value instanceof short[] ? Arrays.hashCode((short[])this.value) : (this.value instanceof int[] ? Arrays.hashCode((int[])this.value) : (this.value instanceof float[] ? Arrays.hashCode((float[])this.value) : this.value.hashCode())));
        return 31 * this.tag + valueHash;
    }

    public SAMBinaryTagAndValue copy() {
        SAMBinaryTagAndValue retval = new SAMBinaryTagAndValue(this.tag, this.value);
        if (this.next != null) {
            retval.next = this.next.copy();
        }
        return retval;
    }

    public SAMBinaryTagAndValue deepCopy() {
        SAMBinaryTagAndValue retval = new SAMBinaryTagAndValue(this.tag, this.cloneValue());
        if (this.next != null) {
            retval.next = this.next.deepCopy();
        }
        return retval;
    }

    protected Object cloneValue() {
        Object valueClone = this.value instanceof byte[] ? ((byte[])this.value).clone() : (this.value instanceof short[] ? ((short[])this.value).clone() : (this.value instanceof int[] ? ((int[])this.value).clone() : (this.value instanceof float[] ? ((float[])this.value).clone() : this.value)));
        return valueClone;
    }

    public SAMBinaryTagAndValue getNext() {
        return this.next;
    }

    public SAMBinaryTagAndValue insert(SAMBinaryTagAndValue attr) {
        if (attr == null) {
            return this;
        }
        if (attr.next != null) {
            throw new IllegalStateException("Can only insert single tag/value combinations.");
        }
        if (attr.tag < this.tag) {
            attr.next = this;
            return attr;
        }
        if (this.tag == attr.tag) {
            attr.next = this.next;
            return attr;
        }
        if (this.next == null) {
            this.next = attr;
            return this;
        }
        this.next = this.next.insert(attr);
        return this;
    }

    public SAMBinaryTagAndValue remove(short tag) {
        if (this.tag == tag) {
            return this.next;
        }
        if (this.next != null) {
            this.next = this.next.remove(tag);
        }
        return this;
    }

    public SAMBinaryTagAndValue find(short tag) {
        if (this.tag == tag) {
            return this;
        }
        if (this.tag > tag || this.next == null) {
            return null;
        }
        return this.next.find(tag);
    }

    public boolean isUnsignedArray() {
        return false;
    }
}

