/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.exception.HtsjdkException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleBuilder;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.beta.plugin.hapref.HaploidReferenceCodec;
import htsjdk.beta.plugin.hapref.HaploidReferenceDecoder;
import htsjdk.beta.plugin.hapref.HaploidReferenceDecoderOptions;
import htsjdk.beta.plugin.registry.HtsCodecResolver;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;

public class HaploidReferenceResolver
extends HtsCodecResolver<HaploidReferenceCodec> {
    public HaploidReferenceResolver() {
        super("HAPLOID_REFERENCE");
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(IOPath inputPath) {
        ValidationUtils.nonNull(inputPath, "inputPath");
        return this.getHaploidReferenceDecoder(inputPath, new HaploidReferenceDecoderOptions());
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(IOPath inputPath, HaploidReferenceDecoderOptions HaploidReferenceDecoderOptions2) {
        ValidationUtils.nonNull(inputPath, "Input path");
        ValidationUtils.nonNull(HaploidReferenceDecoderOptions2, "Decoder options");
        Bundle referenceBundle = HaploidReferenceResolver.referenceBundleFromFastaPath(inputPath, HtsPath::new);
        return this.getHaploidReferenceDecoder(referenceBundle, HaploidReferenceDecoderOptions2);
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(Bundle inputBundle) {
        ValidationUtils.nonNull(inputBundle, "inputPath");
        return this.getHaploidReferenceDecoder(inputBundle, new HaploidReferenceDecoderOptions());
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(Bundle inputBundle, HaploidReferenceDecoderOptions HaploidReferenceDecoderOptions2) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        ValidationUtils.nonNull(HaploidReferenceDecoderOptions2, "Decoder options");
        return (HaploidReferenceDecoder)((HaploidReferenceCodec)this.resolveForDecoding(inputBundle)).getDecoder(inputBundle, HaploidReferenceDecoderOptions2);
    }

    public static <T extends IOPath> Bundle referenceBundleFromFastaPath(IOPath fastaPath, Function<String, T> ioPathConstructor) {
        Path idxPath;
        BundleBuilder referenceBundleBuilder = new BundleBuilder();
        referenceBundleBuilder.addPrimary(new IOPathResource(fastaPath, "HAPLOID_REFERENCE"));
        Path dictPath = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(fastaPath.toPath());
        if (Files.exists(dictPath, new LinkOption[0])) {
            referenceBundleBuilder.addSecondary(new IOPathResource((IOPath)ioPathConstructor.apply(dictPath.toUri().toString()), "REFERENCE_DICTIONARY"));
        }
        if (Files.exists(idxPath = ReferenceSequenceFileFactory.getFastaIndexFileName(fastaPath.toPath()), new LinkOption[0])) {
            referenceBundleBuilder.addSecondary(new IOPathResource((IOPath)ioPathConstructor.apply(idxPath.toUri().toString()), "REFERENCE_INDEX"));
        }
        try {
            if (IOUtil.isBlockCompressed(fastaPath.toPath(), true)) {
                Path gziPath = GZIIndex.resolveIndexNameForBgzipFile(fastaPath.toPath());
                referenceBundleBuilder.addSecondary(new IOPathResource((IOPath)ioPathConstructor.apply(gziPath.toUri().toString()), "REFERENCE_INDEX_GZI"));
            }
        }
        catch (IOException e) {
            throw new HtsjdkException("Error while checking for block compression", e);
        }
        return referenceBundleBuilder.build();
    }
}

