/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.ReferenceFrame;

public class DataPanelPainter {
    private static Logger log = LogManager.getLogger(DataPanelPainter.class);

    public synchronized void paint(Collection<TrackGroup> groups, RenderContext context, Color background, Rectangle visibleRect) {
        Graphics2D graphics2D = context.getGraphics2D("BACKGROUND");
        graphics2D.setBackground(background);
        graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        graphics2D.setColor(Color.BLACK);
        ReferenceFrame referenceFrame = context.getReferenceFrame();
        InsertionMarker i = referenceFrame.getExpandedInsertion();
        if (i != null) {
            List<AlignmentTrack> tracks = IGV.getInstance().getAlignmentTracks();
            int maxVizWindow = tracks.size() == 0 ? 0 : tracks.stream().mapToInt(t -> t.getVisibilityWindow()).max().getAsInt();
            double start = referenceFrame.getOrigin();
            double frameExtent = referenceFrame.getEnd() - referenceFrame.getOrigin();
            double scale = referenceFrame.getScale();
            int insertionPixelPosition = (int)(((double)i.position - start) / scale);
            int insertionPixelWidth = (int)Math.ceil((double)i.size / context.getScale());
            if (frameExtent < (double)maxVizWindow && insertionPixelWidth > 1 && insertionPixelPosition < visibleRect.width && insertionPixelPosition + insertionPixelWidth > 0) {
                context.expandedInsertionPosition = i.position;
                if (insertionPixelPosition > 0) {
                    int width = insertionPixelPosition;
                    RenderContext leftContext = this.shiftRenderContext(context, context.getOrigin(), 0, width);
                    this.paintFrame(groups, leftContext);
                }
                RenderContext insertionContext = this.shiftRenderContext(context, i.position, insertionPixelPosition, insertionPixelWidth);
                this.paintExpandedInsertion(i, groups, insertionContext);
                int p0 = insertionPixelPosition + insertionPixelWidth;
                int w = visibleRect.width - p0;
                if (w > 0) {
                    RenderContext rightContext = this.shiftRenderContext(context, i.position, p0, w);
                    rightContext.multiframe = true;
                    this.paintFrame(groups, rightContext);
                }
            } else {
                this.paintFrame(groups, context);
            }
        } else {
            this.paintFrame(groups, context);
        }
    }

    private RenderContext shiftRenderContext(RenderContext ctx, double position, int translateX, int pixelWidth) {
        RenderContext newContext = new RenderContext(ctx);
        newContext.getReferenceFrame().widthInPixels = pixelWidth;
        newContext.getReferenceFrame().origin = position;
        newContext.visibleRect = new Rectangle(0, ctx.visibleRect.y, pixelWidth, ctx.visibleRect.height);
        newContext.translateX = translateX;
        Graphics2D dG = newContext.getGraphics();
        dG.translate(translateX, 0);
        dG.setClip(newContext.visibleRect);
        return newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintFrame(Collection<TrackGroup> groups, RenderContext dContext) {
        int trackX = 0;
        int trackY = 0;
        Rectangle dRect = dContext.visibleRect;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (dRect != null && trackY > dRect.y + dRect.height) break;
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                Graphics2D greyGraphics = dContext.getGraphic2DForColor(UIConstants.LIGHT_GREY);
                greyGraphics.fillRect(0, trackY + 1, dRect.width, 9);
                trackY += 10;
            }
            if (group.isDrawBorder()) {
                Graphics2D graphics2D = dContext.getGraphic2DForColor(Color.black);
                graphics2D.drawLine(0, trackY - 1, dRect.width, trackY - 1);
            }
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, dRect.width, trackHeight);
                    this.draw(track, rect, dContext);
                    trackY += trackHeight;
                }
            }
            if (!group.isDrawBorder()) continue;
            Graphics2D graphics2D = dContext.getGraphic2DForColor(Color.black);
            graphics2D.drawLine(0, trackY, dRect.width, trackY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintExpandedInsertion(InsertionMarker insertionMarker, Collection<TrackGroup> groups, RenderContext context) {
        int trackY = 0;
        Rectangle dRect = context.getVisibleRect();
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (!group.isVisible()) continue;
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (track instanceof AlignmentTrack && track.isVisible()) {
                        Rectangle rect = new Rectangle(dRect.x, trackY, dRect.width, trackHeight);
                        ((AlignmentTrack)track).renderExpandedInsertion(insertionMarker, context, rect);
                    }
                    if (!track.isVisible()) continue;
                    trackY += trackHeight;
                }
            }
        }
    }

    private final void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }
}

