/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broad.igv.DirectoryManager;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.download.Downloader;
import org.broad.igv.util.FileUtils;

public class GenomeDownloadUtils {
    private static Logger log = LogManager.getLogger(GenomeDownloadUtils.class);
    static Set<String> disallowedBuckets = new HashSet<String>(Arrays.asList("igv.org.genomes", "igv-genepattern-org", "igv.broadinstitute.org"));

    public static boolean isAnnotationsDownloadable(String path) {
        return path.endsWith(".json");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSequenceDownloadable(String path) {
        if (path == null) return false;
        if (!path.endsWith(".json")) return false;
        try {
            String jsonString = FileUtils.getContents(path);
            GenomeConfig genomeConfig = GenomeConfig.fromJson(jsonString);
            String sequenceURL = genomeConfig.getTwoBitURL();
            if (sequenceURL == null) {
                sequenceURL = genomeConfig.getFastaURL();
            }
            if (!GenomeDownloadUtils.isRemoteURL(sequenceURL)) return false;
            if (disallowedBuckets.stream().anyMatch(sequenceURL::contains)) return false;
            return true;
        }
        catch (IOException e) {
            log.error("Error fetching genome json " + path);
        }
        return false;
    }

    public static File downloadGenome(GenomeConfig c, boolean downloadSequence, boolean downloadAnnotations) throws IOException {
        GenomeConfig config = c.copy();
        File genomeDirectory = DirectoryManager.getGenomeCacheDirectory();
        File dataDirectory = new File(genomeDirectory, config.getId());
        if (dataDirectory.exists()) {
            if (!dataDirectory.isDirectory()) {
                throw new RuntimeException("Error downloading genome. " + dataDirectory.getAbsolutePath() + " exists and is not a directory.");
            }
        } else if (!dataDirectory.mkdir()) {
            throw new RuntimeException("Error downloading genome.  Could not create directory: " + dataDirectory.getAbsolutePath());
        }
        String relativeDataDirectory = config.getId() + "/";
        if (config.getTwoBitURL() != null) {
            URL url = new URL(config.getTwoBitURL());
            File localFile = downloadSequence ? GenomeDownloadUtils.download(url, dataDirectory) : GenomeDownloadUtils.constructLocalFile(url, dataDirectory);
            if (localFile.exists()) {
                config.setTwoBitURL(relativeDataDirectory + localFile.getName());
                config.setFastaURL(null);
                config.setIndexURL(null);
                config.setGziIndexURL(null);
                config.setTwoBitBptURL(null);
            }
        } else if (config.getFastaURL() != null) {
            String[] fastaFields = new String[]{"fastaURL", "indexURL", "gziIndexURL", "compressedIndexURL"};
            GenomeDownloadUtils.downloadAndUpdateConfig(downloadSequence, fastaFields, config, dataDirectory, relativeDataDirectory);
        } else {
            throw new RuntimeException("Sequence for genome " + config.getName() + " is not downloadable.");
        }
        String[] annotationFields = new String[]{"chromAliasBbURL", "cytobandURL", "cytobandBbURL", "aliasURL", "chromSizesURL"};
        GenomeDownloadUtils.downloadAndUpdateConfig(downloadAnnotations, annotationFields, config, dataDirectory, relativeDataDirectory);
        List<TrackConfig> trackConfigs = config.getTrackConfigs();
        if (trackConfigs != null) {
            String[] trackFields = new String[]{"url", "indexURL", "trixURL"};
            for (TrackConfig trackConfig : trackConfigs) {
                GenomeDownloadUtils.downloadAndUpdateConfig(downloadAnnotations, trackFields, trackConfig, dataDirectory, relativeDataDirectory);
            }
        }
        File localGenomeFile = new File(genomeDirectory, config.getId() + ".json");
        GenomeDownloadUtils.saveLocalGenome(config, localGenomeFile);
        return localGenomeFile;
    }

    private static void downloadAndUpdateConfig(boolean downloadData, String[] fields, Object config, File dataDirectory, String relativeDataDirectory) {
        for (String f : fields) {
            try {
                Field field = config.getClass().getDeclaredField(f);
                field.setAccessible(true);
                Object urlField = field.get(config);
                if (urlField == null) continue;
                URL url = new URL(urlField.toString());
                File localFile = downloadData ? GenomeDownloadUtils.download(url, dataDirectory) : GenomeDownloadUtils.constructLocalFile(url, dataDirectory);
                if (!localFile.exists()) continue;
                field.set(config, relativeDataDirectory + localFile.getName());
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private static void saveLocalGenome(GenomeConfig genomeConfig, File localFile) throws IOException {
        log.info("Saving " + localFile.getAbsolutePath());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(localFile));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)genomeConfig, (Appendable)writer);
        }
    }

    public static File constructLocalFile(URL url, File directory) {
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        String filename = idx < 0 ? path : path.substring(idx + 1);
        return new File(directory, filename);
    }

    private static File download(URL url, File directory) throws MalformedURLException {
        File localFile = GenomeDownloadUtils.constructLocalFile(url, directory);
        boolean success = Downloader.download(url, localFile, IGV.getInstance().getMainFrame());
        if (!success) {
            throw new RuntimeException("Download canceled");
        }
        return localFile;
    }

    private static boolean isRemoteURL(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

