/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.htsget;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.LineReader;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.htsget.HtsgetReader;
import org.broad.igv.htsget.HtsgetUtils;
import org.broad.igv.htsget.StringLineReader;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.variant.vcf.VCFVariant;

public class HtsgetVariantSource
implements FeatureSource {
    HtsgetReader htsgetReader;
    VCFCodec codec;
    VCFHeader header;
    Map<String, String> chrAliasMap;
    int featureWindowSize;
    Genome genome;

    public HtsgetVariantSource(HtsgetUtils.Metadata metadata, Genome genome) {
        this.htsgetReader = HtsgetReader.getReader(metadata);
        this.codec = new VCFCodec();
        this.featureWindowSize = 1000;
        this.chrAliasMap = new HashMap<String, String>();
        this.genome = genome;
        this.init(genome);
    }

    private void init(Genome genome) {
        List contigsLines;
        VCFHeader header = (VCFHeader)this.getHeader();
        if (genome != null && (contigsLines = header.getContigLines()) != null) {
            for (VCFContigHeaderLine l : contigsLines) {
                String vcfChr = l.getID();
                String genomeChr = genome.getCanonicalChrName(vcfChr);
                this.chrAliasMap.put(genomeChr, vcfChr);
            }
        }
    }

    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        String queryChr = this.chrAliasMap.containsKey(chr) ? this.chrAliasMap.get(chr) : chr;
        byte[] bytes = this.htsgetReader.readData(queryChr, start + 1, end);
        if (bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117) {
            BlockCompressedInputStream bis = new BlockCompressedInputStream((InputStream)new ByteArrayInputStream(bytes));
            bytes = bis.readAllBytes();
        }
        String data = new String(bytes);
        String[] lines = data.split("\\R");
        VCFWrapperCodec wrapperCodec = new VCFWrapperCodec((AsciiFeatureCodec)this.codec, this.genome);
        ArrayList<VCFVariant> features = new ArrayList<VCFVariant>();
        for (String line : lines) {
            try {
                VCFVariant f;
                if (line.startsWith("#") || (f = wrapperCodec.decode(line)).getEnd() < start) continue;
                if (f.getStart() > end) break;
                features.add(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return features.iterator();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public Object getHeader() {
        try {
            if (this.header == null) {
                byte[] bytes = this.htsgetReader.readHeader();
                if (bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117) {
                    BlockCompressedInputStream bis = new BlockCompressedInputStream((InputStream)new ByteArrayInputStream(bytes));
                    bytes = bis.readAllBytes();
                }
                String headerText = new String(bytes);
                LineIteratorImpl iter = new LineIteratorImpl((LineReader)new StringLineReader(headerText));
                this.header = (VCFHeader)this.codec.readActualHeader((LineIterator)iter);
                String formatLine = headerText.split("\\R")[0];
                VCFHeaderVersion version = VCFHeaderVersion.getHeaderVersion((String)formatLine);
                this.codec.setVCFHeader(this.header, version);
            }
            return this.header;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

