/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;

public class SbxUtils {
    public static final Color fullDiscordantInsertionColor = new Color(180, 180, 180);
    public static final Color discordantInsertionColor = new Color(140, 140, 140);
    public static final int DISCORDANT_BASE_QUALITY_MAX = 10;

    public static boolean isDiscordantInsertion(Alignment alignment, AlignmentBlock aBlock) {
        return aBlock != null && (SbxUtils.isDiscordantInsertion(aBlock) || SbxUtils.isDiscordantHpInsertion(alignment, aBlock) || SbxUtils.hasAdjacentDiscordantBase(alignment, aBlock));
    }

    public static boolean isFullDiscordantInsertion(AlignmentBlock aBlock) {
        if (aBlock == null) {
            return false;
        }
        for (int i = 0; i < aBlock.getLength(); ++i) {
            if (aBlock.getQuality(i) <= 10) continue;
            return false;
        }
        return true;
    }

    public static boolean isDiscordantInsertion(AlignmentBlock aBlock) {
        for (int i = 0; i < aBlock.getLength(); ++i) {
            if (aBlock.getQuality(i) > 10) continue;
            return true;
        }
        return false;
    }

    public static boolean isDiscordantHpInsertion(Alignment alignment, AlignmentBlock aBlock) {
        int position;
        byte base = aBlock.getBase(0);
        for (int i = 1; i < aBlock.getLength(); ++i) {
            byte nextBase = aBlock.getBase(i);
            if (nextBase == base) continue;
            return false;
        }
        for (position = aBlock.getStart() - 1; position >= 0 && alignment.getBase(position) == base; --position) {
        }
        ++position;
        while (position < alignment.getReadSequence().length() && alignment.getBase(position) == base) {
            if (alignment.getPhred(position) <= 10) {
                return true;
            }
            ++position;
        }
        return false;
    }

    public static boolean hasAdjacentDiscordantBase(Alignment alignment, AlignmentBlock aBlock) {
        int position = aBlock.getStart();
        if (alignment.getBase(position) != 0 && alignment.getPhred(position) <= 10) {
            return true;
        }
        return alignment.getBase(position - 1) != 0 && alignment.getPhred(position - 1) <= 10;
    }

    public static String qualityString(String rawQualString) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < rawQualString.length(); ++i) {
            if (i > 0) {
                res.append(",");
            }
            res.append((int)rawQualString.charAt(i));
        }
        return res.toString();
    }

    public static boolean isSBXAlignments(Set<Integer> qualityScores) {
        HashSet<Integer> expectedScores1 = new HashSet<Integer>(Arrays.asList(5, 22, 39));
        HashSet<Integer> expectedScores2 = new HashSet<Integer>(Arrays.asList(0, 18, 93));
        if (qualityScores.size() == 0 || qualityScores.size() == 1 && qualityScores.contains(0)) {
            return false;
        }
        HashSet<Integer> expectedSet = null;
        for (Integer score : qualityScores) {
            if (expectedSet == null) {
                if (expectedScores1.contains(score)) {
                    expectedSet = expectedScores1;
                    continue;
                }
                if (expectedScores2.contains(score)) {
                    expectedSet = expectedScores2;
                    continue;
                }
                return false;
            }
            if (expectedSet.contains(score)) continue;
            return false;
        }
        return true;
    }
}

