/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackNamePanel;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.SnapshotUtilities;

public class TrackPanelScrollPane
extends JideScrollPane
implements Paintable {
    private static Logger log = LogManager.getLogger(TrackPanelScrollPane.class);
    TrackPanel trackPanel;
    boolean isScrolling = false;

    public TrackPanelScrollPane() {
        this.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.setForeground(new Color(153, 153, 153));
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(16);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                TrackPanelScrollPane.this.trackPanel.getNamePanel().repaint();
            }
        });
        JScrollBar sb = this.getVerticalScrollBar();
        sb.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (TrackPanelScrollPane.this.isScrolling) {
                    if (!adjustmentEvent.getValueIsAdjusting()) {
                        TrackPanelScrollPane.this.isScrolling = false;
                        TrackPanelScrollPane.this.trackPanel.getNamePanel().repaint();
                    }
                } else {
                    TrackPanelScrollPane.this.isScrolling = adjustmentEvent.getValueIsAdjusting();
                }
            }
        });
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.trackPanel != null) {
            this.trackPanel.setBackground(color);
        }
    }

    public void setViewportView(Component trackSetView) {
        if (!(trackSetView instanceof TrackPanel)) {
            throw new IllegalArgumentException("Class TrackPanelScrollPane can only contain a TrackPanel");
        }
        super.setViewportView(trackSetView);
        this.trackPanel = (TrackPanel)trackSetView;
    }

    public TrackPanel getTrackPanel() {
        return this.trackPanel;
    }

    public String getTrackPanelName() {
        return this.trackPanel.getName();
    }

    public void minimizeHeight() {
        int prefHeight = this.trackPanel.getPreferredPanelHeight();
        if (prefHeight < this.trackPanel.getViewportHeight()) {
            this.setSize(this.getWidth(), prefHeight);
        }
    }

    public DataPanelContainer getDataPanel() {
        return this.trackPanel.getDataPanelContainer();
    }

    public boolean isEmpty() {
        return !this.trackPanel.hasTracks();
    }

    public TrackNamePanel getNamePanel() {
        return this.trackPanel.getNamePanel();
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle tspRect, boolean batch) {
        Graphics2D panelGraphics = (Graphics2D)g.create();
        int yOffset = this.getViewport().getViewPosition().y;
        panelGraphics.translate(0, -yOffset);
        Rectangle panelRect = this.getViewportBorderBounds();
        panelRect.y = yOffset;
        panelRect.height = tspRect.height;
        this.trackPanel.paintOffscreen(panelGraphics, panelRect, batch);
        panelGraphics.dispose();
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        if (this.trackPanel.getTracks().size() == 0) {
            return 0;
        }
        if (batch) {
            int panelHeight;
            int maxPanelHeight = SnapshotUtilities.getMaxPanelHeight();
            int scrollPaneHeight = this.getHeight();
            if (maxPanelHeight <= 0) {
                panelHeight = scrollPaneHeight;
            } else {
                int contentHeight = this.trackPanel.getPreferredPanelHeight();
                panelHeight = Math.min(maxPanelHeight, Math.max(scrollPaneHeight, contentHeight));
            }
            return panelHeight;
        }
        return this.getHeight();
    }
}

