/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.SortDialog;
import org.broad.igv.ui.util.UIUtilities;

public class SortTracksMenuAction
extends MenuAction {
    IGV mainFrame;

    public SortTracksMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                SortTracksMenuAction.this.doSortTrackByAttribute();
            }
        });
    }

    public final void doSortTrackByAttribute() {
        List<String> keys = AttributeManager.getInstance().getAttributeNames();
        Object[] availableSortKeys = keys.toArray();
        SortDialog dialog = new SortDialog(this.mainFrame.getMainFrame(), true, availableSortKeys);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        String[] selectedSortKeys = dialog.getSelectedSortKeys();
        if (selectedSortKeys != null) {
            IGV.getInstance().sortAllTracksByAttributes(selectedSortKeys, dialog.isAscending());
            this.mainFrame.getMainFrame().repaint();
        }
    }
}

