/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.twobit;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class UnsignedByteBufferImpl
implements UnsignedByteBuffer {
    ByteBuffer wrappedBuffer;

    public static UnsignedByteBufferImpl loadBinaryBuffer(String path, ByteOrder byteOrder, long start, int size) throws IOException {
        try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(path);){
            ByteBuffer bb = ByteBuffer.allocate(size);
            bb.order(byteOrder);
            byte[] bytes = bb.array();
            is.seek(start);
            is.readFully(bytes);
            UnsignedByteBufferImpl unsignedByteBufferImpl = new UnsignedByteBufferImpl(bb);
            return unsignedByteBufferImpl;
        }
    }

    public static UnsignedByteBufferImpl wrap(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(byteOrder);
        return new UnsignedByteBufferImpl(bb);
    }

    public static UnsignedByteBuffer wrap(byte[] bytes) {
        return UnsignedByteBufferImpl.wrap(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    private UnsignedByteBufferImpl(ByteBuffer wrappedBuffer) {
        this.wrappedBuffer = wrappedBuffer;
    }

    @Override
    public byte get() {
        return this.wrappedBuffer.get();
    }

    @Override
    public short getShort() {
        return this.wrappedBuffer.getShort();
    }

    @Override
    public int getUShort() {
        return Short.toUnsignedInt(this.wrappedBuffer.getShort());
    }

    @Override
    public int getInt() {
        return this.wrappedBuffer.getInt();
    }

    @Override
    public long getUInt() {
        return Integer.toUnsignedLong(this.wrappedBuffer.getInt());
    }

    @Override
    public long getLong() {
        return this.wrappedBuffer.getLong();
    }

    @Override
    public float getFloat() {
        return this.wrappedBuffer.getFloat();
    }

    @Override
    public double getDouble() {
        return this.wrappedBuffer.getDouble();
    }

    @Override
    public String getString() {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(1000);
        while ((b = this.wrappedBuffer.get()) != 0) {
            bis.write(b);
        }
        return new String(bis.toByteArray());
    }

    @Override
    public String getFixedLengthString(int length) {
        byte[] bytes = new byte[length];
        int nonPaddedLength = 0;
        this.wrappedBuffer.get(bytes);
        for (int i = 0; i < length && bytes[i] != 0; ++i) {
            ++nonPaddedLength;
        }
        return new String(bytes, 0, nonPaddedLength);
    }

    @Override
    public int position() {
        return this.wrappedBuffer.position();
    }

    @Override
    public void position(int i) {
        this.wrappedBuffer.position(i);
    }

    public byte[] array() {
        return this.wrappedBuffer.array();
    }

    @Override
    public int remaining() {
        return this.wrappedBuffer.remaining();
    }
}

