/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;

public class BBTotalSummary {
    public long basesCovered;
    public double minVal;
    public double maxVal;
    public double sumData;
    public double sumSquares;
    public double mean;

    static BBTotalSummary parseSummary(UnsignedByteBuffer buffer) {
        BBTotalSummary totalSummary = new BBTotalSummary();
        totalSummary.basesCovered = buffer.getLong();
        totalSummary.minVal = buffer.getDouble();
        totalSummary.maxVal = buffer.getDouble();
        totalSummary.sumData = buffer.getDouble();
        totalSummary.sumSquares = buffer.getDouble();
        totalSummary.mean = totalSummary.basesCovered > 0L ? totalSummary.sumData / (double)totalSummary.basesCovered : 0.0;
        return totalSummary;
    }

    public String printString() {
        return "basesCovered " + this.basesCovered + "\nminVal " + this.minVal + "\nmaxVal " + this.maxVal + "\nsumData " + this.sumData + "\nsumSquares " + this.sumSquares + "\nmean " + this.mean + "\n";
    }
}

