/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModficationFilter;
import org.broad.igv.sam.mods.BaseModificationColors;
import org.broad.igv.sam.mods.BaseModificationSet;

public class BaseModificationRenderer {
    public static void drawModifications(Alignment alignment, double bpStart, double locScale, Rectangle rowRect, Graphics g, AlignmentTrack.RenderOptions renderOptions) {
        List<BaseModificationSet> baseModificationSets = alignment.getBaseModificationSets();
        if (baseModificationSets != null) {
            for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                BaseModificationRenderer.drawBlock(bpStart, locScale, rowRect, g, renderOptions, baseModificationSets, block);
            }
        }
    }

    public static void drawBlock(double bpStart, double locScale, Rectangle rowRect, Graphics g, AlignmentTrack.RenderOptions renderOptions, List<BaseModificationSet> baseModificationSets, AlignmentBlock block) {
        if (baseModificationSets == null) {
            return;
        }
        AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
        BaseModficationFilter filter = renderOptions.getBasemodFilter();
        float threshold = renderOptions.getBasemodThreshold();
        int pY = (int)rowRect.getY();
        int dY = (int)rowRect.getHeight();
        int dX = (int)Math.max(1.0, 1.0 / locScale);
        for (int i = block.getBases().startOffset; i < block.getBases().startOffset + block.getBases().length; ++i) {
            int blockIdx = i - block.getBases().startOffset;
            int pX = (int)(((double)(block.getStart() + blockIdx) - bpStart) / locScale);
            if ((double)pX > rowRect.getMaxX()) break;
            if ((double)(pX + dX) < rowRect.getX()) continue;
            int maxLh = 0;
            int noModLh = 255;
            String modification = null;
            char canonicalBase = '\u0000';
            for (BaseModificationSet bmSet : baseModificationSets) {
                if (!bmSet.containsPosition(i)) continue;
                int lh = Byte.toUnsignedInt(bmSet.getLikelihoods().get(i));
                noModLh -= lh;
                if (filter != null && !filter.pass(bmSet.getModification(), canonicalBase) || modification != null && lh <= maxLh) continue;
                modification = bmSet.getModification();
                canonicalBase = bmSet.getCanonicalBase();
                maxLh = lh;
            }
            if (modification == null) continue;
            Color c = null;
            float scaledThreshold = threshold * 255.0f;
            if (noModLh > maxLh && colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR && (float)noModLh >= scaledThreshold) {
                c = BaseModificationColors.getModColor("NONE_" + canonicalBase, noModLh, colorOption);
            } else if ((float)maxLh >= scaledThreshold) {
                c = BaseModificationColors.getModColor(modification, maxLh, colorOption);
            }
            if (c == null) continue;
            g.setColor(c);
            if (dX < 3) {
                dX = 3;
                --pX;
            }
            g.fillRect(pX, pY, dX, Math.max(1, dY - 2));
        }
    }
}

