/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.mods.BaseModificationKey;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.sam.mods.BaseModificationUtils;
import org.broad.igv.util.collections.ByteArrayList;

public class BaseModificationCounts {
    LinkedHashSet<BaseModificationKey> allModifications = new LinkedHashSet();
    Map<BaseModificationKey, Map<Integer, ByteArrayList>> maxLikelihoods = new HashMap<BaseModificationKey, Map<Integer, ByteArrayList>>();
    Map<BaseModificationKey, Map<Integer, ByteArrayList>> nomodLikelihoods = new HashMap<BaseModificationKey, Map<Integer, ByteArrayList>>();
    transient float lastThreshold;

    public void incrementCounts(Alignment alignment) {
        if (alignment.getAlignmentBlocks() == null) {
            return;
        }
        List<BaseModificationSet> baseModificationSets = alignment.getBaseModificationSets();
        if (baseModificationSets != null) {
            for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                if (block.isSoftClip()) continue;
                for (int blockIdx = 0; blockIdx < block.getBases().length; ++blockIdx) {
                    int readIdx = block.getBases().startOffset + blockIdx;
                    int position = block.getStart() + blockIdx;
                    char canonicalBase = '\u0000';
                    int maxLH = -1;
                    BaseModificationKey maxKey = null;
                    int noModLH = 255;
                    for (BaseModificationSet bmSet : baseModificationSets) {
                        Map<Integer, Byte> bmSetLikelihoods = bmSet.getLikelihoods();
                        if (bmSetLikelihoods == null || !bmSet.containsPosition(readIdx)) continue;
                        byte byteLikelihood = bmSetLikelihoods.get(readIdx);
                        BaseModificationKey modKey = BaseModificationKey.getKey(bmSet.getBase(), bmSet.getStrand(), bmSet.getModification());
                        this.allModifications.add(modKey);
                        int lh = Byte.toUnsignedInt(byteLikelihood);
                        noModLH -= lh;
                        if (lh <= maxLH) continue;
                        canonicalBase = bmSet.getCanonicalBase();
                        maxLH = lh;
                        maxKey = modKey;
                    }
                    if (canonicalBase == '\u0000') continue;
                    BaseModificationKey noModKey = BaseModificationKey.getKey(canonicalBase, '+', "NONE_" + canonicalBase);
                    this.allModifications.add(noModKey);
                    this.pushLikelihood(position, (byte)maxLH, maxKey, this.maxLikelihoods);
                    if (noModLH > maxLH) {
                        this.pushLikelihood(position, (byte)noModLH, noModKey, this.nomodLikelihoods);
                        continue;
                    }
                    this.pushLikelihood(position, (byte)maxLH, maxKey, this.nomodLikelihoods);
                }
            }
        }
    }

    private void pushLikelihood(int position, byte byteLikelihood, BaseModificationKey modKey, Map<BaseModificationKey, Map<Integer, ByteArrayList>> likelihoods) {
        ByteArrayList byteArrayList;
        Map<Integer, ByteArrayList> t = likelihoods.get(modKey);
        if (t == null) {
            t = new HashMap<Integer, ByteArrayList>();
            likelihoods.put(modKey, t);
        }
        if ((byteArrayList = t.get(position)) == null) {
            byteArrayList = new ByteArrayList(100);
            t.put(position, byteArrayList);
        }
        byteArrayList.add(byteLikelihood);
    }

    public int getCount(int position, BaseModificationKey key, float threshold, boolean includeNoMods) {
        Map<Integer, ByteArrayList> t;
        this.lastThreshold = threshold;
        float scaledThreshold = threshold * 255.0f;
        Map<Integer, ByteArrayList> map = t = includeNoMods ? this.nomodLikelihoods.get(key) : this.maxLikelihoods.get(key);
        if (t == null) {
            return 0;
        }
        ByteArrayList byteArrayList = t.get(position);
        if (byteArrayList == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < byteArrayList.size(); ++i) {
            int lh = Byte.toUnsignedInt(byteArrayList.get(i));
            if (!((float)lh >= scaledThreshold)) continue;
            ++count;
        }
        return count;
    }

    public int getLikelihoodSum(int position, BaseModificationKey key, float threshold, boolean includeNoMods) {
        this.lastThreshold = threshold;
        float scaledThreshold = threshold * 255.0f;
        Map<Integer, ByteArrayList> t = includeNoMods ? this.nomodLikelihoods.get(key) : this.maxLikelihoods.get(key);
        ByteArrayList byteArrayList = t.get(position);
        if (byteArrayList == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < byteArrayList.size(); ++i) {
            int lh = Byte.toUnsignedInt(byteArrayList.get(i));
            if (!((float)lh >= scaledThreshold)) continue;
            count += lh;
        }
        return count;
    }

    public Set<BaseModificationKey> getAllModificationKeys() {
        return this.allModifications;
    }

    public String getValueString(int position, AlignmentTrack.ColorOption colorOption) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer nomodBuffer = new StringBuffer();
        buffer.append("<br>---------<br>");
        buffer.append("Modifications with likelihood > " + this.lastThreshold * 100.0f + "%");
        boolean includeNomods = colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR;
        Map<BaseModificationKey, Map<Integer, ByteArrayList>> l = includeNomods ? this.nomodLikelihoods : this.maxLikelihoods;
        for (BaseModificationKey key : l.keySet()) {
            int count;
            Map<Integer, ByteArrayList> t = l.get(key);
            if (!t.containsKey(position) || (count = this.getCount(position, key, this.lastThreshold, includeNomods)) <= 0) continue;
            int likelihoodSum = this.getLikelihoodSum(position, key, this.lastThreshold, includeNomods);
            int averageLikelihood = (int)((double)likelihoodSum / (double)count * 0.3921568);
            String modName = BaseModificationUtils.modificationName(key.modification);
            if (key.modification.startsWith("NONE_")) {
                nomodBuffer.append("<br>&nbsp;&nbsp;" + modName + ": " + count + "  @ average likelihood " + averageLikelihood + "%");
                continue;
            }
            buffer.append("<br>&nbsp;&nbsp;" + modName + " (" + key.base + key.strand + "): " + count + "  @ average likelihood " + averageLikelihood + "%");
        }
        buffer.append(nomodBuffer.toString());
        return buffer.toString();
    }
}

