/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ClippingCounts;
import org.broad.igv.sam.SAMAlignment;

public class SupplementaryAlignment
implements Locatable {
    private static final Logger log = LogManager.getLogger(SupplementaryAlignment.class);
    private static int MAX_ERROR_COUNT = 10;
    private static int errorCount = 0;
    public final String chr;
    public final int start;
    private final Strand strand;
    private final Cigar cigar;
    public final int mapQ;
    public final int numMismatches;
    private Integer lenOnRef = null;
    private Integer numberOfAlignedBases = null;
    public static final Comparator<SupplementaryAlignment> LEADING_CLIP_COMPARATOR = Comparator.comparingInt(SupplementaryAlignment::getCountOfLeadingClipping);

    public SupplementaryAlignment(String chr, int start, Strand strand, Cigar cigar, int mapQ, int numMismatches) {
        this.chr = chr;
        this.start = start;
        this.strand = strand;
        this.cigar = cigar;
        this.mapQ = mapQ;
        this.numMismatches = numMismatches;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public static int getInsertionIndex(Alignment alignment, List<SupplementaryAlignment> supplementaryAlignments) {
        SupplementaryAlignment alignmentAsSupplementary = new SupplementaryAlignment(null, 0, alignment.getReadStrand(), alignment.getCigar(), 0, 0);
        int insertionIndex = Collections.binarySearch(supplementaryAlignments, alignmentAsSupplementary, LEADING_CLIP_COMPARATOR);
        if (insertionIndex > 0) {
            log.warn("Saw 2 SupplementaryReads with the same leading clip length.");
        } else {
            insertionIndex = -1 * (insertionIndex + 1);
        }
        return insertionIndex;
    }

    public static SupplementaryNeighbors getAdjacentSupplementaryReads(Alignment alignment) {
        try {
            ArrayList<SupplementaryAlignment> supplementaryAlignments;
            if (alignment instanceof SAMAlignment) {
                supplementaryAlignments = ((SAMAlignment)alignment).getSupplementaryAlignments();
            } else {
                Object rawSATag = alignment.getAttribute(SAMTag.SA.name());
                ArrayList<SupplementaryAlignment> arrayList = supplementaryAlignments = rawSATag == null ? null : new ArrayList<SupplementaryAlignment>(SupplementaryAlignment.parseFromSATag(rawSATag.toString()));
            }
            if (supplementaryAlignments != null && !supplementaryAlignments.isEmpty()) {
                int insertionIndex = SupplementaryAlignment.getInsertionIndex(alignment, (List<SupplementaryAlignment>)supplementaryAlignments);
                if (insertionIndex < 0) {
                    log.warn("Encountered a group of supplementary alignments that couldn't be sorted unambiguously.\nSee reads with the name: " + alignment.getReadName());
                    return null;
                }
                boolean firstInRead = insertionIndex == 0;
                boolean lastInRead = insertionIndex == supplementaryAlignments.size();
                SupplementaryNeighbors supplementaryRenderingInfo = new SupplementaryNeighbors(alignment, firstInRead ? null : (SupplementaryAlignment)supplementaryAlignments.get(insertionIndex - 1), lastInRead ? null : (SupplementaryAlignment)supplementaryAlignments.get(insertionIndex));
                return supplementaryRenderingInfo;
            }
            return null;
        }
        catch (Exception e) {
            if (++errorCount <= MAX_ERROR_COUNT) {
                log.error("Error parsing supplementary alignments. ", e);
                if (errorCount == MAX_ERROR_COUNT) {
                    log.error("Maximum error count exceeded.  Further errors parsing supplementary alignments will not be logged.");
                }
            }
            return null;
        }
    }

    public String printString() {
        return this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.start + 1) + "-" + Globals.DECIMAL_FORMAT.format(this.start + this.getLengthOnReference()) + " (" + this.strand.toShortString() + ") = " + Globals.DECIMAL_FORMAT.format(this.getLengthOnReference()) + "bp  @MAPQ " + this.mapQ + " NM" + this.numMismatches;
    }

    public static List<SupplementaryAlignment> parseFromSATag(String saTag) {
        return Arrays.stream(Globals.semicolonPattern.split(saTag)).map(SupplementaryAlignment::fromSingleSaTagRecord).sorted(LEADING_CLIP_COMPARATOR).toList();
    }

    public static SupplementaryAlignment fromSingleSaTagRecord(String saTagRecord) {
        String[] tokens = Globals.commaPattern.split(saTagRecord);
        String chr = tokens[0];
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        chr = genome == null ? chr : genome.getCanonicalChrName(chr);
        int start = Integer.parseInt(tokens[1]) - 1;
        Strand strand = Strand.fromString(tokens[2]);
        Cigar cigar = TextCigarCodec.decode((String)tokens[3]);
        int mapQ = Integer.parseInt(tokens[4]);
        int numMismatches = Integer.parseInt(tokens[5]);
        return new SupplementaryAlignment(chr, start, strand, cigar, mapQ, numMismatches);
    }

    public int getCountOfLeadingClipping() {
        ClippingCounts counts = ClippingCounts.fromCigar(this.cigar);
        return SupplementaryAlignment.getCountOfLeadingClipping(counts, this.strand);
    }

    public static int getCountOfLeadingClipping(ClippingCounts counts, Strand strand) {
        return switch (strand) {
            default -> throw new MatchException(null, null);
            case Strand.NONE, Strand.POSITIVE -> counts.getLeft();
            case Strand.NEGATIVE -> counts.getRight();
        };
    }

    public String getContig() {
        return this.chr;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.getLengthOnReference();
    }

    public int getLengthOnReference() {
        if (this.lenOnRef == null) {
            this.lenOnRef = this.cigar.getReferenceLength();
        }
        return this.cigar.getReferenceLength();
    }

    public int getNumberOfAlignedBases() {
        if (this.numberOfAlignedBases == null) {
            int length = 0;
            for (CigarElement element : this.cigar) {
                switch (element.getOperator()) {
                    case M: 
                    case I: 
                    case EQ: 
                    case X: {
                        length += element.getLength();
                        break;
                    }
                }
            }
            this.numberOfAlignedBases = length;
        }
        return this.numberOfAlignedBases;
    }

    record SupplementaryNeighbors(Alignment alignment, SupplementaryAlignment previous, SupplementaryAlignment next) {
        SupplementaryNeighbors(Alignment alignment, SupplementaryAlignment previous, SupplementaryAlignment next) {
            this.alignment = alignment;
            if (alignment.isNegativeStrand()) {
                this.next = previous;
                this.previous = next;
            } else {
                this.next = next;
                this.previous = previous;
            }
        }
    }
}

