/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.SequenceUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentBlockImpl;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.ByteSubarray;
import org.broad.igv.sam.ClippingCounts;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SbxUtils;
import org.broad.igv.sam.SpliceGap;
import org.broad.igv.sam.SupplementaryAlignment;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.sam.mods.BaseModificationUtils;
import org.broad.igv.sam.smrt.SMRTKinetics;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ultima.FlowUtil;
import org.broad.igv.ultima.annotate.FlowBlockAnnotator;

public class SAMAlignment
implements Alignment {
    public static final int MAX_CIGAR_STRING_LENGTH_TO_DISPLAY = 50;
    public static final Pattern RIGHT_CIGAR_PATTERN = Pattern.compile("[A-Z](.{1,25})$");
    public static final Pattern LEFT_CIGAR_PATTERN = Pattern.compile("^(.{1,24}[A-Z])");
    private static final Logger log = LogManager.getLogger(SAMAlignment.class);
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    public static final char UNKNOWN = '\u0000';
    public static final String REDUCE_READS_TAG = "RR";
    public static final int SBX_LOW_BASEQ_TAIL_THRESHOLD = 30;
    private static final int READ_PAIRED_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int READ_UNMAPPED_FLAG = 4;
    private static final int MATE_UNMAPPED_FLAG = 8;
    private static final int READ_STRAND_FLAG = 16;
    protected static final int MATE_STRAND_FLAG = 32;
    private static final int FIRST_OF_PAIR_FLAG = 64;
    private static final int SECOND_OF_PAIR_FLAG = 128;
    private static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    private static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    private static final int DUPLICATE_READ_FLAG = 1024;
    private static final int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    private SAMAlignment sbxTrimmed;
    private SAMReadGroupRecord readGroupRecord;
    private int flags;
    private static final FlowBlockAnnotator flowBlockAnnotator = new FlowBlockAnnotator();
    private SAMRecord record;
    String chr;
    protected int start;
    protected int end;
    protected Color ycColor = null;
    ReadMate mate;
    public AlignmentBlockImpl[] alignmentBlocks;
    public AlignmentBlockImpl[] insertions;
    List<Gap> gaps;
    char[] gapTypes;
    protected String mateSequence = null;
    protected String pairOrientation = "";
    private Strand firstOfPairStrand;
    private Strand secondOfPairStrand;
    private List<BaseModificationSet> baseModificationSets;
    private SMRTKinetics smrtKinetics;
    String haplotypeName;
    int hapDistance;

    private <T> T getCachedOrCompute(CacheKey key, Supplier<T> supplier) {
        Object value = this.record.getTransientAttribute((Object)key);
        if (value == null) {
            T newValue = supplier.get();
            this.record.setTransientAttribute((Object)key, newValue);
            return newValue;
        }
        return (T)value;
    }

    public SAMAlignment(SAMRecord record) {
        Object colorTag;
        String readGroup;
        SAMFileHeader header;
        this.record = record;
        this.flags = record.getFlags();
        String refName = record.getReferenceName();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getCanonicalChrName(refName);
        this.end = record.getAlignmentEnd();
        this.start = record.getAlignmentStart() - 1;
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getCanonicalChrName(mateReferenceName);
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart() - 1, record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
        }
        if ((header = record.getHeader()) != null && (readGroup = (String)record.getAttribute("RG")) != null) {
            this.readGroupRecord = header.getReadGroup(readGroup);
        }
        if ((colorTag = record.getAttribute("YC")) != null) {
            try {
                this.ycColor = ColorUtilities.stringToColor(colorTag.toString(), null);
            }
            catch (Exception e) {
                log.error("Error interpreting color tag: " + String.valueOf(colorTag), e);
            }
        }
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks();
    }

    private SAMAlignment(SAMRecord record, boolean skipBlocks) {
        Object colorTag;
        String readGroup;
        SAMFileHeader header;
        this.record = record;
        this.flags = record.getFlags();
        String refName = record.getReferenceName();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getCanonicalChrName(refName);
        this.end = record.getAlignmentEnd();
        this.start = record.getAlignmentStart() - 1;
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getCanonicalChrName(mateReferenceName);
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart() - 1, record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
        }
        if ((header = record.getHeader()) != null && (readGroup = (String)record.getAttribute("RG")) != null) {
            this.readGroupRecord = header.getReadGroup(readGroup);
        }
        if ((colorTag = record.getAttribute("YC")) != null) {
            try {
                this.ycColor = ColorUtilities.stringToColor(colorTag.toString(), null);
            }
            catch (Exception e) {
                log.error("Error interpreting color tag: " + String.valueOf(colorTag), e);
            }
        }
        this.setPairOrientation();
        this.setPairStrands();
        if (!skipBlocks) {
            this.createAlignmentBlocks();
        }
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    public String getContig() {
        return this.chr;
    }

    public String getDescription() {
        return this.getReadName();
    }

    @Override
    public ReadMate getMate() {
        return this.mate;
    }

    @Override
    public Color getYcColor() {
        return this.ycColor;
    }

    @Override
    public Object getAttribute(String key) {
        if (key == null) {
            return null;
        }
        return key.length() == 2 ? this.record.getAttribute(key) : (key.equals("TEMPLATE_ORIENTATION") ? this.pairOrientation : null);
    }

    public List<SAMRecord.SAMTagAndValue> getAttributes() {
        return this.record.getAttributes();
    }

    private Object getAttribute(SAMTag key) {
        return key == null ? null : this.record.getAttribute(key);
    }

    @Override
    public boolean isFirstOfPair() {
        return this.isPaired() && (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.isPaired() && (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isDuplicate() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isMapped() {
        return (this.flags & 4) == 0;
    }

    @Override
    public boolean isPaired() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isProperPair() {
        return (this.flags & 1) != 0 && (this.flags & 2) != 0;
    }

    @Override
    public boolean isNegativeStrand() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isSupplementary() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isVendorFailedRead() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & 0x100) == 0;
    }

    public String toString() {
        return this.record.getSAMString();
    }

    @Override
    public String getReadName() {
        return this.record.getReadName();
    }

    @Override
    public int getMappingQuality() {
        return this.record.getMappingQuality();
    }

    @Override
    public int getInferredInsertSize() {
        return this.record.getInferredInsertSize();
    }

    @Override
    public String getCigarString() {
        return this.record.getCigarString();
    }

    @Override
    public Cigar getCigar() {
        return this.record.getCigar();
    }

    @Override
    public ClippingCounts getClippingCounts() {
        return this.getCachedOrCompute(CacheKey.CLIPPING_COUNTS, () -> ClippingCounts.fromCigar(this.record.getCigar()));
    }

    @Override
    public String getReadSequence() {
        return this.record.getReadString();
    }

    @Override
    public int getAlignmentStart() {
        return this.record.getAlignmentStart() - 1;
    }

    @Override
    public int getAlignmentEnd() {
        return this.record.getAlignmentEnd();
    }

    public String getReadLengthString() {
        CigarElement last;
        Cigar cigar = this.getCigar();
        int readSequenceLength = cigar.getReadLength();
        int clippedLength = 0;
        CigarElement first = cigar.getFirstCigarElement();
        if (first.getOperator() == htsjdk.samtools.CigarOperator.H) {
            clippedLength += first.getLength();
        }
        if ((last = cigar.getLastCigarElement()).getOperator() == htsjdk.samtools.CigarOperator.H) {
            clippedLength += last.getLength();
        }
        String readLengthString = Globals.DECIMAL_FORMAT.format(readSequenceLength + clippedLength) + " bp";
        if (clippedLength > 0) {
            readLengthString = readLengthString + " (" + Globals.DECIMAL_FORMAT.format(readSequenceLength) + " sequence + " + Globals.DECIMAL_FORMAT.format(clippedLength) + " hard clipped)";
        }
        return readLengthString;
    }

    @Override
    public String getSample() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getSample();
    }

    @Override
    public String getReadGroup() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getId();
    }

    @Override
    public String getLibrary() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getLibrary();
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.alignmentBlocks;
    }

    public AlignmentBlockImpl[] getInsertions() {
        return this.insertions;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public byte getBase(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            return base;
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        int basePosition = (int)position;
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte qual = block.getQuality(offset);
            return qual;
        }
        return 0;
    }

    @Override
    public List<BaseModificationSet> getBaseModificationSets() {
        if (this.baseModificationSets == null && this.record.hasAttribute("Mm") || this.record.hasAttribute("MM")) {
            Object mm = this.record.hasAttribute("Mm") ? this.record.getAttribute("Mm") : this.record.getAttribute("MM");
            byte[] ml = (byte[])(this.record.hasAttribute("Ml") ? this.record.getAttribute("Ml") : this.record.getAttribute("ML"));
            if (mm instanceof String && mm.toString().length() > 0 && (ml == null || ml instanceof byte[])) {
                byte[] sequence = this.record.getReadBases();
                Integer mn = this.record.getIntegerAttribute("MN");
                if (mn == null) {
                    mn = sequence.length;
                }
                if (mn != null ? mn != sequence.length : !BaseModificationUtils.validateMMTag(this.getReadName(), mm.toString(), this.record.getReadBases(), this.isNegativeStrand())) {
                    return null;
                }
                this.baseModificationSets = mm.toString().length() == 0 ? Collections.EMPTY_LIST : BaseModificationUtils.getBaseModificationSets((String)mm, ml, sequence, this.isNegativeStrand());
            }
        }
        return this.baseModificationSets;
    }

    @Override
    public SAMAlignment trimSimplexTails() {
        int end;
        int start;
        if (this.sbxTrimmed != null) {
            return this.sbxTrimmed;
        }
        SAMAlignment res = new SAMAlignment(this.record.deepCopy(), true);
        String cigarString = this.record.getCigarString();
        byte[] readBases = this.record.getReadBases();
        byte[] readBaseQualities = this.record.getBaseQualities();
        for (start = 0; start < readBases.length && readBaseQualities[start] <= 30; ++start) {
        }
        for (end = readBases.length - 1; end >= 0 && readBaseQualities[end] <= 30; --end) {
        }
        if (start == 0 && end == readBases.length - 1) {
            res.createAlignmentBlocks();
            this.sbxTrimmed = res;
            return res;
        }
        if (start > end) {
            res.record.setReadBases(new byte[0]);
            res.record.setBaseQualities(new byte[0]);
            res.record.setCigarString("");
            res.end = res.start;
            res.createAlignmentBlocks();
            this.sbxTrimmed = res;
            return res;
        }
        byte[] newReadBases = new byte[end - start + 1];
        byte[] newBaseQuals = new byte[end - start + 1];
        for (int i = 0; i < newReadBases.length; ++i) {
            newReadBases[i] = readBases[start + i];
            newBaseQuals[i] = readBaseQualities[start + i];
        }
        List<CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
        res.record.setReadBases(newReadBases);
        res.record.setBaseQualities(newBaseQuals);
        StringBuilder newCigarString = new StringBuilder();
        int readStart = 0;
        for (CigarOperator op : operators) {
            int truncatedRight;
            boolean consumesRef;
            int curStart;
            int length = op.nBases;
            char type = op.operator;
            int curEnd = curStart = readStart;
            boolean consumesQuery = type == 'I' || type == 'X' || type == 'M' || type == '=' || type == 'S';
            boolean bl = consumesRef = type == 'D' || type == 'X' || type == 'M' || type == '=' || type == 'N';
            if (consumesQuery) {
                curEnd += op.nBases;
            }
            if (curEnd <= start || curStart > end) {
                readStart = curEnd;
                if (!consumesRef) continue;
                if (curEnd <= start) {
                    res.setStart(res.getStart() + length);
                    continue;
                }
                res.setEnd(res.getEnd() - length);
                continue;
            }
            int truncatedLeft = Math.max(0, start - curStart);
            int newLength = length - truncatedLeft - (truncatedRight = Math.max(0, curEnd - (end + 1)));
            if (newLength > 0) {
                newCigarString.append(newLength);
                newCigarString.append(type);
            }
            if (consumesRef) {
                res.setStart(res.getStart() + truncatedLeft);
                res.setEnd(res.getEnd() - truncatedRight);
            }
            readStart = curEnd;
        }
        res.record.setCigarString(newCigarString.toString());
        res.record.setAlignmentStart(1 + res.getStart());
        res.createAlignmentBlocks();
        this.sbxTrimmed = res;
        return res;
    }

    @Override
    public SMRTKinetics getSmrtKinetics() {
        if (this.smrtKinetics == null) {
            this.smrtKinetics = new SMRTKinetics(this);
        }
        return this.smrtKinetics;
    }

    private void setPairStrands() {
        if (this.isPaired()) {
            ReadMate mate;
            this.firstOfPairStrand = this.isFirstOfPair() ? this.getReadStrand() : ((mate = this.getMate()) != null && mate.isMapped() ? mate.getStrand() : Strand.NONE);
            this.secondOfPairStrand = this.isSecondOfPair() ? (this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : ((mate = this.getMate()) != null && mate.isMapped() && this.isProperPair() ? (mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : Strand.NONE);
        } else {
            this.firstOfPairStrand = this.getReadStrand();
            this.secondOfPairStrand = Strand.NONE;
        }
    }

    @Override
    public int getLeadingHardClipLength() {
        int clipLength = 0;
        String cigarString = this.record.getCigarString();
        if (!cigarString.equals("*")) {
            List<CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
            for (CigarOperator operator : operators) {
                if (operator.operator != 'H') break;
                clipLength += operator.nBases;
            }
        }
        return clipLength;
    }

    private void createAlignmentBlocks() {
        this.gaps = null;
        String cigarString = this.record.getCigarString();
        byte[] readBases = this.record.getReadBases();
        byte[] readBaseQualities = this.record.getBaseQualities();
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlockImpl[1];
            this.alignmentBlocks[0] = new AlignmentBlockImpl(this.getStart(), readBases, readBaseQualities, 0, readBases.length, '*');
        } else {
            List<CigarOperator> operators = SAMAlignment.buildOperators(cigarString);
            boolean showSoftClipped = PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
            int nInsertions = 0;
            int nBlocks = 0;
            boolean firstOperator = true;
            int softClippedBaseCount = 0;
            int nGaps = 0;
            int nRealGaps = 0;
            char prevOp = '\u0000';
            for (CigarOperator operator : operators) {
                char op = operator.operator;
                if (op == 'H') continue;
                int nBases = operator.nBases;
                if (SAMAlignment.operatorIsMatch(showSoftClipped, op)) {
                    ++nBlocks;
                    if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                        ++nGaps;
                    }
                } else if (op == 'D' || op == 'N') {
                    ++nGaps;
                    ++nRealGaps;
                } else if (op == 'I') {
                    ++nInsertions;
                    ++nGaps;
                }
                if (firstOperator && op == 'S') {
                    softClippedBaseCount += nBases;
                }
                if (op != 'S') {
                    firstOperator = false;
                }
                prevOp = op;
            }
            this.alignmentBlocks = new AlignmentBlockImpl[nBlocks];
            this.insertions = new AlignmentBlockImpl[nInsertions];
            if (nGaps > 0) {
                this.gapTypes = new char[nGaps];
            }
            if (nRealGaps > 0) {
                this.gaps = new ArrayList<Gap>();
            }
            if (showSoftClipped) {
                this.start -= softClippedBaseCount;
            }
            int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
            int blockStart = this.start;
            int blockIdx = 0;
            int insertionIdx = 0;
            int gapIdx = 0;
            int padding = 0;
            prevOp = '\u0000';
            for (int i = 0; i < operators.size(); ++i) {
                CigarOperator op = operators.get(i);
                try {
                    if (op.operator == 'H') continue;
                    if (SAMAlignment.operatorIsMatch(showSoftClipped, op.operator)) {
                        block = AlignmentUtils.buildAlignmentBlock(op.operator, readBases, readBaseQualities, blockStart, fromIdx, op.nBases);
                        if (op.operator == 'S') {
                            block.setSoftClipped(true);
                        }
                        this.alignmentBlocks[blockIdx++] = block;
                        fromIdx += op.nBases;
                        blockStart += op.nBases;
                        if (SAMAlignment.operatorIsMatch(showSoftClipped, prevOp)) {
                            this.gapTypes[gapIdx++] = 79;
                        }
                    } else if (op.operator == 'D') {
                        this.gaps.add(new Gap(blockStart, op.nBases, op.operator));
                        blockStart += op.nBases;
                        this.gapTypes[gapIdx++] = op.operator;
                    } else if (op.operator == 'N') {
                        int flankingLeft = 0;
                        int flankingRight = 0;
                        if (i > 0) {
                            flankingLeft = operators.get((int)(i - 1)).nBases;
                        }
                        if (i < operators.size() - 1) {
                            flankingRight = operators.get((int)(i + 1)).nBases;
                        }
                        this.gaps.add(new SpliceGap(blockStart, op.nBases, op.operator, flankingLeft, flankingRight));
                        blockStart += op.nBases;
                        this.gapTypes[gapIdx++] = op.operator;
                    } else if (op.operator == 'I') {
                        this.gapTypes[gapIdx++] = 79;
                        block = AlignmentUtils.buildAlignmentBlock(op.operator, readBases, readBaseQualities, blockStart, fromIdx, op.nBases);
                        block.setPadding(padding);
                        this.insertions[insertionIdx++] = block;
                        fromIdx += op.nBases;
                        padding = 0;
                    } else if (op.operator == 'P') {
                        padding += op.nBases;
                    }
                }
                catch (Exception e) {
                    log.error("Error processing CIGAR string", e);
                }
                prevOp = op.operator;
            }
            if (showSoftClipped && operators.size() > 0) {
                CigarOperator last = operators.get(operators.size() - 1);
                if (last.operator == 'S') {
                    this.end += last.nBases;
                }
            }
        }
    }

    private static List<CigarOperator> buildOperators(String cigarString) {
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuilder buffer = new StringBuilder(4);
        CigarOperator prevOp = null;
        for (int i = 0; i < cigarString.length(); ++i) {
            char next = cigarString.charAt(i);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            int nBases = Integer.parseInt(buffer.toString());
            buffer.setLength(0);
            if (prevOp != null && prevOp.operator == op) {
                prevOp.nBases += nBases;
                continue;
            }
            prevOp = new CigarOperator(nBases, op);
            operators.add(prevOp);
        }
        return operators;
    }

    @Override
    public String getClipboardString(double location, int mouseX) {
        StringBuilder buf = new StringBuilder();
        String popupTextString = this.getAlignmentValueString(location, mouseX, null);
        buf.append(popupTextString);
        buf.append("----------------------");
        String readSequence = this.getReadSequence();
        String origSequence = this.isNegativeStrand() ? SequenceUtil.reverseComplement((String)readSequence) : readSequence;
        buf.append("\n\nRead sequence = ");
        buf.append(readSequence);
        buf.append("\n\nOrig sequence = ");
        buf.append(origSequence);
        buf.append("\n");
        return buf.toString();
    }

    private Integer positionToReadIndex(double position) {
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains((int)position)) continue;
            return (int)(position - (double)block.getStart()) + block.getBasesOffset();
        }
        return null;
    }

    @Override
    public String getAlignmentValueString(double position, int mouseX, AlignmentTrack.RenderOptions renderOptions) {
        String attributeString;
        Object suppAlignment;
        String readGroup;
        String library;
        boolean truncate = renderOptions != null;
        int basePosition = (int)position;
        StringBuffer buf = new StringBuffer();
        if (this.getClusterName() != null) {
            buf.append("Cluster name: " + this.getClusterName() + "<br>");
            buf.append("Dist: " + this.getClusterDistance() + "<br>");
        }
        boolean hideSmallIndels = renderOptions == null ? false : renderOptions.isHideSmallIndels();
        int smallIndelThreshold = renderOptions == null ? 0 : renderOptions.getSmallIndelThreshold();
        boolean atInsertion = false;
        boolean atBaseMod = false;
        if (this.insertions != null) {
            for (AlignmentBlockImpl block : this.insertions) {
                if (!block.containsPixel(mouseX) || hideSmallIndels && block.getBasesLength() < smallIndelThreshold) continue;
                ByteSubarray bases = block.getBases();
                ByteSubarray quals = block.getQualities();
                if (bases == null) {
                    buf.append("Insertion: " + block.getLength() + " bases<br>");
                } else {
                    if (bases.length < 50) {
                        buf.append("Insertion (" + bases.length + " bases): " + bases.getString() + "<br>");
                        String qualString = SbxUtils.qualityString(quals.getString());
                        buf.append("Qualities: " + qualString + "<br>");
                    } else {
                        int len = bases.length;
                        buf.append("Insertion (" + bases.length + " bases): " + new String(bases.copyOfRange(0, 25)) + "..." + new String(bases.copyOfRange(len - 25, len)) + "<br>");
                        buf.append("Qualities: " + SbxUtils.qualityString(new String(quals.copyOfRange(0, 25))) + "..." + SbxUtils.qualityString(new String(quals.copyOfRange(len - 25, len))) + "<br>");
                    }
                    if (flowBlockAnnotator.handlesBlocks(block)) {
                        flowBlockAnnotator.appendBlockQualityAnnotation(this, block, buf);
                    }
                }
                atInsertion = true;
            }
        }
        if (renderOptions != null) {
            AlignmentTrack.ColorOption colorOption = renderOptions.getColorOption();
            if (colorOption.isBaseMod()) {
                Integer readIndex = this.positionToReadIndex(position);
                if (readIndex != null) {
                    int p = readIndex;
                    if (this.baseModificationSets != null) {
                        Object modString = "";
                        for (BaseModificationSet bmSet : this.baseModificationSets) {
                            if (!bmSet.containsPosition(p)) continue;
                            if (((String)modString).length() > 0) {
                                modString = (String)modString + "<br>";
                            }
                            modString = (String)modString + bmSet.valueString(p);
                        }
                        if (((String)modString).length() > 0) {
                            buf.append((String)modString);
                            buf.append("<br");
                            atBaseMod = true;
                        }
                    }
                }
            } else if (colorOption.isSMRTKinetics()) {
                Integer readIndex = this.positionToReadIndex(position);
                SMRTKinetics sk = this.getSmrtKinetics();
                if (readIndex != null) {
                    if (colorOption == AlignmentTrack.ColorOption.SMRT_SUBREAD_IPD) {
                        short[] ipdVals = sk.getSmrtSubreadIpd();
                        if (ipdVals != null) {
                            return "Subread IPD: " + Short.toUnsignedInt(ipdVals[readIndex]) + " Frames";
                        }
                    } else if (colorOption == AlignmentTrack.ColorOption.SMRT_SUBREAD_PW) {
                        short[] pwVals = sk.getSmrtSubreadPw();
                        if (pwVals != null) {
                            return "Subread PW: " + Short.toUnsignedInt(pwVals[readIndex]) + " Frames";
                        }
                    } else if (colorOption == AlignmentTrack.ColorOption.SMRT_CCS_FWD_IPD || colorOption == AlignmentTrack.ColorOption.SMRT_CCS_REV_IPD) {
                        boolean isForwardStrand = colorOption == AlignmentTrack.ColorOption.SMRT_CCS_FWD_IPD;
                        short[] ipdVals = sk.getSmrtCcsIpd(isForwardStrand);
                        if (ipdVals != null) {
                            strand = isForwardStrand ? "fwd" : "rev";
                            return "CCS " + strand + "-strand aligned IPD: " + Short.toUnsignedInt(ipdVals[readIndex]) + " Frames";
                        }
                    } else {
                        boolean isForwardStrand = colorOption == AlignmentTrack.ColorOption.SMRT_CCS_FWD_PW;
                        short[] pwVals = sk.getSmrtCcsPw(isForwardStrand);
                        if (pwVals != null) {
                            strand = isForwardStrand ? "fwd" : "rev";
                            return "CCS " + strand + "-strand aligned PW: " + Short.toUnsignedInt(pwVals[readIndex]) + " Frames";
                        }
                    }
                }
            }
        }
        if (atInsertion || atBaseMod) {
            return buf.toString();
        }
        buf.append("Read name = " + this.getReadName() + "<br>");
        String sample = this.getSample();
        if (sample != null) {
            buf.append("Sample = " + sample + "<br>");
        }
        if ((library = this.getLibrary()) != null) {
            buf.append("Library = " + library + "<br>");
        }
        if ((readGroup = this.getReadGroup()) != null) {
            buf.append("Read group = " + readGroup + "<br>");
        }
        buf.append("Read length = " + this.getReadLengthString() + "<br>");
        buf.append("Flags = " + this.record.getFlags() + "<br>");
        buf.append("----------------------<br>");
        Object cigarString = this.getCigarString();
        if (((String)cigarString).length() > 50) {
            Matcher lMatcher = LEFT_CIGAR_PATTERN.matcher((CharSequence)cigarString);
            Matcher rMatcher = RIGHT_CIGAR_PATTERN.matcher((CharSequence)cigarString);
            cigarString = (lMatcher.find() ? lMatcher.group(1) : "") + "..." + (rMatcher.find() ? rMatcher.group(1) : "");
        }
        buf.append("Mapping = " + (this.isPrimary() ? (this.isSupplementary() ? "Supplementary" : "Primary") : "Secondary") + (this.isDuplicate() ? " Duplicate" : "") + (this.isVendorFailedRead() ? " Failed QC" : "") + " @ MAPQ " + Globals.DECIMAL_FORMAT.format(this.getMappingQuality()) + "<br>");
        buf.append("Reference span = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart() + 1) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + (this.isNegativeStrand() ? "-" : "+") + ") = " + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd() - this.getAlignmentStart()) + "bp<br>");
        buf.append("Cigar = " + (String)cigarString + "<br>");
        buf.append("Clipping = ");
        ClippingCounts clipping = this.getClippingCounts();
        if (!clipping.isClipped()) {
            buf.append("None");
        } else {
            if (clipping.isLeftClipped()) {
                buf.append("Left");
                if (clipping.getLeftHard() > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(clipping.getLeftHard()) + " hard");
                }
                if (clipping.getLeftSoft() > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(clipping.getLeftSoft()) + " soft");
                }
            }
            if (clipping.isRightClipped()) {
                buf.append((clipping.isLeftClipped() ? "; " : "") + "Right");
                if (clipping.getRightHard() > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(clipping.getRightHard()) + " hard");
                }
                if (clipping.getRightSoft() > 0) {
                    buf.append(" " + Globals.DECIMAL_FORMAT.format(clipping.getRightSoft()) + " soft");
                }
            }
        }
        buf.append("<br>");
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (this.isPaired()) {
            buf.append("----------------------<br>");
            buf.append("Mate is mapped = " + (this.getMate().isMapped() ? "yes" : "no") + "<br>");
            if (this.getMate().isMapped()) {
                buf.append("Mate start = " + this.getMate().positionString() + "<br>");
                if (this.getChr().equals(this.getMate().getChr())) {
                    buf.append("Insert size = " + this.getInferredInsertSize() + "<br>");
                }
            }
            if (this.isFirstOfPair()) {
                buf.append("First in pair<br>");
            }
            if (this.isSecondOfPair()) {
                buf.append("Second in pair<br>");
            }
            if (this.getPairOrientation().length() > 0) {
                buf.append("Pair orientation = " + this.getPairOrientation() + "<br>");
            }
        }
        if ((suppAlignment = this.getAttribute(SAMTag.SA)) != null) {
            buf.append("----------------------<br>");
            buf.append(this.getSupplAlignmentString());
            buf.append("<br>");
        }
        if ((attributeString = this.getAttributeString(truncate)) != null && attributeString.length() > 0) {
            buf.append("----------------------");
            buf.append(this.getAttributeString(truncate));
        }
        if (this.mateSequence != null) {
            buf.append("----------------------<br>");
            buf.append("Mate sequence: " + this.mateSequence);
        }
        for (AlignmentBlockImpl block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            buf.append("<hr>");
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            if (base == 0 && this.getReadSequence().equals("=") && !block.isSoftClip() && genome != null) {
                base = genome.getReference(this.chr, basePosition);
            }
            byte quality = block.getQuality(offset);
            buf.append("Location = " + this.getChr() + ":" + Globals.DECIMAL_FORMAT.format(1L + (long)position) + "<br>");
            buf.append("Base = " + (char)base + " @ QV " + Globals.DECIMAL_FORMAT.format(quality));
            if (FlowUtil.isFlow(this) && flowBlockAnnotator.handlesBlocks(block)) {
                flowBlockAnnotator.appendBlockAttrAnnotation(this, block, offset, buf);
            }
            buf.append("<br>");
            break;
        }
        return buf.toString();
    }

    private String getAttributeString(boolean truncate) {
        ArrayList<String> tagsToHide = new ArrayList<String>();
        ArrayList<String> tagsHidden = new ArrayList<String>();
        String samHiddenTagsPref = PreferencesManager.getPreferences().get("SAM.HIDDEN_TAGS");
        for (String s : (samHiddenTagsPref == null ? "" : samHiddenTagsPref).split("[, ]")) {
            if (s.equals("")) continue;
            tagsToHide.add(s);
        }
        StringBuffer buf = new StringBuffer();
        SAMRecord record = this.getRecord();
        List attributes = record.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                if (tagsToHide.contains(tag.tag)) {
                    tagsHidden.add(tag.tag);
                    continue;
                }
                buf.append("<br>" + tag.tag + " = ");
                if (tag.tag.equals("ML") || tag.tag.equals("Ml")) {
                    buf.append(this.getMlTagString(tag));
                    buf.append("<br>");
                    continue;
                }
                if (tag.value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = tag.value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            if (tagsHidden.size() > 0) {
                buf.append("<br>Hidden tags: " + String.join((CharSequence)", ", tagsHidden));
            }
        }
        return buf.toString();
    }

    private String getMlTagString(SAMRecord.SAMTagAndValue tag) {
        byte[] bytes = (byte[])tag.value;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(Byte.toUnsignedInt(bytes[i]));
        }
        return buf.toString();
    }

    private String getSupplAlignmentString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Supplementary Alignments");
        List<SupplementaryAlignment> supplementaryAlignments = this.getSupplementaryAlignments();
        int insertionIndex = SupplementaryAlignment.getInsertionIndex(this, supplementaryAlignments);
        int i = 0;
        for (SupplementaryAlignment sa : supplementaryAlignments) {
            if (i == insertionIndex) {
                sb.append(this.getThisReadDescriptionForSAList());
            }
            ++i;
            try {
                sb.append("<br>" + sa.printString());
            }
            catch (Exception e) {
                sb.append("<br>* Invalid SA entry (not listed) *");
            }
        }
        if (i == insertionIndex) {
            sb.append(this.getThisReadDescriptionForSAList());
        }
        return sb.toString();
    }

    private String getThisReadDescriptionForSAList() {
        return "<br><b>" + this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart() + 1) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + this.getReadStrand().toShortString() + ") = " + Globals.DECIMAL_FORMAT.format(this.getLengthOnReference()) + "bp  @MAPQ " + this.getMappingQuality() + " NM" + String.valueOf(this.getAttribute(SAMTag.NM)) + "</b>";
    }

    @Override
    public float getScore() {
        return this.getMappingQuality();
    }

    public void setMate(ReadMate mate) {
        this.mate = mate;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public List<Gap> getGaps() {
        return this.gaps;
    }

    @Override
    public AlignmentBlock getInsertionAt(int position) {
        for (AlignmentBlockImpl block : this.insertions) {
            if (block.getStart() == position) {
                return block;
            }
            if (block.getStart() <= position) continue;
            return null;
        }
        return null;
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public void setMateSequence(String sequence) {
        this.mateSequence = sequence;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstOfPairStrand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.secondOfPairStrand;
    }

    protected void setPairOrientation() {
        if (this.isPaired() && this.isMapped() && this.mate != null && this.mate.isMapped() && this.getChr().equals(this.mate.getChr())) {
            int s1 = this.isNegativeStrand() ? 82 : 70;
            int s2 = this.mate.isNegativeStrand() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (this.isFirstOfPair()) {
                o1 = 49;
                o2 = 50;
            } else if (this.isSecondOfPair()) {
                o1 = 50;
                o2 = 49;
            }
            char[] tmp = new char[4];
            int isize = this.getInferredInsertSize();
            int estReadLen = this.getAlignmentEnd() - this.getAlignmentStart();
            if (isize == 0) {
                int estMateEnd = this.getAlignmentStart() < this.mate.getStart() ? this.getMate().getStart() + estReadLen : this.mate.getStart() - estReadLen;
                isize = estMateEnd - this.getAlignmentStart();
            }
            if (isize > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            this.pairOrientation = new String(tmp);
        }
    }

    public void setChr(String chr) {
        this.chr = chr;
    }

    public String getSynopsisString() {
        char st = this.isNegativeStrand() ? (char)'-' : '+';
        Object nm = this.getAttribute(SAMTag.NM);
        String numMismatches = nm == null ? "?" : nm.toString();
        int lenOnRef = this.getAlignmentEnd() - this.getAlignmentStart();
        ClippingCounts clipping = this.getClippingCounts();
        Object clippingString = "";
        if (clipping.isClipped()) {
            if (clipping.getLeftHard() > 0) {
                clippingString = (String)clippingString + clipping.getLeftHard() + "H";
            }
            if (clipping.getLeftSoft() > 0) {
                clippingString = (String)clippingString + clipping.getLeftSoft() + "S";
            }
            clippingString = (String)clippingString + " ... ";
            if (clipping.getRightSoft() > 0) {
                clippingString = (String)clippingString + clipping.getRightSoft() + "S";
            }
            if (clipping.getRightHard() > 0) {
                clippingString = (String)clippingString + clipping.getRightHard() + "H";
            }
        }
        return this.chr + ":" + Globals.DECIMAL_FORMAT.format(this.getAlignmentStart()) + "-" + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd()) + " (" + st + ") = " + Globals.DECIMAL_FORMAT.format(lenOnRef) + "BP  @MAPQ=" + this.getMappingQuality() + " NM=" + numMismatches + " CLIPPING=" + (String)clippingString;
    }

    private static boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    @Override
    public void setClusterName(String hap) {
        this.haplotypeName = hap;
    }

    @Override
    public String getClusterName() {
        return this.haplotypeName;
    }

    @Override
    public void setHapDistance(int dist) {
        this.hapDistance = dist;
    }

    @Override
    public int getClusterDistance() {
        return this.hapDistance;
    }

    public List<SupplementaryAlignment> getSupplementaryAlignments() {
        return this.getCachedOrCompute(CacheKey.SA_GROUP, () -> {
            Object rawSAValue = this.getAttribute(SAMTag.SA);
            if (rawSAValue == null) {
                return null;
            }
            List<SupplementaryAlignment> sas = Collections.unmodifiableList(SupplementaryAlignment.parseFromSATag(rawSAValue.toString()));
            return sas;
        });
    }

    private static enum CacheKey {
        CLIPPING_COUNTS,
        SA_GROUP;

    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }
}

