/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;

public class HeatmapRenderer
extends DataRenderer {
    private static Logger log = LogManager.getLogger(HeatmapRenderer.class);

    public String getDisplayName() {
        return "Heatmap";
    }

    @Override
    public void renderScores(Track track, List<LocusScore> scores, RenderContext context, Rectangle rect) {
        Color noCallColor;
        ContinuousColorScale colorScale = track.getColorScale();
        double origin = context.getOrigin();
        double locScale = context.getScale();
        try {
            noCallColor = PreferencesManager.getPreferences().getAsColor("NO_CALL.COLOR");
        }
        catch (Exception e) {
            log.error("Error parsing color string: " + PreferencesManager.getPreferences().get("NO_DATA.COLOR"));
            noCallColor = Color.DARK_GRAY;
        }
        Color bgColor = colorScale.getNoDataColor();
        context.getGraphic2DForColor(bgColor).fill(rect);
        boolean showAllFeatures = PreferencesManager.getPreferences().getAsBoolean("CHART.SHOW_ALL_HEATMAP");
        double maxX = rect.getMaxX();
        int minY = (int)rect.getMinY();
        int height = (int)rect.getHeight();
        int lastPEnd = 0;
        int lastPStart = 0;
        int lastW = 0;
        for (LocusScore score : scores) {
            if ((double)lastPStart > maxX) break;
            float fStart = (float)(((double)score.getStart() - origin) / locScale);
            float fEnd = (float)(((double)score.getEnd() - origin) / locScale);
            int pStart = (int)fStart;
            int pEnd = (int)fEnd;
            int min = showAllFeatures ? 1 : Math.min(pStart - lastPEnd, 1);
            int w = Math.max(min, pEnd - pStart);
            float scoreValue = score.getScore();
            Color graphColor = Float.isNaN(scoreValue) ? noCallColor : colorScale.getColor(track.logScaleData(score.getScore()));
            if (pStart + w >= 0 && (double)lastPStart <= maxX) {
                if (track.getTrackType() == TrackType.DNA_METHYLATION) {
                    if (w < 6) {
                        int pMid = (pStart + pEnd) / 2;
                        pStart = pMid - 3;
                        w = 6;
                    }
                } else if (pStart < lastPEnd && w > 1 && lastW == 1) {
                    ++pStart;
                    --w;
                }
                Graphics2D g2D = context.getGraphic2DForColor(graphColor);
                if ((double)pStart < maxX) {
                    int pLeft = Math.max(rect.x, pStart);
                    int pRight = Math.min(rect.x + rect.width, pStart + w);
                    int adjustedW = pRight - pLeft;
                    g2D.fillRect(pLeft, minY, adjustedW, height);
                }
            }
            lastPStart = pStart;
            lastPEnd = pStart + w;
            lastW = w;
        }
    }
}

