/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;

public class ChromAliasParser {
    private static Logger log = LogManager.getLogger(ChromAliasParser.class);

    public static List<List<String>> loadChrAliases(String path) {
        List<List<String>> list;
        block8: {
            BufferedReader br = ParsingUtils.openBufferedReader(path);
            try {
                list = ChromAliasParser.loadChrAliases(br);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error loading chr alias table", e);
                    MessageUtils.showMessage("<html>Error loading chromosome alias table.  Aliases will not be available<br>" + e.toString());
                    return null;
                }
            }
            br.close();
        }
        return list;
    }

    public static List<List<String>> loadChrAliases(BufferedReader br) throws IOException {
        String nextLine = "";
        ArrayList<List<String>> synonymList = new ArrayList<List<String>>();
        while ((nextLine = br.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            if (tokens.length <= 1) continue;
            ArrayList<String> synonyms = new ArrayList<String>();
            for (String t : tokens) {
                String syn = t.trim();
                if (t.length() <= 0) continue;
                synonyms.add(syn.trim());
            }
            synonymList.add(synonyms);
        }
        return synonymList;
    }
}

