/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class ChromAliasManager {
    private static Logger log = LogManager.getLogger(ChromAliasManager.class);
    private Set<String> sequenceNames;
    private Genome genome;
    private Map<String, String> aliasCache;

    public ChromAliasManager(Collection<String> sequenceNames, Genome genome) {
        this.sequenceNames = new HashSet<String>(sequenceNames);
        this.aliasCache = new HashMap<String, String>();
        this.genome = genome;
    }

    public String getAliasName(String seqName) {
        if (this.genome == null) {
            return seqName;
        }
        try {
            String alias;
            if (!this.aliasCache.containsKey(seqName)) {
                ChromAlias aliasRecord = this.genome.getAliasRecord(seqName);
                if (aliasRecord == null) {
                    this.aliasCache.put(seqName, null);
                } else {
                    for (String alias2 : aliasRecord.values()) {
                        if (!this.sequenceNames.contains(alias2)) continue;
                        this.aliasCache.put(seqName, alias2);
                    }
                }
            }
            return (alias = this.aliasCache.get(seqName)) != null ? alias : seqName;
        }
        catch (IOException e) {
            log.error("Error loading alias file ", e);
            return seqName;
        }
    }
}

