/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.encode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.encode.EncodeFileRecord;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;

public class UCSCEncodeUtils {
    private static Set<String> labs = new HashSet<String>();
    private static Set<String> dataTypes = new HashSet<String>();
    private static Set<String> cells = new HashSet<String>();
    private static Set<String> antibodies = new HashSet<String>();
    private static Set<String> fileTypes = new HashSet<String>();
    private static Set<String> allHeaders = new LinkedHashSet<String>();
    private static List<String> rnaChipQualifiers = Arrays.asList("CellTotal", "Longnonpolya", "Longpolya", "NucleolusTotal", "ChromatinTotal", "ChromatinTotal", "NucleoplasmTotal");
    static String[] columnHeadings = new String[]{"cell", "dataType", "antibody", "view", "replicate", "type", "lab"};
    static HashSet knownFileTypes = new HashSet<String>(Arrays.asList("bam", "bigBed", "bed", "bb", "bw", "bigWig", "gtf", "broadpeak", "narrowpeak", "gappedpeak", "regionpeak", "gff"));

    public static void main(String[] args) throws IOException {
        UCSCEncodeUtils.updateEncodeTableFile(args[0], args[1]);
    }

    private static void updateEncodeTableFile(String inputFile, String outputFile) throws IOException {
        ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>();
        try (BufferedReader reader = ParsingUtils.openBufferedReader(inputFile);){
            String nextLine;
            String rootPath = reader.readLine();
            String hub = null;
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    hub = nextLine.startsWith("#hub=") ? nextLine.substring(5) : hub;
                    continue;
                }
                String dir = nextLine.equals(".") ? rootPath : rootPath + nextLine;
                String filesDotTxt = dir + "/files.txt";
                if (!HttpUtils.getInstance().resourceAvailable(filesDotTxt)) continue;
                try {
                    UCSCEncodeUtils.parseFilesDotTxt(filesDotTxt, records);
                }
                catch (IOException iOException) {}
            }
            fileTypes.forEach(System.out::println);
            UCSCEncodeUtils.outputRecords(outputFile, records, hub);
        }
    }

    private static void outputRecords(String outputFile, List<EncodeFileRecord> records, String hub) throws IOException {
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));){
            StringBuilder sb = new StringBuilder("path");
            for (String h : columnHeadings) {
                sb.append("\t").append(h);
            }
            if (hub != null) {
                sb.append("\thub");
            }
            pw.println(sb.toString());
            for (EncodeFileRecord rec : records) {
                sb = new StringBuilder(rec.getPath());
                for (String h : columnHeadings) {
                    sb.append("\t").append(Optional.ofNullable(rec.getAttributeValue(h)).orElse(""));
                }
                if (hub != null) {
                    sb.append("\t").append(hub);
                }
                pw.println(sb.toString());
            }
        }
    }

    public static void parseFilesDotTxt(String url, List<EncodeFileRecord> fileRecords) throws IOException {
        String nextLine;
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(url);
        while ((nextLine = reader.readLine()) != null) {
            String ftype;
            String[] tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length < 2) continue;
            String fn = tokens[0];
            String[] attributes = Globals.semicolonPattern.split(tokens[1]);
            LinkedHashMap<String, String> kvalues = new LinkedHashMap<String, String>();
            for (String tk : attributes) {
                String[] kv = Globals.equalPattern.split(tk);
                if (kv.length <= 1) continue;
                kvalues.put(kv[0].trim(), kv[1].trim());
                allHeaders.add(kv[0].trim());
            }
            if ("RnaChip".equals(kvalues.get("dataType"))) {
                for (String qual : rnaChipQualifiers) {
                    if (!fn.contains(qual)) continue;
                    kvalues.put("antibody", qual);
                }
            }
            String path = fn.startsWith("http") ? fn : url.replace("files.txt", fn);
            EncodeFileRecord df = new EncodeFileRecord(path, kvalues);
            String string = ftype = df.getFileType() == null ? null : df.getFileType().toLowerCase();
            if (knownFileTypes.contains(ftype)) {
                fileRecords.add(df);
            }
            dataTypes.add(df.getAttributeValue("dataType"));
            antibodies.add(df.getAttributeValue("antibody"));
            cells.add(df.getAttributeValue("cell"));
            labs.add(df.getAttributeValue("lab"));
            fileTypes.add(df.getFileType());
        }
        reader.close();
    }
}

