/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.seg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.data.CharArrayList;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class SegmentedChromosomeData {
    private static Logger log = LogManager.getLogger(SegmentedChromosomeData.class);
    private String[] sampleNames;
    Map<String, int[]> startLocations;
    Map<String, int[]> endLocations;
    Map<String, float[]> valueMap;

    public SegmentedChromosomeData() {
    }

    public SegmentedChromosomeData(String[] sampleNames, Map<String, int[]> startLocations, Map<String, int[]> endLocations, Map<String, float[]> valueMap) {
        this.sampleNames = sampleNames;
        this.startLocations = startLocations;
        this.endLocations = endLocations;
        this.valueMap = valueMap;
    }

    public void serialize(OutputStream stream) {
        try {
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(stream));
            for (String sample : this.getSampleNames()) {
                os.writeChars(sample);
                os.writeChar(9);
            }
            os.writeChar(10);
            for (String sample : this.getSampleNames()) {
                int i;
                int[] starts = this.startLocations.get(sample);
                int[] ends = this.endLocations.get(sample);
                float[] values = this.valueMap.get(sample);
                int nPts = starts.length;
                assert (ends.length == nPts);
                assert (values.length == nPts);
                os.writeInt(nPts);
                for (i = 0; i < nPts; ++i) {
                    os.writeInt(starts[i]);
                }
                for (i = 0; i < nPts; ++i) {
                    os.writeInt(ends[i]);
                }
                for (i = 0; i < nPts; ++i) {
                    os.writeFloat(values[i]);
                }
            }
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deserialize(InputStream stream) {
        this.startLocations = new HashMap<String, int[]>();
        this.endLocations = new HashMap<String, int[]>();
        this.valueMap = new HashMap<String, float[]>();
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(stream));
            ArrayList<String> tmp = new ArrayList<String>(100);
            char c = '\u0000';
            try {
                c = is.readChar();
            }
            catch (EOFException e) {
                return;
            }
            while (c != '\n') {
                CharArrayList chars = new CharArrayList(10);
                while (c != '\t') {
                    chars.add(c);
                    c = is.readChar();
                }
                String nm = new String(chars.toArray()).trim();
                tmp.add(nm);
                c = is.readChar();
            }
            for (String sample : this.sampleNames = tmp.toArray(new String[0])) {
                int nPts = is.readInt();
                int[] starts = new int[nPts];
                for (int i = 0; i < nPts; ++i) {
                    starts[i] = is.readInt();
                }
                int[] ends = new int[nPts];
                for (int i = 0; i < nPts; ++i) {
                    ends[i] = is.readInt();
                }
                float[] values = new float[nPts];
                for (int i = 0; i < nPts; ++i) {
                    values[i] = is.readFloat();
                }
                this.startLocations.put(sample, starts);
                this.endLocations.put(sample, ends);
                this.valueMap.put(sample, values);
            }
        }
        catch (IOException e) {
            log.error("Error loading segmented data", e);
        }
    }

    public String[] getSampleNames() {
        return this.sampleNames;
    }

    public int[] getStartLocations(String sampleName) {
        return this.startLocations.get(sampleName);
    }

    public int[] getEndLocations(String sampleName) {
        return this.endLocations.get(sampleName);
    }

    public float[] getValues(String sampleName) {
        return this.valueMap.get(sampleName);
    }
}

