/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeDeveloperIdentitiesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, MergeDeveloperIdentitiesResponse> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(MergeDeveloperIdentitiesResponse.getter(MergeDeveloperIdentitiesResponse::identityId)).setter(MergeDeveloperIdentitiesResponse.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MergeDeveloperIdentitiesResponse.memberNameToFieldInitializer();
    private final String identityId;

    private MergeDeveloperIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
    }

    public final String identityId() {
        return this.identityId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesResponse)) {
            return false;
        }
        MergeDeveloperIdentitiesResponse other = (MergeDeveloperIdentitiesResponse)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId());
    }

    public final String toString() {
        return ToString.builder((String)"MergeDeveloperIdentitiesResponse").add("IdentityId", (Object)this.identityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IdentityId", IDENTITY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeDeveloperIdentitiesResponse, T> g) {
        return obj -> g.apply((MergeDeveloperIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesResponse model) {
            super(model);
            this.identityId(model.identityId);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        @Override
        public MergeDeveloperIdentitiesResponse build() {
            return new MergeDeveloperIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeDeveloperIdentitiesResponse> {
        public Builder identityId(String var1);
    }
}

