/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MappingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MappingRule> {
    private static final SdkField<String> CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Claim").getter(MappingRule.getter(MappingRule::claim)).setter(MappingRule.setter(Builder::claim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Claim").build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(MappingRule.getter(MappingRule::matchTypeAsString)).setter(MappingRule.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(MappingRule.getter(MappingRule::value)).setter(MappingRule.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(MappingRule.getter(MappingRule::roleARN)).setter(MappingRule.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_FIELD, MATCH_TYPE_FIELD, VALUE_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MappingRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String claim;
    private final String matchType;
    private final String value;
    private final String roleARN;

    private MappingRule(BuilderImpl builder) {
        this.claim = builder.claim;
        this.matchType = builder.matchType;
        this.value = builder.value;
        this.roleARN = builder.roleARN;
    }

    public final String claim() {
        return this.claim;
    }

    public final MappingRuleMatchType matchType() {
        return MappingRuleMatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public final String value() {
        return this.value;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.claim());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule)obj;
        return Objects.equals(this.claim(), other.claim()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.roleARN(), other.roleARN());
    }

    public final String toString() {
        return ToString.builder((String)"MappingRule").add("Claim", (Object)this.claim()).add("MatchType", (Object)this.matchTypeAsString()).add("Value", (Object)this.value()).add("RoleARN", (Object)this.roleARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Claim": {
                return Optional.ofNullable(clazz.cast(this.claim()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Claim", CLAIM_FIELD);
        map.put("MatchType", MATCH_TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MappingRule, T> g) {
        return obj -> g.apply((MappingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String claim;
        private String matchType;
        private String value;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            this.claim(model.claim);
            this.matchType(model.matchType);
            this.value(model.value);
            this.roleARN(model.roleARN);
        }

        public final String getClaim() {
            return this.claim;
        }

        public final void setClaim(String claim) {
            this.claim = claim;
        }

        @Override
        public final Builder claim(String claim) {
            this.claim = claim;
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MappingRuleMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public MappingRule build() {
            return new MappingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MappingRule> {
        public Builder claim(String var1);

        public Builder matchType(String var1);

        public Builder matchType(MappingRuleMatchType var1);

        public Builder value(String var1);

        public Builder roleARN(String var1);
    }
}

