/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.variants;

import htsjdk.beta.io.IOPathUtils;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleJSON;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Tuple;
import htsjdk.utils.ValidationUtils;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class VariantsBundle
extends Bundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getInstance(VariantsBundle.class);

    public VariantsBundle(IOPath vcfPath) {
        this(List.of(VariantsBundle.toInputResource("VARIANT_CONTEXTS", vcfPath)));
    }

    public VariantsBundle(IOPath vcfPath, IOPath indexPath) {
        this(List.of(VariantsBundle.toInputResource("VARIANT_CONTEXTS", vcfPath), VariantsBundle.toInputResource("VARIANTS_INDEX", indexPath)));
    }

    public VariantsBundle(Collection<BundleResource> resources) {
        super("VARIANT_CONTEXTS", resources);
    }

    public BundleResource getVariants() {
        return this.getOrThrow("VARIANT_CONTEXTS");
    }

    public Optional<BundleResource> getIndex() {
        return this.get("VARIANTS_INDEX");
    }

    public static VariantsBundle getVariantsBundleFromPath(IOPath jsonPath) {
        return VariantsBundle.getVariantsBundleFromString(IOPathUtils.getStringFromPath(jsonPath));
    }

    public static <T extends IOPath> VariantsBundle getVariantsBundleFromPath(IOPath jsonPath, Function<String, T> ioPathConstructor) {
        return VariantsBundle.getVariantsBundleFromString(IOPathUtils.getStringFromPath(jsonPath), ioPathConstructor);
    }

    public static VariantsBundle getVariantsBundleFromString(String jsonString) {
        return VariantsBundle.getVariantsBundleFromString(jsonString, HtsPath::new);
    }

    public static <T extends IOPath> VariantsBundle getVariantsBundleFromString(String jsonString, Function<String, T> ioPathConstructor) {
        return new VariantsBundle(BundleJSON.toBundle(jsonString, ioPathConstructor).getResources());
    }

    public static Optional<IOPath> resolveIndex(IOPath variants) {
        return VariantsBundle.resolveIndex(variants, HtsPath::new);
    }

    public static <T extends IOPath> Optional<T> resolveIndex(T variantsHtsPath, Function<String, T> ioPathConstructor) {
        Set<String> indexExtensions = Set.of(".idx", ".tbi");
        for (String extension : indexExtensions) {
            T putativeIndexPath = IOPathUtils.appendExtension(variantsHtsPath, extension, ioPathConstructor);
            if (!Files.exists(putativeIndexPath.toPath(), new LinkOption[0])) continue;
            return Optional.of(putativeIndexPath);
        }
        return Optional.empty();
    }

    private static <T extends IOPath> IOPathResource toInputResource(String providedContentType, T ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        Optional<Tuple<String, String>> typePair = VariantsBundle.getInferredContentTypes(ioPath);
        if (typePair.isPresent() && providedContentType != null && !((String)typePair.get().a).equals(providedContentType)) {
            LOG.warn(String.format("Provided content type \"%s\" for \"%s\" doesn't match derived content type \"%s\"", providedContentType, ioPath.getRawInputString(), typePair.get().a));
        }
        return new IOPathResource(ioPath, providedContentType);
    }

    private static <T extends IOPath> Optional<Tuple<String, String>> getInferredContentTypes(T ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        Optional<String> extension = ioPath.getExtension();
        if (extension.isPresent()) {
            String ext = extension.get();
            if (ext.equals(".vcf")) {
                return Optional.of(new Tuple<String, String>("VARIANT_CONTEXTS", "VCF"));
            }
            if (ext.equals(".vcf.gz") || ext.equals(".vcf.bgz")) {
                return Optional.of(new Tuple<String, String>("VARIANT_CONTEXTS", "VCF"));
            }
        }
        return Optional.empty();
    }
}

