/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class VCFFileReader
implements VCFReader {
    private final FeatureReader<VariantContext> reader;

    public static boolean isBCF(File file) {
        return VCFFileReader.isBCF(file.toPath());
    }

    public static boolean isBCF(Path path) {
        return path.toUri().getRawPath().endsWith(".bcf");
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        try (VCFFileReader vcfFileReader = new VCFFileReader(file, false);){
            SAMSequenceDictionary sAMSequenceDictionary = vcfFileReader.getFileHeader().getSequenceDictionary();
            return sAMSequenceDictionary;
        }
    }

    public VCFFileReader(File file) {
        this(file, true);
    }

    public VCFFileReader(File file, File indexFile) {
        this(file, indexFile, true);
    }

    public VCFFileReader(File file, boolean requireIndex) {
        this(file.toPath(), requireIndex);
    }

    public VCFFileReader(File file, File indexFile, boolean requireIndex) {
        this(file.toPath(), indexFile.toPath(), requireIndex);
    }

    private static FeatureCodec<VariantContext, ?> getCodecForPath(Path path) {
        return VCFFileReader.isBCF(path) ? new BCF2Codec() : new VCFCodec();
    }

    public static SAMSequenceDictionary getSequenceDictionary(Path path) {
        try (VCFFileReader r = new VCFFileReader(path, false);){
            SAMSequenceDictionary sAMSequenceDictionary = r.getFileHeader().getSequenceDictionary();
            return sAMSequenceDictionary;
        }
    }

    public VCFFileReader(Path path) {
        this(path, true);
    }

    public VCFFileReader(Path path, Path indexPath) {
        this(path, indexPath, true);
    }

    public VCFFileReader(Path path, boolean requireIndex) {
        this.reader = AbstractFeatureReader.getFeatureReader(path.toUri().toString(), VCFFileReader.getCodecForPath(path), requireIndex);
    }

    public VCFFileReader(Path path, Path indexPath, boolean requireIndex) {
        this.reader = AbstractFeatureReader.getFeatureReader(path.toUri().toString(), indexPath.toUri().toString(), VCFFileReader.getCodecForPath(path), requireIndex);
    }

    public static IntervalList toIntervalList(Path path) {
        return VCFFileReader.toIntervalList(path, false);
    }

    public static IntervalList toIntervalList(Path path, boolean includeFiltered) {
        try (VCFFileReader vcfReader = new VCFFileReader(path, false);){
            IntervalList intervalList = vcfReader.toIntervalList(includeFiltered);
            return intervalList;
        }
    }

    @Deprecated
    public static IntervalList fromVcf(File file) {
        return VCFFileReader.toIntervalList(file.toPath());
    }

    @Deprecated
    public static IntervalList fromVcf(File file, boolean includeFiltered) {
        return VCFFileReader.toIntervalList(file.toPath(), includeFiltered);
    }

    public IntervalList toIntervalList() {
        return this.toIntervalList(false);
    }

    public IntervalList toIntervalList(boolean includeFiltered) {
        return VCFFileReader.toIntervalList(this, includeFiltered);
    }

    @Deprecated
    public static IntervalList fromVcf(VCFFileReader vcf) {
        return VCFFileReader.fromVcf(vcf, false);
    }

    public static IntervalList toIntervalList(VCFFileReader vcf) {
        return VCFFileReader.toIntervalList(vcf, false);
    }

    @Deprecated
    public static IntervalList fromVcf(VCFFileReader vcf, boolean includeFiltered) {
        return VCFFileReader.toIntervalList(vcf, includeFiltered);
    }

    public static IntervalList toIntervalList(VCFFileReader vcf, boolean includeFiltered) {
        IntervalList intervalList = new IntervalList(vcf.getFileHeader().getSequenceDictionary());
        VCFFileReader.toIntervals(vcf, includeFiltered).forEachRemaining(intervalList::add);
        return intervalList;
    }

    public static Iterator<Interval> toIntervals(VCFFileReader vcf, boolean includeFiltered) {
        AtomicInteger intervalCount = new AtomicInteger(0);
        return vcf.iterator().stream().filter(vc -> includeFiltered || !vc.isFiltered()).map(vc -> {
            Object name = vc.getID();
            int intervalEnd = vc.getCommonInfo().getAttributeAsInt("END", vc.getEnd());
            if (".".equals(name) || name == null) {
                name = "interval-" + intervalCount.incrementAndGet();
            }
            return new Interval(vc.getContig(), vc.getStart(), intervalEnd, false, (String)name);
        }).iterator();
    }

    @Override
    public VCFHeader getHeader() {
        return (VCFHeader)this.reader.getHeader();
    }

    public final VCFHeader getFileHeader() {
        return this.getHeader();
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        try {
            return this.reader.iterator();
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not create an iterator from a feature reader.", ioe);
        }
    }

    @Override
    public CloseableIterator<VariantContext> query(String chrom, int start, int end) {
        try {
            return this.reader.query(chrom, start, end);
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not create an iterator from a feature reader.", ioe);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not close a variant context feature reader.", ioe);
        }
    }

    @Override
    public boolean isQueryable() {
        return this.reader.isQueryable();
    }
}

