/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CigarUtil {
    private static final Log log = Log.getInstance(CigarUtil.class);

    public static List<CigarElement> clipEndOfRead(int clipFrom, List<CigarElement> oldCigar, CigarOperator clippingOperator) {
        ValidationUtils.validateArg(clippingOperator.isClipping(), () -> "Clipping operator should be SOFT or HARD clip, found " + clippingOperator.toString());
        int clippedBases = CoordMath.getLength(clipFrom, Cigar.getReadLength(oldCigar));
        LinkedList<CigarElement> newCigar = new LinkedList<CigarElement>();
        int pos = 1;
        CigarElement oldCigarFinalElement = oldCigar.get(oldCigar.size() - 1);
        int trailingHardClipBases = oldCigarFinalElement.getOperator() == CigarOperator.HARD_CLIP ? oldCigarFinalElement.getLength() : 0;
        for (CigarElement c : oldCigar) {
            CigarOperator op = c.getOperator();
            int length = op.consumesReadBases() ? c.getLength() : 0;
            int endPos = pos + length - 1;
            if (endPos < clipFrom - 1) {
                newCigar.add(c);
            } else if (endPos >= clipFrom - 1) {
                CigarUtil.mergeClippingCigarElement(newCigar, c, clipFrom - 1 - (pos - 1), clippedBases, clippingOperator, trailingHardClipBases);
                break;
            }
            pos = endPos + 1;
        }
        return newCigar;
    }

    public static List<CigarElement> softClipEndOfRead(int clipFrom, List<CigarElement> oldCigar) {
        return CigarUtil.clipEndOfRead(clipFrom, oldCigar, CigarOperator.SOFT_CLIP);
    }

    private static void mergeClippingCigarElement(List<CigarElement> newCigar, CigarElement originalElement, int relativeClippedPosition, int clippedBases, CigarOperator newClippingOperator, int trailingHardClippedBases) {
        ValidationUtils.validateArg(newClippingOperator.isClipping(), () -> "Clipping operator should be SOFT or HARD clip, found " + newClippingOperator.toString());
        CigarOperator originalOperator = originalElement.getOperator();
        int clipAmount = clippedBases;
        if (newClippingOperator == CigarOperator.HARD_CLIP) {
            clipAmount += trailingHardClippedBases;
        }
        if (originalOperator.consumesReadBases()) {
            if ((originalOperator.consumesReferenceBases() || newClippingOperator == CigarOperator.HARD_CLIP) && relativeClippedPosition > 0) {
                newCigar.add(new CigarElement(relativeClippedPosition, originalOperator));
            }
            if (!originalOperator.consumesReferenceBases() && newClippingOperator != CigarOperator.HARD_CLIP || originalOperator == newClippingOperator) {
                clipAmount = clippedBases + relativeClippedPosition;
            }
        } else if (relativeClippedPosition != 0) {
            throw new SAMException("Unexpected non-0 relativeClippedPosition " + relativeClippedPosition);
        }
        newCigar.add(new CigarElement(clipAmount, newClippingOperator));
        if (newClippingOperator == CigarOperator.SOFT_CLIP && trailingHardClippedBases > 0) {
            newCigar.add(new CigarElement(trailingHardClippedBases, CigarOperator.HARD_CLIP));
        }
    }

    public static void softClip3PrimeEndOfRead(SAMRecord rec, int clipFrom) {
        CigarUtil.clip3PrimeEndOfRead(rec, clipFrom, CigarOperator.SOFT_CLIP);
    }

    public static void clip3PrimeEndOfRead(SAMRecord rec, int clipFrom, CigarOperator clippingOperator) {
        ValidationUtils.validateArg(clippingOperator.isClipping(), () -> "Clipping operator should be SOFT or HARD clip, found " + clippingOperator.toString());
        Cigar cigar = rec.getCigar();
        boolean negativeStrand = rec.getReadNegativeStrandFlag();
        List<CigarElement> oldCigar = cigar.getCigarElements();
        if (!CigarUtil.isValidCigar(rec, cigar, true)) {
            return;
        }
        int originalReadLength = rec.getReadLength();
        int originalReferenceLength = cigar.getReferenceLength();
        if (negativeStrand) {
            oldCigar = new ArrayList<CigarElement>(oldCigar);
            Collections.reverse(oldCigar);
        }
        List<CigarElement> newCigarElems = CigarUtil.clipEndOfRead(clipFrom, oldCigar, clippingOperator);
        if (negativeStrand) {
            Collections.reverse(newCigarElems);
        }
        Cigar newCigar = new Cigar(newCigarElems);
        if (negativeStrand) {
            int newLength;
            int oldLength = cigar.getReferenceLength();
            int sizeChange = oldLength - (newLength = newCigar.getReferenceLength());
            if (sizeChange > 0) {
                rec.setAlignmentStart(rec.getAlignmentStart() + sizeChange);
            } else if (sizeChange < 0) {
                throw new SAMException("The clipped length " + newLength + " is longer than the old unclipped length " + oldLength);
            }
        }
        rec.setCigar(newCigar);
        if (clippingOperator == CigarOperator.HARD_CLIP) {
            byte[] bases = rec.getReadBases();
            byte[] baseQualities = rec.getBaseQualities();
            if (originalReadLength != bases.length) {
                throw new SAMException("length of bases array (" + bases.length + ") does not match length expected based on cigar (" + String.valueOf(cigar) + ")");
            }
            if (originalReadLength != baseQualities.length) {
                throw new SAMException("length of baseQualities array (" + baseQualities.length + ") does not match length expected based on cigar (" + String.valueOf(cigar) + ")");
            }
            if (rec.getReadNegativeStrandFlag()) {
                rec.setReadBases(Arrays.copyOfRange(bases, bases.length - clipFrom + 1, originalReadLength));
                rec.setBaseQualities(Arrays.copyOfRange(baseQualities, baseQualities.length - clipFrom + 1, originalReadLength));
            } else {
                rec.setReadBases(Arrays.copyOf(bases, clipFrom - 1));
                rec.setBaseQualities(Arrays.copyOf(baseQualities, clipFrom - 1));
            }
        }
        boolean hasMappedBases = false;
        for (CigarElement elem : newCigar.getCigarElements()) {
            CigarOperator op = elem.getOperator();
            if (!op.consumesReferenceBases() || !op.consumesReadBases()) continue;
            hasMappedBases = true;
            break;
        }
        if (newCigar.getReferenceLength() != originalReferenceLength) {
            rec.setAttribute(SAMTag.NM, null);
            rec.setAttribute(SAMTag.MD, null);
            rec.setAttribute(SAMTag.UQ, null);
        }
        if (!hasMappedBases) {
            rec.setReadUnmappedFlag(true);
            rec.setCigarString("*");
            rec.setReferenceIndex(-1);
            rec.setAlignmentStart(0);
            rec.setMappingQuality(0);
            rec.setInferredInsertSize(0);
        } else {
            if (!CigarUtil.isValidCigar(rec, newCigar, false)) {
                throw new IllegalStateException("Invalid new Cigar: " + String.valueOf(newCigar) + " (" + String.valueOf(oldCigar) + ") for " + rec.getReadName());
            }
            if (rec.getReadLength() != newCigar.getReadLength()) {
                throw new IllegalStateException("new Cigar: " + String.valueOf(newCigar) + " implies different read base than record (" + rec.getReadLength() + ")");
            }
            if (rec.getReadBases().length != rec.getBaseQualities().length) {
                throw new IllegalStateException("new read bases have different length (" + rec.getReadBases().length + ") than new base qualities (" + String.valueOf(rec.getBaseQualities()) + ")");
            }
        }
    }

    private static boolean isValidCigar(SAMRecord rec, Cigar cigar, boolean isOldCigar) {
        List<SAMValidationError> validationErrors;
        if (cigar == null || cigar.getCigarElements() == null || cigar.getCigarElements().isEmpty()) {
            if (isOldCigar) {
                if (!rec.getReadUnmappedFlag()) {
                    log.warn("Cigar is empty for read " + String.valueOf(rec));
                }
            } else {
                log.error("Empty new cigar");
            }
            return false;
        }
        if (rec.getReadUnmappedFlag()) {
            log.info("Unmapped read with cigar: " + rec.getReadName() + " (" + rec.getCigarString() + "/" + cigar.toString() + ")");
        }
        if ((validationErrors = cigar.isValid(rec.getReadName(), -1L)) != null && !validationErrors.isEmpty()) {
            log.error("Invalid cigar for read " + String.valueOf(rec) + (isOldCigar ? " " : " for new cigar with clipped adapter ") + " (" + rec.getCigarString() + "/" + cigar.toString() + ") " + String.valueOf(validationErrors));
            return false;
        }
        if (rec.getReadLength() != cigar.getReadLength()) {
            log.error(rec.getReadLength() + " read length does not = cigar length " + cigar.getReferenceLength() + (isOldCigar ? " oldCigar " : " ") + String.valueOf(rec) + " cigar:" + String.valueOf(cigar));
            return false;
        }
        return true;
    }

    public static Cigar addClippedBasesToEndsOfCigar(Cigar cigar, boolean negativeStrand, int threePrimeEnd, int fivePrimeEnd, CigarOperator clippingOperator) {
        ValidationUtils.validateArg(clippingOperator.isClipping(), () -> "Clipping operator should be SOFT or HARD clip, found " + clippingOperator.toString());
        ArrayList<CigarElement> newCigar = new ArrayList<CigarElement>(cigar.getCigarElements());
        if (negativeStrand) {
            Collections.reverse(newCigar);
        }
        if (threePrimeEnd > 0) {
            int last = newCigar.size() - 1;
            int bases = threePrimeEnd;
            if (((CigarElement)newCigar.get(last)).getOperator() == clippingOperator) {
                CigarElement oldClip = (CigarElement)newCigar.remove(last);
                bases += oldClip.getLength();
            }
            newCigar.add(new CigarElement(bases, clippingOperator));
        }
        if (fivePrimeEnd > 0) {
            int bases = fivePrimeEnd;
            if (((CigarElement)newCigar.get(0)).getOperator().isClipping()) {
                CigarElement oldClip = (CigarElement)newCigar.remove(0);
                bases += oldClip.getLength();
            }
            newCigar.add(0, new CigarElement(bases, clippingOperator));
        }
        if (negativeStrand) {
            Collections.reverse(newCigar);
        }
        return new Cigar(newCigar);
    }

    public static Cigar addSoftClippedBasesToEndsOfCigar(Cigar cigar, boolean negativeStrand, int threePrimeEnd, int fivePrimeEnd) {
        return CigarUtil.addClippedBasesToEndsOfCigar(cigar, negativeStrand, threePrimeEnd, fivePrimeEnd, CigarOperator.SOFT_CLIP);
    }

    public static char[] cigarArrayFromElements(List<CigarElement> cigar) {
        int pos = 0;
        int length = 0;
        for (CigarElement e : cigar) {
            length += e.getLength();
        }
        char[] result = new char[length];
        for (CigarElement e : cigar) {
            for (int i = 0; i < e.getLength(); ++i) {
                CigarOperator o = e.getOperator();
                result[i + pos] = (char)CigarOperator.enumToCharacter(o);
            }
            pos += e.getLength();
        }
        return result;
    }

    public static char[] cigarArrayFromString(String cigar) {
        return CigarUtil.cigarArrayFromElements(TextCigarCodec.decode(cigar).getCigarElements());
    }

    public static String cigarStringFromArray(char[] cigar) {
        Object result = "";
        int length = cigar.length;
        char lastOp = '\u0000';
        int lastLen = 0;
        for (int i = 0; i < length; ++i) {
            if (cigar[i] == lastOp) {
                ++lastLen;
                continue;
            }
            if (cigar[i] == '-') continue;
            if (lastOp != '\u0000') {
                result = (String)result + Integer.toString(lastLen) + Character.toString(lastOp);
            }
            lastLen = 1;
            lastOp = cigar[i];
        }
        return (String)result + Integer.toString(lastLen) + Character.toString(lastOp);
    }
}

