/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.sra.SRAAccession;
import java.io.IOException;
import java.util.Iterator;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;
import ngs.ReferenceIterator;

public class SRAIndexedSequenceFile
implements ReferenceSequenceFile {
    private SRAAccession acc;
    private ReadCollection run;
    private Reference cachedReference;
    private Iterator<SAMSequenceRecord> sequenceRecordIterator;
    protected SAMSequenceDictionary sequenceDictionary;

    public SRAIndexedSequenceFile(SRAAccession acc) {
        this.acc = acc;
        if (!acc.isValid()) {
            throw new RuntimeException("Passed an invalid SRA accession into SRA reader: " + String.valueOf(acc));
        }
        try {
            this.run = NGS.openReadCollection((String)acc.toString());
            this.sequenceDictionary = this.loadSequenceDictionary();
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        this.reset();
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public ReferenceSequence nextSequence() {
        SAMSequenceRecord sequence = this.sequenceRecordIterator.next();
        return this.getSubsequenceAt(sequence.getSequenceName(), 1L, sequence.getSequenceLength());
    }

    @Override
    public void reset() {
        this.sequenceRecordIterator = this.sequenceDictionary.getSequences().iterator();
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        return this.getSubsequenceAt(contig, 1L, this.sequenceDictionary.getSequence(contig).getSequenceLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        byte[] bases;
        SAMSequenceRecord sequence = this.sequenceDictionary.getSequence(contig);
        int referenceIndex = sequence.getSequenceIndex();
        try {
            SRAIndexedSequenceFile sRAIndexedSequenceFile = this;
            synchronized (sRAIndexedSequenceFile) {
                if (this.cachedReference == null || !this.cachedReference.getCanonicalName().equals(contig)) {
                    this.cachedReference = this.run.getReference(contig);
                }
                Reference reference = this.cachedReference;
                bases = reference.getReferenceBases(start - 1L, stop - (start - 1L)).getBytes();
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return new ReferenceSequence(contig, referenceIndex, bases);
    }

    @Override
    public void close() throws IOException {
        this.cachedReference = null;
    }

    protected SAMSequenceDictionary loadSequenceDictionary() throws ErrorMsg {
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        ReferenceIterator itRef = this.run.getReferences();
        while (itRef.nextReference()) {
            dict.addSequence(new SAMSequenceRecord(itRef.getCanonicalName(), (int)itRef.getLength()));
        }
        return dict;
    }
}

